#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# eSpeakCaller for Maemo 5.
#
# Author: Arto Rusanen
# Date: 2010.03.23
#
# File: espeakcaller.py
# Version: 0.4
# 
# Special thanks to: 
#    Original eSpeak project: http://espeak.sourceforge.net/
#    Kaj-Michael Lang (eSpeak) eSpeak package :)
#    Nick Leppänen Larsson (fMMS) original phonebook code
#    V@s3K (pyCallBlocker) skeleton for this program
#

daemonFile = '/opt/espeakcaller/espeakcaller-daemon.py'
pidFile = '/tmp/espeakcaller_pid.txt'
cfgFileUI = "~/.espeakcaller/espeakcaller_ui.conf"
cfgFileDaemon = "~/.espeakcaller/espeakcaller_daemon.conf"

from PyQt4 import QtGui, QtCore
from PyQt4.QtCore import SIGNAL, SLOT
import sys
import subprocess
import os.path
from espeakcaller_ui import Ui_MainWindow
from espeakcaller_about import Ui_Dialog


class eSpeakCaller(QtGui.QMainWindow):
    # Load our new ultra awesome GUI.
    # Made with Qt Designer :)
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_MainWindow()
        self.ui.setupUi(self)
        self.loadsettings()
    
    
    # Load settings.
    def loadsettings(self):
        try:
            cfgTmp = os.path.expanduser(cfgFileUI)
            if os.path.exists(cfgTmp): 
                tmpStr = ""
                pdFile = open(cfgTmp, 'r')
                
                tmpStr = pdFile.readline().strip() # Unknown caller name
                self.ui.lineUnCaller.setText(tmpStr)
                    
                tmpStr = pdFile.readline().strip() # Spoken language
                self.ui.comboLang.setCurrentIndex(int(tmpStr))
                    
                tmpStr = pdFile.readline().strip() # Additional parameters
                self.ui.lineAParams.setText(tmpStr)
                    
                tmpStr = pdFile.readline().strip() # Spoken line
                self.ui.lineSay.setText(tmpStr)
                
                tmpStr = str(pdFile.readline().strip()) # Volume
                self.ui.sliVolume.setValue(int(tmpStr))
                
                tmpStr = str(pdFile.readline().strip()) # Pitch
                self.ui.sliPitch.setValue(int(tmpStr))
                
                tmpStr = str(pdFile.readline().strip()) # Speed
                self.ui.sliSpeed.setValue(int(tmpStr))
                
                tmpStr = pdFile.readline().strip() # Blocked number
                self.ui.lineBlCaller.setText(tmpStr)
                
                tmpStr = pdFile.readline().strip() # Use nickname
                if tmpStr == "1":
                    self.ui.checkNickname.setCheckState(-1)
                else:
                     self.ui.checkNickname.setCheckState(0)   
                                     
                tmpStr = pdFile.readline().strip() # Repeat option
                if tmpStr == "1":
                    self.ui.checkRepeat.setCheckState(-1)
                else:
                    self.ui.checkRepeat.setCheckState(0)   
                tmpStr = pdFile.readline().strip() # Repeat option
                self.ui.sliRepeat.setValue(int(tmpStr))
                pdFile.close()
          
            if os.path.exists(pidFile):
                self.ui.checkEnabled.setCheckState(-1)
        except Exception, errtxt:
            print errtxt
            pass
                        
        
    # Save settings
    def SaveSettings(self):
        # Check if we need to create directory
        cfgTmp = os.path.expanduser(cfgFileUI)
        if not os.path.exists(os.path.dirname(cfgTmp)):
            os.makedirs(os.path.dirname(cfgTmp))
        
        if os.path.exists(cfgTmp): 
            os.remove(cfgTmp) # Remove old settings.
        
        # Save UI settings
        pdFile = open(cfgTmp, 'w+')
        pdFile.write(self.ui.lineUnCaller.displayText() + '\n')
        pdFile.write(str(self.ui.comboLang.currentIndex()) + '\n')
        pdFile.write(self.ui.lineAParams.displayText() + '\n')
        pdFile.write(self.ui.lineSay.displayText() + '\n')
        pdFile.write(str(self.ui.sliVolume.value()) + '\n')
        pdFile.write(str(self.ui.sliPitch.value()) + '\n')
        pdFile.write(str(self.ui.sliSpeed.value()) + '\n')
        pdFile.write(self.ui.lineBlCaller.displayText() + '\n')
        if self.ui.checkNickname.isChecked():
            pdFile.write("1" + '\n')
        else:
            pdFile.write("0" + '\n')
        if self.ui.checkRepeat.isChecked():
            pdFile.write("1" + '\n')
        else:
            pdFile.write("0" + '\n')
        pdFile.write(str(self.ui.sliRepeat.value()) + '\n')                    
        pdFile.close()
        
        # Save settings for Daemon
        cfgTmp = os.path.expanduser(cfgFileDaemon)
        if os.path.exists(cfgTmp): 
            os.remove(cfgTmp) # Remove old settings.
             
        pdFile = open(cfgTmp, 'w+')
        pdFile.write(self.GeteSpeakCommand() + '\n')
        pdFile.write(self.ui.lineSay.displayText() + '\n')
        pdFile.write(self.ui.lineUnCaller.displayText() + '\n')
        pdFile.write(self.ui.lineBlCaller.displayText() + '\n')
        if self.ui.checkNickname.isChecked():
            pdFile.write("1" + '\n')
        else:
             pdFile.write("0" + '\n')
        if self.ui.checkRepeat.isChecked():
            pdFile.write(str(self.ui.sliRepeat.value()) + '\n') 
        else:
            pdFile.write("0" + '\n')
                    
        pdFile.close()
        

    # Generates hopefully valid eSpeak command.
    def GeteSpeakCommand(self):
        # Damn eSpeak supports lot of langueages
        sLang=['',' -ven',' -ven-us',' -ven-sc',' -vaf',' -vbs',' -vca',' -vcs',' -vde',' -vel',' -veo',' -ves',' -ves-la',' -vfi',' -vfr',' -vhr',' -vhu',' -vit',' -vku',' -vlv',' -vpl',' -vpt',' -vpt-pt',' -vro',' -vsk',' -vsr',' -vsv',' -vsw',' -vta',' -vtr',' -vzh']
        tmpCmd = "espeak -m " + sLang[self.ui.comboLang.currentIndex()] + " "
        tmpCmd = tmpCmd + "-a " + str(self.ui.sliVolume.value()) + " "
        tmpCmd = tmpCmd + "-p " + str(self.ui.sliPitch.value()) + " "
        tmpCmd = tmpCmd + "-s " + str(self.ui.sliSpeed.value()) + " "
        tmpCmd = tmpCmd + self.ui.lineAParams.displayText() + " "
        tmpCmd = tmpCmd + "'%text%'"
        
        return tmpCmd
       
       
    # Test eSpeak 
    def slotTest(self):
        if self.ui.lineBlCaller.displayText() != "":
            tmpName = self.ui.lineBlCaller.displayText()
        else:
            tmpName = self.ui.lineSay.displayText().replace("%name%", "Test")

        tmpS = self.GeteSpeakCommand().replace("%text%", tmpName)#.decode('utf-8')
        #print tmpS
        subprocess.Popen(unicode(tmpS).encode("utf-8"), shell=True)
        
        
    # Apply settings
    def slotApply(self):
        #self.restartDaemon()
        self.StopDaemon()
        self.SaveSettings()
        if self.ui.checkEnabled.isChecked():
            self.StartDaemon()
        
    # Show new cool About box :) (well not really that cool...)
    def slotAbout(self):
        AboutBox = QtGui.QDialog()
        AboutBox.ui = Ui_Dialog()
        AboutBox.ui.setupUi(AboutBox)
        AboutBox.show()
        AboutBox.exec_()
        
        
    # Stop Daemon
    def StopDaemon(self):
        try:
            pdFile = open(pidFile, 'r+')
            pid = pdFile.readline().strip()
            subprocess.Popen("kill -9 " + str(pid), shell=True)
            pdFile.close()
            os.remove(pidFile)
        except:
            pass
    
    # Start Daemon    
    def StartDaemon(self):
        self.StopDaemon() # Just in case...
        
        proc = subprocess.Popen("python2.5 " + daemonFile + " &", shell=True)
        
        pdFile = open(pidFile, 'w+')
        pdFile.write(str(proc.pid + 1))
        pdFile.close()

# Execution
if __name__ == "__main__":
    app = QtGui.QApplication(sys.argv)
    myapp = eSpeakCaller()
    myapp.show()
    sys.exit(app.exec_())

        
