#!/usr/bin/env python
import os
import time
import gobject, dbus
from dbus.mainloop.glib import DBusGMainLoop
import sys
import subprocess
import evolution
import os.path


cfgFile = "~/.espeakcaller/espeakcaller.conf"
curCommand = "espeak '%name% is calling.'"
unkNum = "Unknown number"
eSpeakProc = 0


def get_name_from_number(number):
    #  Taken from fMMS (modified)
    #  Should get caller name from phonebook
    #  I wonder if there is better/faster way to do this...
    #
    ### do some voodoo here
    
    if (len(number) == 0) :
        return unkNum
      
    ab = evolution.ebook.open_addressbook("default")
    contacts = ab.get_all_contacts()
    for c in contacts:
        fname = c.get_name()
        vcardlist = c.get_vcard_string().replace('\r', '').split('\n')
        for line in vcardlist:
            if line.startswith("TEL"):
                nr = line.split(":")[1]
                if nr != None:
                    if nr == number: 
                        return fname
                
    return number


# Incoming phonecall...
def handle_call(obj_path, callernumber):
    global eSpeakProc
    
    CallerName = get_name_from_number(callernumber)
    time.sleep(1) # Wait a sec. (I get laggy speak without this)
    eSpeakProc = subprocess.Popen(str(curCommand.replace("%name%", CallerName)), shell=True)


# TODO: Make espeak repeat saying caller name (I really have no idea how to implement this...)

# Try to stop eSpeak if call is answered or call is cancelled.
# Maybe in future when this says caller name multiple times :)
def call_status(state,ukn1,ukn2):
    print "state: %d  ukn1: %d  ukn2: %d" % (state,ukn1,ukn2)
    global eSpeakProc
    
    if state == 0: #or state == ??: # Ringing ended (0) or phone answered (??)?
        if not eSpeakProc == 0:
            subprocess.Popen("kill -9 " + str(eSpeakProc.pid + 1), shell=True)
            eSpeakProc = 0
            
# def Main
try:
    pdFile = open(os.path.expanduser(cfgFile), 'r+')
    curCommand = str(pdFile.readline().strip())
    unkNum = str(pdFile.readline().strip())
    if unkNum == "":
        unkNum = "Unknown number"
    pdFile.close()
except:
    pass

DBusGMainLoop(set_as_default=True)
bus = dbus.SystemBus()
bus.add_signal_receiver(handle_call, path='/com/nokia/csd/call', dbus_interface='com.nokia.csd.Call', signal_name='Coming')
bus.add_signal_receiver(call_status, path=None, dbus_interface='com.nokia.csd.Call.Instance', signal_name='CallStatus')

gobject.MainLoop().run()
