#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# eSpeakCaller for Maemo 5.
#
# Author: Arto Rusanen
# Date: 2010.03.15
#
# File: espeakcaller.py
# Version: 0.1
# 
# Special thanks to: 
#    Kaj-Michael Lang (eSpeak) eSpeak package :)
#    Nick Leppänen Larsson (fMMS) phonebook code
#    V@s3K (pyCallBlocker) skeleton for this program
#

daemonFile = '/opt/espeakcaller/espeakcaller-daemon.py'
pidFile = '/tmp/espeakcaller_pid.txt'
cfgFile = "~/.espeakcaller/espeakcaller.conf"


from PyQt4 import QtGui, QtCore
from PyQt4.QtCore import SIGNAL, SLOT
import sys
import subprocess
import os.path


class PySpeakCaller(QtGui.QWidget):
    def __init__(self, parent = None):
        QtGui.QWidget.__init__(self, parent)
        self.setWindowTitle("eSpeakCaller")
        self.label = QtGui.QLabel("eSpeak Command (%name% = caller name)", self)
        
        #self.number_list = QtGui.QListWidget(self)
        try:
            pdFile = open(os.path.expanduser(cfgFile), 'r+')
            self.curCommand = str(pdFile.readline().strip())
            pdFile.close()
        except:
            self.curCommand = "espeak '%name% is calling.'"
            pass
        
        self.espeak_command = QtGui.QTextEdit(self.curCommand, self)
        
        self.start_button = QtGui.QPushButton("(Re)Start daemon", self)
        self.stop_button = QtGui.QPushButton("Stop daemon", self)
        
        self.layout = QtGui.QVBoxLayout(self)
        self.layout.addWidget(self.label)
        self.layout.addWidget(self.espeak_command)
        
        self.butt_layout = QtGui.QHBoxLayout()
        self.butt_layout.addWidget(self.start_button)
        self.butt_layout.addWidget(self.stop_button)
        self.layout.addLayout(self.butt_layout)
        
        self.connect(self.start_button, SIGNAL('clicked()'), self.slotstart)
        self.connect(self.stop_button, SIGNAL('clicked()'), self.slotstop)
        
        self.restartDaemon()
        
    def slotstart(self):
        self.restartDaemon()
    
    def slotstop(self):
        try:
            pdFile = open(pidFile, 'r+')
            pid = pdFile.readline().strip()
            subprocess.Popen("kill -9 " + str(pid), shell=True)
            pdFile.close()
        except:
            pass
    
        
    def restartDaemon(self):
        try:
            pdFile = open(pidFile, 'r+')
            pid = pdFile.readline().strip()
            subprocess.Popen("kill -9 " + str(pid), shell=True)
            pdFile.close()
        except:
            pass
        
        cfgTmp = os.path.expanduser(cfgFile)
        if not os.path.exists(cfgTmp):
            os.makedirs(os.path.dirname(cfgTmp))
        
        pdFile = open(cfgTmp, 'w+')
        pdFile.write(str(self.espeak_command.toPlainText()))
        pdFile.close()
        
        proc = subprocess.Popen("python2.5 " + daemonFile + " &", shell=True)
        
        pdFile = open(pidFile, 'w+')
        pdFile.write(str(proc.pid + 1))
        pdFile.close()

# Execution
app = QtGui.QApplication(sys.argv)
myWindow = PySpeakCaller()
myWindow.show()
sys.exit(app.exec_())
        
