#ifndef GAMEMODEL_H
#define GAMEMODEL_H

/*
  EightyOne - A simple Sudoku solving game
  Copyright (C) 2006  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Base/Model.h>

#include "Sudoku.h"

class GameModel : public Lum::Base::Model
{
public:
  class ValueChanged : public Lum::Base::ResyncMsg
  {
  };

  class StateChanged : public Lum::Base::ResyncMsg
  {
  };

private:
  Sudoku game;
  Sudoku riddle;
  Sudoku solution;
  size_t marks[Sudoku::size];
  size_t focusedCell;
  bool   finished;

private:
  void NotifyValueChanged();
  void SetFinished(bool finished);

public:
  GameModel();

  void Set(const Sudoku &riddle,
           const Sudoku &solution);
  void Set(const Game& game);
  void Clear();

  void Get(Game& game) const;
  void Get(Sudoku& game) const;
  size_t Get(size_t pos) const;

  void SetFocusedCell(size_t focusedCell);

  void GetRiddle(Sudoku& riddle) const;
  void GetSolution(Sudoku& solution) const;
  size_t GetRiddle(size_t pos) const;
  size_t GetSolution(size_t pos) const;
  void GetPotential(size_t pos, Sudoku::Bitset& possible) const;
  size_t GetMarks(size_t pos) const;

  bool IsValid() const;
  bool IsFinished() const;

  bool IsFocusedCellEditable() const;
  bool IsCellInMarkModus() const;
  size_t GetFocusedCell() const;
  size_t GetFocusedCellValue() const;
  size_t GetFocusedCellMarks() const;

  void SetFocusedCellValue(size_t value);
  void SetFocusedCellMarks(size_t value);
  void MarkEmpty();

  void Solve();
};

typedef Lum::Base::Reference<GameModel> GameModelRef;

#endif
