/* This file is part of effing
 *
 * Copyright (C) 2010 Richard Merren <richard@merren.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "settingsmanager.h"
#include "constants.h"


SettingsManager::SettingsManager(QObject *parent) :
    QObject(parent)
{
    settings = new QSettings(COMPANY_NAME,PROGRAM_NAME);

    //compare the current auth version to what is saved to see if we need
    //to force a login due to changed permission needs
    int recent_auth_version = get_auth_version();
    if (CURRENT_AUTH_VERSION > recent_auth_version)
    {
        clear_facebook_auth();
        set_auth_version(CURRENT_AUTH_VERSION);
    }
}

SettingsManager::~SettingsManager()
{
    delete settings;
}

QString SettingsManager::get_facebook_auth()
{
    settings->beginGroup(FB_GROUP);
    bool prefer_g_rated_tag = settings->value(PROP_TAG_LINE_PREF,false).toBool();
    QString prop_key;
    if (prefer_g_rated_tag)
        prop_key = PROP_AUTH_KEY_G_RATED;
    else
        prop_key = PROP_AUTH_KEY_EFFING;
    QString auth_key = settings->value(prop_key,QString()).toString();
    settings->endGroup();
    return auth_key;
}

void SettingsManager::set_facebook_auth(QString auth_key)
{
    settings->beginGroup(FB_GROUP);
    bool prefer_g_rated_tag = settings->value(PROP_TAG_LINE_PREF,false).toBool();
    QString prop_key;
    if (prefer_g_rated_tag)
        prop_key = PROP_AUTH_KEY_G_RATED;
    else
        prop_key = PROP_AUTH_KEY_EFFING;
    settings->setValue(prop_key,auth_key);
    settings->endGroup();
    settings->sync();
}

void SettingsManager::clear_facebook_auth()
{
    settings->beginGroup(FB_GROUP);
    settings->setValue(PROP_AUTH_KEY_G_RATED,"");
    settings->setValue(PROP_AUTH_KEY_EFFING,"");
    if (settings->contains(PROP_AUTH_KEY_OLD))
        settings->setValue(PROP_AUTH_KEY_OLD,"");
    settings->endGroup();
    settings->sync();
}

void SettingsManager::set_prefer_facebook_touch(bool prefer_touch)
{
    settings->beginGroup(FB_GROUP);
    settings->setValue(PROP_PREFER_TOUCH,prefer_touch);
    settings->endGroup();
    settings->sync();
}

bool SettingsManager::is_prefer_facebook_touch()
{
    settings->beginGroup(FB_GROUP);
    bool prefer_touch = settings->value(PROP_PREFER_TOUCH,false).toBool();
    settings->endGroup();
    return prefer_touch;
}

void SettingsManager::set_prefer_g_rated_tag_line(bool prefer_g_rated)
{
    settings->beginGroup(FB_GROUP);
    settings->setValue(PROP_TAG_LINE_PREF,prefer_g_rated);
    settings->endGroup();
    settings->sync();
}

bool SettingsManager::is_prefer_g_rated_tag_line()
{
    settings->beginGroup(FB_GROUP);
    bool prefer_g_rated_tag = settings->value(PROP_TAG_LINE_PREF,false).toBool();
    settings->endGroup();
    return prefer_g_rated_tag;
}

bool SettingsManager::is_show_config_first()
{
    settings->beginGroup(FB_GROUP);
    bool show_config = settings->value(PROP_SHOW_INITIAL_CONFIG,true).toBool();
    settings->endGroup();
    return show_config;
}

void SettingsManager::set_show_config_first(bool show_config)
{
    settings->beginGroup(FB_GROUP);
    settings->setValue(PROP_SHOW_INITIAL_CONFIG,show_config);
    settings->endGroup();
    settings->sync();
}

int SettingsManager::get_auth_version()
{
    settings->beginGroup(FB_GROUP);
    bool ok;
    int auth_version = settings->value(PROP_AUTH_VERSION,-1).toInt(&ok);
    settings->endGroup();
    if (!ok) auth_version = -1;
    return auth_version;
}

void SettingsManager::set_auth_version(int version)
{
    settings->beginGroup(FB_GROUP);
    settings->setValue(PROP_AUTH_VERSION,version);
    settings->endGroup();
    settings->sync();
}

QString SettingsManager::get_app_id()
{
    if (is_prefer_g_rated_tag_line())
        return FACEBOOK_APP_ID_G_RATED;
    else
        return FACEBOOK_APP_ID;
}
