import Qt 4.7

Rectangle { id:newStatusRectangle;
    width: 500
    height: 150
    border.width:1;
    border.color:"gray";
    opacity: 1;
    color: "black"
        Text {id: status_instructions;
            anchors.horizontalCenter: newStatusRectangle.horizontalCenter;
            anchors.verticalCenter: newStatusRectangle.verticalCenter;
            text:"new status";
            font.family: "Arial, Helvetica, Sans-Serif";
            color:"gray";
            font.pixelSize: newStatusRectangle.height/2;
            font.weight: Font.Black;
            opacity: 0.5;
        }//Text

        SequentialAnimation {
            id: status_instructions_animation;
            NumberAnimation {
                target: status_instructions; properties: "opacity";
                from: 0.5; to: 0.1; duration: 7500;
                easing.type: "OutExpo";
            }
            NumberAnimation {
                target: status_instructions; properties: "opacity";
                from: 0.1; to: 0.5; duration: 7500;
                easing.type: "OutExpo";
            }
            loops: Animation.Infinite

            //running:true;
        } //SequentialAnimation

    Flickable {id : newStatusFlick;
        anchors.fill: newStatusRectangle;
        contentWidth: newStatusText.paintedWidth;
        contentHeight: newStatusText.paintedHeight;
        clip: true;

        function ensureVisible(r) {
            if (contentX >= r.x)
                contentX = r.x
            else if (contentX+width <= r.x+r.width)
                contentX = r.x+r.width-width;
            if (contentY >= r.y)
                contentY = r.y;
            else if (contentY+height <= r.y+r.height)
                contentY = r.y+r.height-height;
        } //function

        TextEdit { id: newStatusText;
            width: newStatusFlick.width;
            height: newStatusFlick.height;
            text: "Testing 1,2,3";
            color: "white";
            font.family: "Arial, Helvetica, Sans-Serif";
            wrapMode: Text.Wrap;
            onCursorRectangleChanged: newStatusFlick.ensureVisible(cursorRectangle);
            clip: true;
        } // Textedit
    } //Flickable

    property alias statusText: newStatusText.text
}//Rectangle
