#ifndef GEOGRAPHY_H
#define GEOGRAPHY_H

#include <QObject>
#include <QGeoPositionInfoSource>
#include <QGeoPositionInfo>
#include <QList>
#include <QPointer>
#include <QVariant>

QTM_USE_NAMESPACE

class Geography : public QObject
{
    Q_OBJECT
public:
    explicit Geography(QObject *parent = 0);
    static const int GPS_STATUS_ERROR = -1;
    static const int GPS_STATUS_UNAVAILABLE = 0;
    static const int GPS_STATUS_READY = 1;
    static const int GPS_STATUS_SEARCHING = 2;
    static const int GPS_STATUS_SUCCESS = 3;

signals:
    void obtained_location(qreal latitude, qreal longitude);
    void gps_status(int gps_status);

public slots:
    void request_current_location();
    void request_gps_status();
    void stop_gps();

private slots:
    void positionUpdated(QGeoPositionInfo geoPositionInfo);
//    void satellitesInUseUpdated(QList<QGeoSatelliteInfo> &satellites);

private:
    qint8 current_status;
    QPointer<QGeoPositionInfoSource> location_data_source;
//    QPointer<QGeoSatelliteInfoSource> satellite_info_source;

    void request_location();
    void update_status(int status);
    int satellite_count;

};

#endif // GEOGRAPHY_H
