#ifndef FACEBOOKGRAPH_H
#define FACEBOOKGRAPH_H

#include <QObject>
#include <QLatin1String>
#include <QList>
#include <QScriptEngine>
#include <QScriptValue>

//Include all includes so they are available to anything including this guy
#include "facebookgraph/message.h"
#include "facebookgraph/comment.h"

class FacebookGraph : public QObject
{
    Q_OBJECT
public:
    explicit FacebookGraph(QObject *parent = 0, QString facebookJson="");
    enum ParseResult {ERROR, MESSAGES, STATUS_SUCCESSFUL};
    ParseResult getParseResult() {return _parseResult;}
    QList<Message *> getMessages() {return _messages;}

    QString getFormattedMessage();

signals:

public slots:

private:
    QString _facebookJson;
    ParseResult _parseResult;
    QList<Message *> _messages;

    void parseResponse();
    Message* parseDataEntry(QScriptValue data_entry);
    Comment* parseComment(QScriptValue comment_data_entry, Message* parent);
    QDateTime parseTime(QScriptValue jsonNode);
    QString formatTimestamp(QDateTime timestamp);

    static const QLatin1String OPEN_PAREN;
    static const QLatin1String CLOSE_PAREN;
};

#endif // FACEBOOKGRAPH_H
