import Qt 4.7

Rectangle {
    width: 200
    height: 300

    property string selectedPlaceId : "";
    property alias listModel: placesList.model
    color: "black"

    ListModel {
        id: mockPlacesListModel
        ListElement {
            placeId: "0"
            placeName: "None"
            placeAddress: "Unknown"
        }
    }

    Component {
        id: placesListDelegate
        Rectangle {
            id: delegateRect
            height: delegateText.height * 1.75
            width: parent.width
            property string itemPlaceId: placeId
            color: "black"
            Rectangle {
                id: topBar
                width: parent.width
                height: 1
                anchors.top: parent.top
                color: "gray"
            }

            Text {
                anchors.horizontalCenter:parent.horizontalCenter;
                y: height * 0.375  //This should center it within the height * 1.75 range
                id: delegateText
                text: placeName + " (<i>" + placeAddress + "</i>)"
                color:"white"
            }

            Rectangle {
                id: bottomwBar
                width: parent.width
                height: 1
                anchors.bottom: parent.bottom;
                color: "gray"
            }

            MouseArea {
                anchors.fill: parent
                onClicked: {
                    selectedPlaceId = parent.itemPlaceId;
                }
            }
            states: [
                State {
                    name: "selected"
                    when: (placeId==selectedPlaceId)
                    PropertyChanges {
                        target: delegateRect
                        color: "red"
                    }
                }
            ]

        }
    }

    ListView {
        id: placesList
        anchors.fill: parent
        delegate: placesListDelegate
        model: mockPlacesListModel
        clip:true;
        onModelChanged: {
            selectedPlaceId = "";
        }
    }

}
