 import Qt 4.7


Rectangle {
    id: blackButton
    width: 100; height: 100;
    color: "#111111"

    signal blackButtonClicked;
    
    Rectangle {
        width: 1;
        height: parent.height;
        anchors.left: parent.left;
        anchors.top: parent.top;
        anchors.bottom: parent.bottom;
        color: "gray";
    }

    Rectangle {
        width: parent.width;
        height: 1;
        anchors.left: parent.left;
        anchors.top: parent.top;
        anchors.right: parent.right;
        color: "gray";
    }

    states: [
        State {
            name: "up";
            PropertyChanges { target: down_anim; running: false; }
            PropertyChanges { target: up_anim; running: true; }
        },

        State {
            name: "down";
            PropertyChanges { target: down_anim; running: true; }
        }
    ]

    // transition is unfinished, possibly not needed at all, because states take care of it
    transitions: [
        Transition {
            from: "up"; to: "down";
        }
    ]

    MouseArea {
        anchors.fill: parent;
        onPressed: parent.state = "down";
        onReleased: {
            parent.state = "up";
            onClicked: blackButtonClicked();
        }
    }

    SequentialAnimation {
        id: down_anim;
        NumberAnimation {
            target: blackButton; properties: "scale";
            from: 1.0; to: 0.8; duration: 100;
            easing.type: "OutExpo";
        }
        NumberAnimation {
            target: blackButton; properties: "opacity";
            from: 1.0; to: 0.5; duration: 100;
            easing.type: "OutExpo";
        }

        running:false;
    }

    SequentialAnimation {
        id: up_anim;

        NumberAnimation {
            target: blackButton; properties: "opacity";
            from: 0.5; to: 1.0; duration: 10;
            easing.type: "OutExpo";
        }
        NumberAnimation {
            target: blackButton; properties: "scale"
            from: 0.8; to: 1.0; duration: 10;
        }

        running:false;
    }

    Image {
        id: button_image;
        source: "";
        anchors.fill: parent;
        anchors.margins: parent.width / 20;
    }

    Text {
        anchors.centerIn: parent;
        id: button_text;
        color: "gray";
        text: "0";
        font.family: "Arial, Helvetica, Sans-Serif";
        font.weight: Font.Bold;
    }
    property alias label: button_text.text;
    property alias image_source: button_image.source;

}
