/* This file is part of effing
 *
 * Copyright (C) 2010 Richard Merren <richard@merren.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "browserlauncher.h"
#include "constants.h"
#include <QDebug>

BrowserLauncher::BrowserLauncher(QObject *parent) :
    QObject(parent)
{
}

void BrowserLauncher::launch_facebook()
{
    prefer_touch = settings_manager.is_prefer_facebook_touch();
    if (prefer_touch) launch_facebook_touch();
    else launch_facebook_full();
}

void BrowserLauncher::launch_facebook_full()
{
    desktop_services.openUrl(FACEBOOK_FULL_URL);
}

void BrowserLauncher::launch_facebook_touch()
{
    desktop_services.openUrl(FACEBOOK_TOUCH_URL);
}

