/* This file is part of effing
 *
 * Copyright (C) 2010 Richard Merren <richard@merren.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <QtGui/QApplication>
#include <QGraphicsObject>
#include <QtDeclarative/QDeclarativeView>
#include <QUrl>
#include "fbactions.h"
#include "browserlauncher.h"

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);

    FbActions fb_actions;
    BrowserLauncher browser_launcher;

    //Create our QML object
    QDeclarativeView view;
    view.setSource(QUrl("qrc:/eff.qml"));
    view.setResizeMode(QDeclarativeView::SizeRootObjectToView);
    view.setWindowTitle("Effing Status Updater");
    QObject *qmlObject = dynamic_cast<QObject*>(view.rootObject());

    QObject::connect(&fb_actions,SIGNAL(status_available(QVariant)),qmlObject,SLOT(setOldStatus(QVariant)));
    QObject::connect(qmlObject,SIGNAL(refreshClicked()),&fb_actions,SLOT(request_status()));
    QObject::connect(qmlObject,SIGNAL(submitClicked(QString)),&fb_actions,SLOT(set_status(QString)));
    QObject::connect(&fb_actions,SIGNAL(status_successfully_set()),qmlObject,SLOT(clearStatusBox()));
    QObject::connect(qmlObject,SIGNAL(configClicked()),&fb_actions,SLOT(do_configuration()));
    QObject::connect(qmlObject,SIGNAL(facebookClicked()),&browser_launcher,SLOT(launch_facebook()));
    QObject::connect(qmlObject,SIGNAL(mysteryClicked()),&fb_actions,SLOT(do_not_implemented()));

#if defined(Q_WS_MAEMO_5)
    view.setGeometry(QRect(0,0,800,400)); //This is Maemo with menu showing
    view.show();
#elif defined(Q_WS_S60)
    view.setGeometry(QRect(0,0,640,360));
    view.showMaximized();
#else
    view.setGeometry(QRect(100,100,800, 480));
    view.show();
#endif
    fb_actions.request_status();
    return a.exec();
}
