#ifndef MESSAGE_H
#define MESSAGE_H

#include <QObject>
#include <QDateTime>
#include <QList>
#include "facebookgraph/comment.h"

class Message : public QObject
{
    Q_OBJECT
public:
    explicit Message(QObject *parent = 0);
    enum MessageType {STATUS,CHECKIN};

    int getId() {return this->_id;}
    void setId(int id) {this->_id = id;}
    MessageType getMessageType() {return this->_messageType;}
    void setMessageType(MessageType messageType) {this->_messageType = messageType;}

    QString getText() {return this->_text;}
    void setText(QString text) {this->_text = text;}
    QDateTime getTimestamp() {return this->_timestamp;}
    void setTimestamp(QDateTime timestamp) {this->_timestamp = timestamp;}

    void addComment(Comment *comment) {this->_comments.append(comment);}
    QList<Comment *> getComments() {return this->_comments;}

signals:

public slots:

private:
    int _id;
    MessageType _messageType;
    QString _authorName;
    int _authorId;
    QString _text;
    QDateTime _timestamp;
    QList<Comment *> _comments;

};

#endif // MESSAGE_H
