# This file is part of effing
#
# Copyright (C) 2010 Richard Merren <richard@merren.net>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public License
# along with this library; see the file COPYING.LIB.  If not, write to
# the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA 02110-1301, USA.
#


QT       += core gui webkit network script

TARGET = effing
TEMPLATE = app

SOURCES += main.cpp\
    logindialog.cpp \
    fbactions.cpp \
    settingsmanager.cpp \
    browserlauncher.cpp \
    configdialog.cpp \
    facebookgraph/facebookgraph.cpp \
    facebookgraph/message.cpp \
    facebookgraph/comment.cpp

HEADERS  += \
    logindialog.h \
    constants.h \
    fbactions.h \
    settingsmanager.h \
    browserlauncher.h \
    configdialog.h \
    facebookgraph/facebookgraph.h \
    facebookgraph/message.h \
    facebookgraph/comment.h

FORMS    += \
    configdialog.ui

CONFIG += mobility
MOBILITY = 

QT += declarative

#uncomment to get rid of debug output
#DEFINES += QT_NO_DEBUG_OUTPUT

symbian {
    TARGET.UID3 = 0xe204248a
    # TARGET.CAPABILITY += 
    TARGET.EPOCSTACKSIZE = 0x14000
    TARGET.EPOCHEAPSIZE = 0x020000 0x800000
}

unix {
    INSTALLS += target desktop icon48 loading
    target.path = /usr/bin/effing
    desktop.path = /usr/share/applications/hildon
    desktop.files += maemofiles/effing.desktop
    icon48.path = /usr/share/icons/hicolor/48x48/apps
    icon48.files += maemofiles/effing_icon.png
    loading.path = /usr/bin/effing
    loading.files += maemofiles/effing_loading.png

}

RESOURCES += \
    qmlresources.qrc

OTHER_FILES += qml/eff.qml qml/BlackButton.qml
