#include <QDebug>
#include "messagedto.h"

MessageDTO::MessageDTO(QObject *parent) :
    QObject(parent)
{
    _messageType = SYSTEM;
}

MessageDTO::~MessageDTO()
{

}

MessageDTO::MessageDTO(const MessageDTO &other) : QObject()
{
    if (this!=&other)
    {
        _messageType = other._messageType;
        _messageId = other._messageId;
        _author = other._author;
        _text = other._text;
        _timestamp = other._timestamp;
        MessageDTO child;
        foreach (child, other._children) {
            _children.append(child);
        }
    }
}

MessageDTO& MessageDTO::operator=(const MessageDTO &other)
{
    if (this!=&other)
    {
        _messageType = other._messageType;
        _messageId = other._messageId;
        _author = other._author;
        _text = other._text;
        _timestamp = other._timestamp;
        _children = QList<MessageDTO>();
        for (int index=0; index<other._children.size(); index++) {
            MessageDTO child = MessageDTO(other._children[index]);
            _children.append(child);
        }

    }
    return *this;

}


void MessageDTO::setMessageType(MessageType messageType)
{
    _messageType = messageType;
}

MessageDTO::MessageType MessageDTO::getMessageType()
{
    return _messageType;
}

void MessageDTO::setAuthor(QString author)
{
    _author = author;
}

QString MessageDTO::getAuthor()
{
    return _author;
}

void MessageDTO::setMessageId(int id)
{
    _messageId = id;
}

int MessageDTO::getMessageId()
{
    return _messageId;
}

void MessageDTO::setText(QString text)
{
    _text = text;
}

QString MessageDTO::getText()
{
    return _text;
}

void MessageDTO::setTimestamp(QDateTime timestamp)
{
    _timestamp = timestamp;
}

void MessageDTO::setCurrentTimestamp()
{
    _timestamp = QDateTime::currentDateTime();
}

QDateTime MessageDTO::getTimestamp()
{
    return _timestamp;
}

QString MessageDTO::getTimestampText()
{
    QString timestamp_text;
    if (_timestamp.isNull())
        timestamp_text = tr("unknown time");
    else
        timestamp_text = _timestamp.toString(Qt::SystemLocaleShortDate);

    return timestamp_text;

}

QString MessageDTO::getFormattedMessage()
{
    if (_messageType==COLLECTION)
    {
        QString collectionEntries;
        MessageDTO collectionEntry;
        foreach (collectionEntry,_children)
            collectionEntries += (QLatin1String("<p>") + collectionEntry.getFormattedMessage() + QLatin1String("</p>"));
        qDebug()<<"Output: "<<collectionEntries;
        return collectionEntries;
    }
    QString introBase("<b>%1</b> ");
    QString intro;
    if (_messageType==STATUS) intro = introBase.arg(tr("Status:"));
    else if (_messageType==CHECKIN) intro = introBase.arg(tr("Checkin"));
    QString author(_author);
    if (author.length()>0) author += " - ";
    QString timestamp;
    if (!_timestamp.isNull()) timestamp = QString(" <i>(%1%2)</i> ").arg(author).arg(getTimestampText());
    QString children;
    if (_children.size()>0)
    {
        children += QLatin1String("<ul>");
        MessageDTO child;
        foreach (child,_children)
            children+= (QLatin1String("<li>") + child.getFormattedMessage() + QLatin1String("</li>"));
        children += QLatin1String("</ul>");
    }
    QString output(intro + _text + timestamp + children);
    return output;
}

QList<MessageDTO> MessageDTO::getChildren()
{
    return _children;
}

void MessageDTO::addChild(MessageDTO child)
{
    _children.append(child);
}
