/* This file is part of effing
 *
 * Copyright (C) 2010 Richard Merren <richard@merren.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "logindialog.h"
#include "constants.h"
#include <QVBoxLayout>
#include <QUrl>

LoginDialog::LoginDialog(QWidget *parent) :
    QDialog(parent)
{
    QVBoxLayout *vboxLayout = new QVBoxLayout(this);
    this->webView = new QWebView(this);
    vboxLayout->addWidget(this->webView);
    this->setLayout(vboxLayout);
    this->setModal(TRUE);
    this->setWindowModality(Qt::ApplicationModal);
    this->setWindowTitle("Login to Facebook");
    re.setPattern(AUTH_REGEX_TEXT);
    connect(webView,SIGNAL(urlChanged(QUrl)),this,SLOT(on_page_loaded(QUrl)));
    QUrl url;
    url.setScheme("https");
    url.setHost(AUTH_HOST);
    url.setPath(AUTH_PATH);
    url.addQueryItem("client_id",settings_manager.get_app_id());
    url.addQueryItem("redirect_uri",AUTH_REDIRECT_URI);
    url.addQueryItem("type","user_agent");
    url.addQueryItem("display","touch");
    url.addQueryItem("scope","user_status,publish_stream,offline_access");
    webView->load(url);}

void LoginDialog::on_page_loaded(QUrl url)
{
    //parse the url and find the token
    //need to use regex--it is not completely valid!
    if (url.isEmpty()) return;
    int pos = re.indexIn(url.toString());
    if (pos<0) return;
    QString token;
    if (re.capturedTexts().size()<2) token="";
    else token = re.capturedTexts()[1];
    this->auth_token = token;
    this->accept();
}

QString LoginDialog::get_auth_token()
{
    return this->auth_token;
}
