#ifndef MESSAGEDTO_H
#define MESSAGEDTO_H

#include <QObject>
#include <QDateTime>
#include <QList>

class MessageDTO : public QObject
{
    Q_OBJECT
public:
    enum MessageType {SYSTEM, STATUS, CHECKIN, COMMENT, COLLECTION};

    explicit MessageDTO(QObject *parent = 0);
    ~MessageDTO();

    //Needed to make this an assignable type
    MessageDTO(const MessageDTO &other);
    MessageDTO &operator=(const MessageDTO &other);

    MessageType getMessageType();
    QString getText();
    QDateTime getTimestamp();
    QString getTimestampText();
    int getMessageId();
    QString getAuthor();
    void setMessageType(MessageType messageType);
    void setText(QString text);
    void setTimestamp(QDateTime timestamp);
    void setCurrentTimestamp();
    void setAuthor(QString author);
    void setMessageId(int id);

    QString getFormattedMessage();

    QList<MessageDTO> getChildren();
    void addChild(MessageDTO child);

signals:

public slots:

private:
    MessageType _messageType;
    QString _text;
    QDateTime _timestamp;
    QString _author;
    int _messageId;
    QList<MessageDTO> _children;


};

#endif // MESSAGEDTO_H
