/* This file is part of effing
 *
 * Copyright (C) 2010 Richard Merren <richard@merren.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef EFFINGMAIN_H
#define EFFINGMAIN_H

#include <QMainWindow>
#include <QDateTime>
#include <QString>
#include "logindialog.h"
#include "settingsmanager.h"

namespace Ui {
    class EffingMain;
}

class EffingMain : public QMainWindow
{
    Q_OBJECT

public:
    explicit EffingMain(QWidget *parent = 0);
    ~EffingMain();
    void initial_config();

signals:
    void refresh();
    void submitStatus(QString status_text);
    void erase_token();
    void changed_prefer_touch(bool prefer_touch);
    void launch_facebook();

public slots:
    void set_status(QString messageHtml);
    void clear_entry_box();

private:
    Ui::EffingMain *ui;
    void set_status_not_logged_in();
    SettingsManager settings_manager;

private slots:
    void on_refreshButton_clicked();
    void on_submitButton_clicked();
    void process_configure_menu();
    void status_text_changed();
};

#endif // EFFINGMAIN_H
