/* This file is part of effing
 *
 * Copyright (C) 2010 Richard Merren <richard@merren.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "effingmain.h"
#include "ui_effingmain.h"
#include "constants.h"
#include "configdialog.h"
#include <Qt>
#include <QRegExp>

EffingMain::EffingMain(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::EffingMain)
{
    ui->setupUi(this);
    connect(ui->actionUnauthorize,SIGNAL(triggered()),this,SIGNAL(erase_token()));
    connect(ui->actionConfigure,SIGNAL(triggered()),this,SLOT(process_configure_menu()));
    connect(ui->openFacebookButton,SIGNAL(clicked()),this,SIGNAL(launch_facebook()));
    connect(ui->statusEdit,SIGNAL(textChanged()),this,SLOT(status_text_changed()));
}

EffingMain::~EffingMain()
{
    delete ui;
}

void EffingMain::initial_config()
{
    if (settings_manager.is_show_config_first())
        process_configure_menu();
}

void EffingMain::set_status(QString messageHtml)
{
    ui->currentStatusEdit->setHtml(messageHtml);
}

void EffingMain::on_submitButton_clicked()
{
    QString text = ui->statusEdit->toPlainText();
    if (text!=NULL && !text.trimmed().isEmpty())
    {
        emit submitStatus(text);
    }
}

void EffingMain::set_status_not_logged_in()
{
    ui->currentStatusEdit->setText(tr("Not logged in."));
}

void EffingMain::on_refreshButton_clicked()
{
    emit refresh();
}

void EffingMain::clear_entry_box()
{
    ui->statusEdit->clear();
}

void EffingMain::process_configure_menu()
{
    bool prefer_g_rated = settings_manager.is_prefer_g_rated_tag_line();
    bool prefer_facebook_touch = settings_manager.is_prefer_facebook_touch();
    ConfigDialog dialog;
    if (prefer_g_rated) {
        dialog.set_tagline_G(true);
    } else {
        dialog.set_tagline_G(false);
    }
    if (prefer_facebook_touch)
    {
        dialog.set_target_touch(true);
    } else {
        dialog.set_target_touch(false);
    }
    int result = dialog.exec();
    if (result==QDialog::Accepted) {
        qDebug("Config dialog - Accepted");
        bool new_prefer_g_rated = dialog.is_tagline_G();
        bool new_prefer_facebook_touch = dialog.is_target_touch();
        settings_manager.set_prefer_facebook_touch(new_prefer_facebook_touch);
        settings_manager.set_prefer_g_rated_tag_line(new_prefer_g_rated);
        emit(changed_prefer_touch(new_prefer_facebook_touch));
        settings_manager.set_show_config_first(false);
    }
}

void EffingMain::status_text_changed()
{
    int length = this->ui->statusEdit->toPlainText().length();
    if (length > MAX_STATUS_LENGTH)
    {
        this->ui->submitButton->setEnabled(false);
        this->ui->submitButton->setText(tr("Status Too Long"));
    } else {
        this->ui->submitButton->setEnabled(true);
        this->ui->submitButton->setText(tr("Submit Status"));
    }
}
