/* This file is part of effing
 *
 * Copyright (C) 2010 Richard Merren <richard@merren.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <QtGui/QApplication>
#include "effingmain.h"
#include "fbactions.h"
#include "browserlauncher.h"

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
    EffingMain effing_main;
    FbActions fb_actions;
    BrowserLauncher browser_launcher;
    QObject::connect(&fb_actions,SIGNAL(status_available(QString,QDateTime)),&effing_main,SLOT(set_status(QString,QDateTime)));
    QObject::connect(&effing_main,SIGNAL(refresh()),&fb_actions,SLOT(request_status()));
    QObject::connect(&effing_main,SIGNAL(submitStatus(QString)),&fb_actions,SLOT(set_status(QString)));
    QObject::connect(&effing_main,SIGNAL(erase_token()),&fb_actions,SLOT(unauthorize()));
    QObject::connect(&fb_actions,SIGNAL(status_successfully_set()),&effing_main,SLOT(clear_entry_box()));
    QObject::connect(&effing_main,SIGNAL(changed_prefer_touch(bool)),&browser_launcher,SLOT(set_touch_preferred(bool)));
    QObject::connect(&effing_main,SIGNAL(launch_facebook()),&browser_launcher,SLOT(launch_facebook()));
#if defined(Q_WS_S60)
    effing_main.showMaximized();
#else
    effing_main.show();
#endif
    effing_main.initial_config();
    browser_launcher.request_settings();
    fb_actions.request_status();
    return a.exec();
}
