/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "ec-progress.h"

#include "ec-progress-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */
/* self casting macros */
#define SELF(x) EC_PROGRESS(x)
#define SELF_CONST(x) EC_PROGRESS_CONST(x)
#define IS_SELF(x) EC_IS_PROGRESS(x)
#define TYPE_SELF EC_TYPE_PROGRESS
#define SELF_CLASS(x) EC_PROGRESS_CLASS(x)

#define SELF_GET_CLASS(x) EC_PROGRESS_GET_CLASS(x)

/* self typedefs */
typedef EcProgress Self;
typedef EcProgressClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void ec_progress_class_init (EcProgressClass * c) G_GNUC_UNUSED;
static void ec_progress_init (EcProgress * self) G_GNUC_UNUSED;
static gboolean ec_progress_progress_expose_event (GtkWidget * drw_area, GdkEventExpose * event, gpointer user_data) G_GNUC_UNUSED;
static gboolean ec_progress_event_box_expose_event (GtkWidget * widget, GdkEventExpose * event, gpointer user_data) G_GNUC_UNUSED;
static void ec_progress_repaint (EcProgress * self) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_USE_MARKUP,
	PROP_LABEL_TEXT,
	PROP_PROGRESS_VAL,
	PROP_MARGIN_X,
	PROP_MARGIN_Y,
	PROP_PROGRESS_MARGIN_Y
};

/* pointer to the class of our parent */
static GtkVBoxClass *parent_class = NULL;

/* Short form macros */
#define self_get_use_markup ec_progress_get_use_markup
#define self_set_use_markup ec_progress_set_use_markup
#define self_get_label_text ec_progress_get_label_text
#define self_set_label_text ec_progress_set_label_text
#define self_get_progress_val ec_progress_get_progress_val
#define self_set_progress_val ec_progress_set_progress_val
#define self_get_margin_x ec_progress_get_margin_x
#define self_set_margin_x ec_progress_set_margin_x
#define self_get_margin_y ec_progress_get_margin_y
#define self_set_margin_y ec_progress_set_margin_y
#define self_get_progress_margin_y ec_progress_get_progress_margin_y
#define self_set_progress_margin_y ec_progress_set_progress_margin_y
#define self_new ec_progress_new
#define self_new_with_label ec_progress_new_with_label
#define self_set_progress_image ec_progress_set_progress_image
#define self_set_bg_image ec_progress_set_bg_image
#define self_set_progress_bg_image ec_progress_set_progress_bg_image
#define self_set_bg_color ec_progress_set_bg_color
#define self_set_fg_color ec_progress_set_fg_color
#define self_progress_expose_event ec_progress_progress_expose_event
#define self_event_box_expose_event ec_progress_event_box_expose_event
#define self_repaint ec_progress_repaint
GType
ec_progress_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (EcProgressClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) ec_progress_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (EcProgress),
			0 /* n_preallocs */,
			(GInstanceInitFunc) ec_progress_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_VBOX, "EcProgress", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((EcProgress *)g_object_new(ec_progress_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static EcProgress * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static EcProgress *
GET_NEW_VARG (const char *first, ...)
{
	EcProgress *ret;
	va_list ap;
	va_start (ap, first);
	ret = (EcProgress *)g_object_new_valist (ec_progress_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "Ec:Progress::dispose"
	EcProgress *self G_GNUC_UNUSED = EC_PROGRESS (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#line 21 "ec-progress.gob"
	if(self->_priv->bg_pixbuf) { gdk_pixbuf_unref ((gpointer) self->_priv->bg_pixbuf); self->_priv->bg_pixbuf = NULL; }
#line 135 "ec-progress.c"
#line 24 "ec-progress.gob"
	if(self->_priv->progress_bg_pixbuf) { gdk_pixbuf_unref ((gpointer) self->_priv->progress_bg_pixbuf); self->_priv->progress_bg_pixbuf = NULL; }
#line 138 "ec-progress.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Ec:Progress::finalize"
	EcProgress *self G_GNUC_UNUSED = EC_PROGRESS (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 15 "ec-progress.gob"
	if(self->_priv->label_text) { g_free ((gpointer) self->_priv->label_text); self->_priv->label_text = NULL; }
#line 153 "ec-progress.c"
}
#undef __GOB_FUNCTION__

static void 
ec_progress_class_init (EcProgressClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Ec:Progress::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(EcProgressPrivate));

	parent_class = g_type_class_ref (GTK_TYPE_VBOX);

	g_object_class->dispose = ___dispose;
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_boolean
		("use_markup" /* name */,
		 _("Use markup") /* nick */,
		 _("Use markup for the label") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_USE_MARKUP,
		param_spec);
	param_spec = g_param_spec_string
		("label_text" /* name */,
		 _("Progress bar label") /* nick */,
		 _("The label displayed under the progress bar") /* blurb */,
		 "" /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_LABEL_TEXT,
		param_spec);
	param_spec = g_param_spec_double
		("progress_val" /* name */,
		 _("Progress value") /* nick */,
		 _("Progress bar value from 0 to 1") /* blurb */,
		 0.0 /* minimum */,
		 1.0 /* maximum */,
		 0.0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_PROGRESS_VAL,
		param_spec);
	param_spec = g_param_spec_int
		("margin_x" /* name */,
		 _("X marginal") /* nick */,
		 _("Marginal in x direction (in pixels), from both edges") /* blurb */,
		 0 /* minimum */,
		 INT_MAX /* maximum */,
		 0.0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_MARGIN_X,
		param_spec);
	param_spec = g_param_spec_int
		("margin_y" /* name */,
		 _("Y marginal") /* nick */,
		 _("Marginal in y direction (in pixels, from top)") /* blurb */,
		 0 /* minimum */,
		 INT_MAX /* maximum */,
		 0.0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_MARGIN_Y,
		param_spec);
	param_spec = g_param_spec_int
		("progress_margin_y" /* name */,
		 _("Progress y marginal") /* nick */,
		 _("Progress marginal in y direction (in pixels, from top)") /* blurb */,
		 0 /* minimum */,
		 INT_MAX /* maximum */,
		 0.0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_PROGRESS_MARGIN_Y,
		param_spec);
    }
}
#undef __GOB_FUNCTION__
#line 153 "ec-progress.gob"
static void 
ec_progress_init (EcProgress * self G_GNUC_UNUSED)
#line 242 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,EC_TYPE_PROGRESS,EcProgressPrivate);
#line 14 "ec-progress.gob"
	self->_priv->label_text =  g_strdup("") ;
#line 248 "ec-progress.c"
 {
#line 154 "ec-progress.gob"

		self->_priv->progress_val = 0;

		self->_priv->progress_pixbuf = NULL;
		self->_priv->bg_pixbuf = NULL;
		self->_priv->progress_bg_pixbuf = NULL;

		/* 
		 * Create the label to an event box, because it needs
		 * to be clickable
		 */
		self->_priv->event_box = gtk_event_box_new();
		gtk_box_pack_start(GTK_BOX(self),
				self->_priv->event_box,
				TRUE, TRUE, 0);
		gtk_widget_add_events(self->_priv->event_box,
				GDK_EXPOSURE_MASK);

		self->_priv->label = gtk_label_new(self->_priv->label_text);

		gtk_container_add(GTK_CONTAINER(self->_priv->event_box),
					self->_priv->label);

		gtk_widget_show_all(GTK_WIDGET(self));

		/* Use a GtkDrawingArea for the progress bar */
		self->_priv->progress = gtk_drawing_area_new();
		g_signal_connect(G_OBJECT(self->_priv->progress),
				"expose_event",
				G_CALLBACK(
					self_progress_expose_event),
				self);

		g_signal_connect(G_OBJECT(self->_priv->event_box),
				"expose_event",
				G_CALLBACK(
					self_event_box_expose_event),
				self);

		gtk_box_pack_start(GTK_BOX(self),
				self->_priv->progress,
				TRUE, TRUE, 0);
	
#line 294 "ec-progress.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "Ec:Progress::set_property"
{
	EcProgress *self G_GNUC_UNUSED;

	self = EC_PROGRESS (object);

	switch (property_id) {
	case PROP_USE_MARKUP:
		{
#line 32 "ec-progress.gob"

			self->_priv->use_markup = g_value_get_boolean(VAL);
			if(self->_priv->use_markup)
			{
				gtk_label_set_markup(GTK_LABEL(
							self->_priv->label),
						self->_priv->label_text);
			} else {
				gtk_label_set_text(GTK_LABEL(
							self->_priv->label),
						self->_priv->label_text);
			}
		
#line 327 "ec-progress.c"
		}
		break;
	case PROP_LABEL_TEXT:
		{
#line 54 "ec-progress.gob"

			self->_priv->label_text =
			       g_strdup(g_value_get_string(VAL));
			if(self->_priv->use_markup)
			{
				gtk_label_set_markup(GTK_LABEL(
							self->_priv->label),
						self->_priv->label_text);
			} else {
				gtk_label_set_text(GTK_LABEL(
							self->_priv->label),
						self->_priv->label_text);
			}
			self_repaint(self);
		
#line 348 "ec-progress.c"
		}
		break;
	case PROP_PROGRESS_VAL:
		{
#line 90 "ec-progress.gob"

			self->_priv->progress_val = g_value_get_double(VAL);
			self_repaint(self);
		
#line 358 "ec-progress.c"
		}
		break;
	case PROP_MARGIN_X:
		{
#line 107 "ec-progress.gob"

			self->_priv->margin_x = g_value_get_int(VAL);
			self_repaint(self);
		
#line 368 "ec-progress.c"
		}
		break;
	case PROP_MARGIN_Y:
		{
#line 124 "ec-progress.gob"

			self->_priv->margin_y = g_value_get_int(VAL);
			self_repaint(self);
		
#line 378 "ec-progress.c"
		}
		break;
	case PROP_PROGRESS_MARGIN_Y:
		{
#line 141 "ec-progress.gob"

			self->_priv->progress_margin_y = g_value_get_int(VAL);
			self_repaint(self);
		
#line 388 "ec-progress.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "Ec:Progress::get_property"
{
	EcProgress *self G_GNUC_UNUSED;

	self = EC_PROGRESS (object);

	switch (property_id) {
	case PROP_USE_MARKUP:
		{
#line 45 "ec-progress.gob"

			g_value_set_boolean(VAL, self->_priv->use_markup);
		
#line 421 "ec-progress.c"
		}
		break;
	case PROP_LABEL_TEXT:
		{
#line 69 "ec-progress.gob"

			g_value_set_string(VAL, self->_priv->label_text);
		
#line 430 "ec-progress.c"
		}
		break;
	case PROP_PROGRESS_VAL:
		{
#line 94 "ec-progress.gob"

			g_value_set_double(VAL, self->_priv->progress_val);
		
#line 439 "ec-progress.c"
		}
		break;
	case PROP_MARGIN_X:
		{
#line 111 "ec-progress.gob"

			g_value_set_int(VAL, self->_priv->margin_x);
		
#line 448 "ec-progress.c"
		}
		break;
	case PROP_MARGIN_Y:
		{
#line 128 "ec-progress.gob"

			g_value_set_int(VAL, self->_priv->margin_y);
		
#line 457 "ec-progress.c"
		}
		break;
	case PROP_PROGRESS_MARGIN_Y:
		{
#line 145 "ec-progress.gob"

			g_value_set_int(VAL, self->_priv->progress_margin_y);
		
#line 466 "ec-progress.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__


#line 45 "ec-progress.gob"
gboolean 
ec_progress_get_use_markup (EcProgress * self)
#line 485 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::get_use_markup"
{
#line 27 "ec-progress.gob"
		gboolean val; g_object_get (G_OBJECT (self), "use_markup", &val, NULL); return val;
}}
#line 492 "ec-progress.c"
#undef __GOB_FUNCTION__

#line 32 "ec-progress.gob"
void 
ec_progress_set_use_markup (EcProgress * self, gboolean val)
#line 498 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::set_use_markup"
{
#line 27 "ec-progress.gob"
		g_object_set (G_OBJECT (self), "use_markup", val, NULL);
}}
#line 505 "ec-progress.c"
#undef __GOB_FUNCTION__

#line 69 "ec-progress.gob"
gchar * 
ec_progress_get_label_text (EcProgress * self)
#line 511 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::get_label_text"
{
#line 49 "ec-progress.gob"
		gchar* val; g_object_get (G_OBJECT (self), "label_text", &val, NULL); return val;
}}
#line 518 "ec-progress.c"
#undef __GOB_FUNCTION__

#line 54 "ec-progress.gob"
void 
ec_progress_set_label_text (EcProgress * self, gchar * val)
#line 524 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::set_label_text"
{
#line 49 "ec-progress.gob"
		g_object_set (G_OBJECT (self), "label_text", val, NULL);
}}
#line 531 "ec-progress.c"
#undef __GOB_FUNCTION__

#line 94 "ec-progress.gob"
gdouble 
ec_progress_get_progress_val (EcProgress * self)
#line 537 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::get_progress_val"
{
#line 83 "ec-progress.gob"
		gdouble val; g_object_get (G_OBJECT (self), "progress_val", &val, NULL); return val;
}}
#line 544 "ec-progress.c"
#undef __GOB_FUNCTION__

#line 90 "ec-progress.gob"
void 
ec_progress_set_progress_val (EcProgress * self, gdouble val)
#line 550 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::set_progress_val"
{
#line 83 "ec-progress.gob"
		g_object_set (G_OBJECT (self), "progress_val", val, NULL);
}}
#line 557 "ec-progress.c"
#undef __GOB_FUNCTION__

#line 111 "ec-progress.gob"
gint 
ec_progress_get_margin_x (EcProgress * self)
#line 563 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::get_margin_x"
{
#line 100 "ec-progress.gob"
		gint val; g_object_get (G_OBJECT (self), "margin_x", &val, NULL); return val;
}}
#line 570 "ec-progress.c"
#undef __GOB_FUNCTION__

#line 107 "ec-progress.gob"
void 
ec_progress_set_margin_x (EcProgress * self, gint val)
#line 576 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::set_margin_x"
{
#line 100 "ec-progress.gob"
		g_object_set (G_OBJECT (self), "margin_x", val, NULL);
}}
#line 583 "ec-progress.c"
#undef __GOB_FUNCTION__

#line 128 "ec-progress.gob"
gint 
ec_progress_get_margin_y (EcProgress * self)
#line 589 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::get_margin_y"
{
#line 117 "ec-progress.gob"
		gint val; g_object_get (G_OBJECT (self), "margin_y", &val, NULL); return val;
}}
#line 596 "ec-progress.c"
#undef __GOB_FUNCTION__

#line 124 "ec-progress.gob"
void 
ec_progress_set_margin_y (EcProgress * self, gint val)
#line 602 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::set_margin_y"
{
#line 117 "ec-progress.gob"
		g_object_set (G_OBJECT (self), "margin_y", val, NULL);
}}
#line 609 "ec-progress.c"
#undef __GOB_FUNCTION__

#line 145 "ec-progress.gob"
gint 
ec_progress_get_progress_margin_y (EcProgress * self)
#line 615 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::get_progress_margin_y"
{
#line 134 "ec-progress.gob"
		gint val; g_object_get (G_OBJECT (self), "progress_margin_y", &val, NULL); return val;
}}
#line 622 "ec-progress.c"
#undef __GOB_FUNCTION__

#line 141 "ec-progress.gob"
void 
ec_progress_set_progress_margin_y (EcProgress * self, gint val)
#line 628 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::set_progress_margin_y"
{
#line 134 "ec-progress.gob"
		g_object_set (G_OBJECT (self), "progress_margin_y", val, NULL);
}}
#line 635 "ec-progress.c"
#undef __GOB_FUNCTION__


#line 203 "ec-progress.gob"
GtkWidget * 
ec_progress_new (void)
#line 642 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::new"
{
#line 204 "ec-progress.gob"
	
		EcProgress *widget = GET_NEW;

		return (GtkWidget *)widget;
	}}
#line 652 "ec-progress.c"
#undef __GOB_FUNCTION__

#line 215 "ec-progress.gob"
GtkWidget * 
ec_progress_new_with_label (gchar * text)
#line 658 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::new_with_label"
#line 215 "ec-progress.gob"
	g_return_val_if_fail (text != NULL, (GtkWidget * )NULL);
#line 663 "ec-progress.c"
{
#line 216 "ec-progress.gob"
	
		EcProgress *widget = GET_NEW;

		g_object_set(G_OBJECT(widget), "label_text", text, NULL);

		return (GtkWidget *)widget;
	}}
#line 673 "ec-progress.c"
#undef __GOB_FUNCTION__

#line 229 "ec-progress.gob"
void 
ec_progress_set_progress_image (EcProgress * self, const gchar * path)
#line 679 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::set_progress_image"
#line 229 "ec-progress.gob"
	g_return_if_fail (self != NULL);
#line 229 "ec-progress.gob"
	g_return_if_fail (EC_IS_PROGRESS (self));
#line 686 "ec-progress.c"
{
#line 232 "ec-progress.gob"
	
		GError *error = NULL;

		GdkPixbuf *new_pixbuf = NULL;

		if(self->_priv->progress_pixbuf)
		{
			g_object_unref(G_OBJECT(self->_priv->progress_pixbuf));
		}

		if(path != NULL)
		{
			new_pixbuf = gdk_pixbuf_new_from_file(
					path,
					&error);

			if(error)
			{
				g_warning("Unable to load image %s: %s",
						path,
					error->message);
			}
		}
	
		self->_priv->progress_pixbuf = new_pixbuf;
		self_repaint(self);
	}}
#line 716 "ec-progress.c"
#undef __GOB_FUNCTION__

#line 260 "ec-progress.gob"
void 
ec_progress_set_bg_image (EcProgress * self, const gchar * path)
#line 722 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::set_bg_image"
#line 260 "ec-progress.gob"
	g_return_if_fail (self != NULL);
#line 260 "ec-progress.gob"
	g_return_if_fail (EC_IS_PROGRESS (self));
#line 729 "ec-progress.c"
{
#line 261 "ec-progress.gob"
	
		GdkPixbuf *new_pixbuf = NULL;
		GError *error = NULL;

		if(self->_priv->bg_pixbuf)
		{
			g_object_unref(G_OBJECT(self->_priv->bg_pixbuf));
		}


		if(path != NULL)
		{
			new_pixbuf = gdk_pixbuf_new_from_file(
					path,
					&error);

			if(error)
			{
				g_warning("Unable to load image %s: %s",
						path,
					error->message);
			}
		}

		self->_priv->bg_pixbuf = new_pixbuf;

		self_repaint(self);
	}}
#line 760 "ec-progress.c"
#undef __GOB_FUNCTION__

#line 290 "ec-progress.gob"
void 
ec_progress_set_progress_bg_image (EcProgress * self, const gchar * path)
#line 766 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::set_progress_bg_image"
#line 290 "ec-progress.gob"
	g_return_if_fail (self != NULL);
#line 290 "ec-progress.gob"
	g_return_if_fail (EC_IS_PROGRESS (self));
#line 773 "ec-progress.c"
{
#line 291 "ec-progress.gob"
	
		GdkPixbuf *new_pixbuf = NULL;
		GError *error = NULL;
		int w, h;

		if(self->_priv->progress_bg_pixbuf)
		{
			g_object_unref(G_OBJECT(self->_priv->progress_bg_pixbuf));
		}


		if(path != NULL)
		{
			new_pixbuf = gdk_pixbuf_new_from_file(
					path,
					&error);

			if(error)
			{
				g_warning("Unable to load image %s: %s",
						path,
					error->message);
			}
		}

		self->_priv->progress_bg_pixbuf = new_pixbuf;

		if(new_pixbuf)
		{
			gdk_pixbuf_ref(new_pixbuf);
			w = gdk_pixbuf_get_width(self->_priv->
					progress_bg_pixbuf);
			h = gdk_pixbuf_get_height(self->_priv->
					progress_bg_pixbuf);
			gtk_widget_set_size_request(self->_priv->progress,
					w, h);
		}

		self_repaint(self);
	}}
#line 816 "ec-progress.c"
#undef __GOB_FUNCTION__

#line 332 "ec-progress.gob"
void 
ec_progress_set_bg_color (EcProgress * self, const GdkColor * color)
#line 822 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::set_bg_color"
#line 332 "ec-progress.gob"
	g_return_if_fail (self != NULL);
#line 332 "ec-progress.gob"
	g_return_if_fail (EC_IS_PROGRESS (self));
#line 332 "ec-progress.gob"
	g_return_if_fail (color != NULL);
#line 831 "ec-progress.c"
{
#line 336 "ec-progress.gob"
	
		gtk_widget_modify_bg(self->_priv->event_box,
				GTK_STATE_NORMAL, color);
		gtk_widget_modify_bg(self->_priv->event_box,
				GTK_STATE_ACTIVE, color);
		gtk_widget_modify_bg(self->_priv->event_box,
				GTK_STATE_PRELIGHT, color);
		gtk_widget_modify_bg(self->_priv->event_box,
				GTK_STATE_SELECTED, color);
		gtk_widget_modify_bg(self->_priv->event_box,
				GTK_STATE_INSENSITIVE, color);

		gtk_widget_modify_bg(self->_priv->progress,
				GTK_STATE_NORMAL, color);
		gtk_widget_modify_bg(self->_priv->progress,
				GTK_STATE_ACTIVE, color);
		gtk_widget_modify_bg(self->_priv->progress,
				GTK_STATE_PRELIGHT, color);
		gtk_widget_modify_bg(self->_priv->progress,
				GTK_STATE_SELECTED, color);
		gtk_widget_modify_bg(self->_priv->progress,
				GTK_STATE_INSENSITIVE, color);
	}}
#line 857 "ec-progress.c"
#undef __GOB_FUNCTION__

#line 360 "ec-progress.gob"
void 
ec_progress_set_fg_color (EcProgress * self, const GdkColor * color)
#line 863 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::set_fg_color"
#line 360 "ec-progress.gob"
	g_return_if_fail (self != NULL);
#line 360 "ec-progress.gob"
	g_return_if_fail (EC_IS_PROGRESS (self));
#line 360 "ec-progress.gob"
	g_return_if_fail (color != NULL);
#line 872 "ec-progress.c"
{
#line 364 "ec-progress.gob"
	
		gtk_widget_modify_fg(self->_priv->label,
				GTK_STATE_NORMAL, color);
		gtk_widget_modify_fg(self->_priv->label,
				GTK_STATE_ACTIVE, color);
		gtk_widget_modify_fg(self->_priv->label,
				GTK_STATE_PRELIGHT, color);
		gtk_widget_modify_fg(self->_priv->label,
				GTK_STATE_SELECTED, color);
		gtk_widget_modify_fg(self->_priv->label,
				GTK_STATE_INSENSITIVE, color);

		gtk_widget_modify_fg(self->_priv->progress,
				GTK_STATE_NORMAL, color);
		gtk_widget_modify_fg(self->_priv->progress,
				GTK_STATE_ACTIVE, color);
		gtk_widget_modify_fg(self->_priv->progress,
				GTK_STATE_PRELIGHT, color);
		gtk_widget_modify_fg(self->_priv->progress,
				GTK_STATE_SELECTED, color);
		gtk_widget_modify_fg(self->_priv->progress,
				GTK_STATE_INSENSITIVE, color);
	}}
#line 898 "ec-progress.c"
#undef __GOB_FUNCTION__

#line 388 "ec-progress.gob"
static gboolean 
ec_progress_progress_expose_event (GtkWidget * drw_area, GdkEventExpose * event, gpointer user_data)
#line 904 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::progress_expose_event"
#line 388 "ec-progress.gob"
	g_return_val_if_fail (drw_area != NULL, (gboolean )0);
#line 388 "ec-progress.gob"
	g_return_val_if_fail (GTK_IS_WIDGET (drw_area), (gboolean )0);
#line 388 "ec-progress.gob"
	g_return_val_if_fail (user_data != NULL, (gboolean )0);
#line 913 "ec-progress.c"
{
#line 392 "ec-progress.gob"
	
		gint w, h;
		gint x, y;
		gdouble progress_image_w;
		gint progress_w;

		EcProgress *widget = EC_PROGRESS(user_data);
		GdkDrawable *drawable = GDK_DRAWABLE(drw_area->window);
		GdkGC *gc = gdk_gc_new(drawable);

		if(widget->_priv->progress_bg_pixbuf == NULL)
		{
			g_warning("No background image");
			return TRUE;
		}
		if(widget->_priv->progress_pixbuf == NULL)
		{
			g_warning("No progress image");
			return TRUE;
		}
		w = gdk_pixbuf_get_width(widget->_priv->progress_bg_pixbuf);
		h = gdk_pixbuf_get_height(widget->_priv->progress_bg_pixbuf);
		if(w == 0 || h == 0)
		{
			g_warning("Background width or height is zero");
			return TRUE;
		}

		/* Draw the widgets background first */
		GtkWidget *parent = gtk_widget_get_parent(drw_area);
		if(widget->_priv->bg_pixbuf && parent)
		{
			x = drw_area->allocation.x - parent->allocation.x;
			y = drw_area->allocation.y - parent->allocation.y;
			gdk_draw_pixbuf(
					drawable,
					gc,
					widget->_priv->bg_pixbuf,
					x, y,
					0, 0,
					drw_area->allocation.width,
					drw_area->allocation.height,
					GDK_RGB_DITHER_MAX,
					0, 0);
		}

		/* Then draw the progress bar background */
		gdk_draw_pixbuf(drawable,
				gc,
				widget->_priv->progress_bg_pixbuf,
				0, 0,
				(drw_area->allocation.width - w) / 2, 0,
				w, h,
				GDK_RGB_DITHER_MAX,
				0, 0);

		/* Calculate the width of the progress image to be drawn */
		progress_image_w = (gdouble)gdk_pixbuf_get_width(
				widget->_priv->progress_pixbuf);
		progress_w = progress_image_w * (widget->_priv->progress_val);

		/* Center the progress image */
		x = (drw_area->allocation.width - progress_image_w) / 2;

		gdk_draw_pixbuf(drawable,
				gc,
				widget->_priv->progress_pixbuf,
				0, 0,
				x, widget->_priv->progress_margin_y,
				progress_w, gdk_pixbuf_get_height(
					widget->_priv->progress_pixbuf),
				GDK_RGB_DITHER_MAX,
				0, 0);

		gdk_gc_unref(gc);
		return TRUE;
	}}
#line 993 "ec-progress.c"
#undef __GOB_FUNCTION__

#line 470 "ec-progress.gob"
static gboolean 
ec_progress_event_box_expose_event (GtkWidget * widget, GdkEventExpose * event, gpointer user_data)
#line 999 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::event_box_expose_event"
#line 470 "ec-progress.gob"
	g_return_val_if_fail (widget != NULL, (gboolean )0);
#line 470 "ec-progress.gob"
	g_return_val_if_fail (GTK_IS_WIDGET (widget), (gboolean )0);
#line 470 "ec-progress.gob"
	g_return_val_if_fail (user_data != NULL, (gboolean )0);
#line 1008 "ec-progress.c"
{
#line 474 "ec-progress.gob"
	
		gint x, y;
		EcProgress *self = EC_PROGRESS(user_data);
		GdkDrawable *drawable = GDK_DRAWABLE(widget->window);
		GdkGC *gc = gdk_gc_new(drawable);

		/* Draw the widgets background first */
		GtkWidget *parent = gtk_widget_get_parent(widget);
		if(self->_priv->bg_pixbuf && parent)
		{
			x = widget->allocation.x - parent->allocation.x;
			y = widget->allocation.y - parent->allocation.y;
			gdk_draw_pixbuf(
					drawable,
					gc,
					self->_priv->bg_pixbuf,
					x, y,
					0, 0,
					widget->allocation.width,
					widget->allocation.height,
					GDK_RGB_DITHER_MAX,
					0, 0);
		}		gdk_gc_unref(gc);
		return FALSE;
	}}
#line 1036 "ec-progress.c"
#undef __GOB_FUNCTION__

#line 500 "ec-progress.gob"
static void 
ec_progress_repaint (EcProgress * self)
#line 1042 "ec-progress.c"
{
#define __GOB_FUNCTION__ "Ec:Progress::repaint"
#line 500 "ec-progress.gob"
	g_return_if_fail (self != NULL);
#line 500 "ec-progress.gob"
	g_return_if_fail (EC_IS_PROGRESS (self));
#line 1049 "ec-progress.c"
{
#line 501 "ec-progress.gob"
	
		gtk_widget_queue_draw(self->_priv->progress);
	}}
#line 1055 "ec-progress.c"
#undef __GOB_FUNCTION__
