/* util.c - Some misc libebook utils
 *
 * Copyright (C) 2008 Nokia Corp.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Author: Joergen Scheibengruber <jorgen.scheibengruber AT nokia.com>
 */

#ifndef __UTIL_H__
#define __UTIL_H__

#include <libebook/e-book.h>

EBook* _e_book_new_from_argv (const char **args, GError **error);

const char* _e_contact_get_name (EContact *contact);

#ifndef MAEMO_CHANGES
gboolean e_book_add_contacts (EBook *book, GList *contacts, GError **error);

gboolean e_book_commit_contacts (EBook *book, GList *contacts, GError **error);
#endif

#endif
