#include "sysconfig.h"
#include "sysdeps.h"
#include "options.h"
#include "memory.h"
#include "custom.h"
#include "events.h"
#include "newcpu.h"
#include "machdep/m68kops.h"
#include "cpu_prefetch.h"
#include "cputbl.h"
#define CPUFUNC(x) x##_ff
#define SET_CFLG_ALWAYS(flags, x) SET_CFLG(flags, x)
#define SET_NFLG_ALWAYS(flags, x) SET_NFLG(flags, x)
#ifdef NOFLAGS
#include "noflags.h"
#endif

#if !defined(PART_1) && !defined(PART_2) && !defined(PART_3) && !defined(PART_4) && !defined(PART_5) && !defined(PART_6) && !defined(PART_7) && !defined(PART_8)
#define PART_1 1
#define PART_2 1
#define PART_3 1
#define PART_4 1
#define PART_5 1
#define PART_6 1
#define PART_7 1
#define PART_8 1
#endif

#ifdef PART_1
/* OR.B #<data>.B,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0000_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* OR.B #<data>.B,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0010_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 20;
}
/* OR.B #<data>.B,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0018_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 20;
}
/* OR.B #<data>.B,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_0020_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 22;
}
/* OR.B #<data>.B,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_0028_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 24;
}
/* OR.B #<data>.B,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_0030_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}}return CYCLE_UNIT / 2 * 26;
}
/* OR.B #<data>.B,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_0038_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 24;
}
/* OR.B #<data>.B,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_0039_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 28;
}
/* ORSR.B #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_003c_0)(uae_u32 opcode, struct regstruct *regs)
{
{	MakeSR (regs);
{	uae_s16 src = get_iword (regs, 2);
	src &= 0xFF;
	regs->sr |= src;
	MakeFromSR (regs);
}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* OR.W #<data>.W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0040_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* OR.W #<data>.W,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0050_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* OR.W #<data>.W,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0058_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* OR.W #<data>.W,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_0060_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 18;
}
/* OR.W #<data>.W,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_0068_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s16 dst = get_word (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* OR.W #<data>.W,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_0070_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s16 dst = get_word (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* OR.W #<data>.W,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_0078_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s16 dst = get_word (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* OR.W #<data>.W,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_0079_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
{	uae_s16 dst = get_word (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 24;
}
/* ORSR.W #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_007c_0)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel18; }
{	MakeSR (regs);
{	uae_s16 src = get_iword (regs, 2);
	regs->sr |= src;
	MakeFromSR (regs);
}}}	m68k_incpc (regs, 4);
endlabel18: ;
return CYCLE_UNIT / 2 * 8;
}
/* OR.L #<data>.L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0080_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* OR.L #<data>.L,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0090_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 28;
}
/* OR.L #<data>.L,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0098_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 28;
}
/* OR.L #<data>.L,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_00a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 30;
}
/* OR.L #<data>.L,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_00a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 6);
{	uae_s32 dst = get_long (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 32;
}
/* OR.L #<data>.L,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_00b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 6);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s32 dst = get_long (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}}return CYCLE_UNIT / 2 * 34;
}
/* OR.L #<data>.L,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_00b8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 6);
{	uae_s32 dst = get_long (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 32;
}
/* OR.L #<data>.L,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_00b9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = get_ilong (regs, 6);
{	uae_s32 dst = get_long (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 10);
return CYCLE_UNIT / 2 * 36;
}
/* CHK2.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_00d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	{uae_s32 upper,lower,reg = regs->regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s8)get_byte (dsta); upper = (uae_s32)(uae_s8)get_byte (dsta+1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (&regs->ccrflags, (upper == reg || lower == reg) ? 1 : 0);
	SET_CFLG_ALWAYS (&regs->ccrflags, lower <= upper ? ((reg < lower || reg > upper) ? 1 : 0) : ((reg > upper || reg < lower) ? 1 : 0));
	if ((extra & 0x800) && GET_CFLG (&regs->ccrflags)) { Exception (6, regs, oldpc); goto endlabel27; }
}
}}}	m68k_incpc (regs, 4);
endlabel27: ;
return CYCLE_UNIT / 2 * 8;
}
#endif
/* CHK2.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_00e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
	{uae_s32 upper,lower,reg = regs->regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s8)get_byte (dsta); upper = (uae_s32)(uae_s8)get_byte (dsta+1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (&regs->ccrflags, (upper == reg || lower == reg) ? 1 : 0);
	SET_CFLG_ALWAYS (&regs->ccrflags, lower <= upper ? ((reg < lower || reg > upper) ? 1 : 0) : ((reg > upper || reg < lower) ? 1 : 0));
	if ((extra & 0x800) && GET_CFLG (&regs->ccrflags)) { Exception (6, regs, oldpc); goto endlabel28; }
}
}}}	m68k_incpc (regs, 6);
endlabel28: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* CHK2.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_00f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	{uae_s32 upper,lower,reg = regs->regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s8)get_byte (dsta); upper = (uae_s32)(uae_s8)get_byte (dsta+1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (&regs->ccrflags, (upper == reg || lower == reg) ? 1 : 0);
	SET_CFLG_ALWAYS (&regs->ccrflags, lower <= upper ? ((reg < lower || reg > upper) ? 1 : 0) : ((reg > upper || reg < lower) ? 1 : 0));
	if ((extra & 0x800) && GET_CFLG (&regs->ccrflags)) { Exception (6, regs, oldpc); goto endlabel29; }
}
}}}}endlabel29: ;
return CYCLE_UNIT / 2 * 14;
}
#endif
/* CHK2.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_00f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
	{uae_s32 upper,lower,reg = regs->regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s8)get_byte (dsta); upper = (uae_s32)(uae_s8)get_byte (dsta+1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (&regs->ccrflags, (upper == reg || lower == reg) ? 1 : 0);
	SET_CFLG_ALWAYS (&regs->ccrflags, lower <= upper ? ((reg < lower || reg > upper) ? 1 : 0) : ((reg > upper || reg < lower) ? 1 : 0));
	if ((extra & 0x800) && GET_CFLG (&regs->ccrflags)) { Exception (6, regs, oldpc); goto endlabel30; }
}
}}}	m68k_incpc (regs, 6);
endlabel30: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* CHK2.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_00f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
	{uae_s32 upper,lower,reg = regs->regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s8)get_byte (dsta); upper = (uae_s32)(uae_s8)get_byte (dsta+1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (&regs->ccrflags, (upper == reg || lower == reg) ? 1 : 0);
	SET_CFLG_ALWAYS (&regs->ccrflags, lower <= upper ? ((reg < lower || reg > upper) ? 1 : 0) : ((reg > upper || reg < lower) ? 1 : 0));
	if ((extra & 0x800) && GET_CFLG (&regs->ccrflags)) { Exception (6, regs, oldpc); goto endlabel31; }
}
}}}	m68k_incpc (regs, 8);
endlabel31: ;
return CYCLE_UNIT / 2 * 16;
}
#endif
/* CHK2.B #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_00fa_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 2;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta = m68k_getpc (regs) + 4;
	dsta += (uae_s32)(uae_s16)get_iword (regs, 4);
	{uae_s32 upper,lower,reg = regs->regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s8)get_byte (dsta); upper = (uae_s32)(uae_s8)get_byte (dsta+1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (&regs->ccrflags, (upper == reg || lower == reg) ? 1 : 0);
	SET_CFLG_ALWAYS (&regs->ccrflags, lower <= upper ? ((reg < lower || reg > upper) ? 1 : 0) : ((reg > upper || reg < lower) ? 1 : 0));
	if ((extra & 0x800) && GET_CFLG (&regs->ccrflags)) { Exception (6, regs, oldpc); goto endlabel32; }
}
}}}	m68k_incpc (regs, 6);
endlabel32: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* CHK2.B #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_00fb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 3;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpc (regs, 4);
{	tmppc = m68k_getpc (regs);
	dsta = get_disp_ea_020 (regs, tmppc, next_iword (regs));
	{uae_s32 upper,lower,reg = regs->regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s8)get_byte (dsta); upper = (uae_s32)(uae_s8)get_byte (dsta+1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (&regs->ccrflags, (upper == reg || lower == reg) ? 1 : 0);
	SET_CFLG_ALWAYS (&regs->ccrflags, lower <= upper ? ((reg < lower || reg > upper) ? 1 : 0) : ((reg > upper || reg < lower) ? 1 : 0));
	if ((extra & 0x800) && GET_CFLG (&regs->ccrflags)) { Exception (6, regs, oldpc); goto endlabel33; }
}
}}}}endlabel33: ;
return CYCLE_UNIT / 2 * 14;
}
#endif
/* BTST.L Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0100_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= 31;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* MVPMR.W (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_0108_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr memp = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_u16 val = (get_byte (memp) << 8) + get_byte (memp + 2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* BTST.B Dn,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0110_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* BTST.B Dn,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0118_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* BTST.B Dn,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_0120_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* BTST.B Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_0128_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* BTST.B Dn,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_0130_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* BTST.B Dn,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_0138_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* BTST.B Dn,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_0139_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* BTST.B Dn,(d16,PC) */
unsigned long REGPARAM2 CPUFUNC(op_013a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 2;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_getpc (regs) + 2;
	dsta += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* BTST.B Dn,(d8,PC,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_013b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 3;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	dsta = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* BTST.B Dn,#<data>.B */
unsigned long REGPARAM2 CPUFUNC(op_013c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = get_ibyte (regs, 2);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* BCHG.L Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0140_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= 31;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* MVPMR.L (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_0148_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr memp = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_u32 val = (get_byte (memp) << 24) + (get_byte (memp + 2) << 16)
              + (get_byte (memp + 4) << 8) + get_byte (memp + 6);
	m68k_dreg (regs, dstreg) = (val);
}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* BCHG.B Dn,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0150_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* BCHG.B Dn,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0158_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* BCHG.B Dn,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_0160_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* BCHG.B Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_0168_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* BCHG.B Dn,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_0170_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte (dsta,dst);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* BCHG.B Dn,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_0178_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* BCHG.B Dn,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_0179_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* BCHG.B Dn,(d16,PC) */
unsigned long REGPARAM2 CPUFUNC(op_017a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 2;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_getpc (regs) + 2;
	dsta += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* BCHG.B Dn,(d8,PC,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_017b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 3;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	dsta = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte (dsta,dst);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* BCLR.L Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0180_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= 31;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* MVPRM.W Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_0188_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	uaecptr memp = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
	put_byte (memp, src >> 8); put_byte (memp + 2, src);
}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* BCLR.B Dn,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0190_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* BCLR.B Dn,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0198_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* BCLR.B Dn,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_01a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* BCLR.B Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_01a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* BCLR.B Dn,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_01b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte (dsta,dst);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* BCLR.B Dn,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_01b8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* BCLR.B Dn,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_01b9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* BCLR.B Dn,(d16,PC) */
unsigned long REGPARAM2 CPUFUNC(op_01ba_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 2;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_getpc (regs) + 2;
	dsta += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* BCLR.B Dn,(d8,PC,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_01bb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 3;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	dsta = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte (dsta,dst);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* BSET.L Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_01c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= 31;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* MVPRM.L Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_01c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	uaecptr memp = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
	put_byte (memp, src >> 24); put_byte (memp + 2, src >> 16);
	put_byte (memp + 4, src >> 8); put_byte (memp + 6, src);
}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* BSET.B Dn,(An) */
unsigned long REGPARAM2 CPUFUNC(op_01d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* BSET.B Dn,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_01d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* BSET.B Dn,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_01e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* BSET.B Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_01e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* BSET.B Dn,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_01f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte (dsta,dst);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* BSET.B Dn,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_01f8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* BSET.B Dn,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_01f9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* BSET.B Dn,(d16,PC) */
unsigned long REGPARAM2 CPUFUNC(op_01fa_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 2;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_getpc (regs) + 2;
	dsta += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* BSET.B Dn,(d8,PC,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_01fb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 3;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	dsta = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte (dsta,dst);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* AND.B #<data>.B,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0200_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* AND.B #<data>.B,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0210_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 20;
}
/* AND.B #<data>.B,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0218_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 20;
}
/* AND.B #<data>.B,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_0220_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 22;
}
/* AND.B #<data>.B,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_0228_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 24;
}
/* AND.B #<data>.B,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_0230_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}}return CYCLE_UNIT / 2 * 26;
}
/* AND.B #<data>.B,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_0238_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 24;
}
/* AND.B #<data>.B,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_0239_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 28;
}
/* ANDSR.B #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_023c_0)(uae_u32 opcode, struct regstruct *regs)
{
{	MakeSR (regs);
{	uae_s16 src = get_iword (regs, 2);
	src |= 0xFF00;
	regs->sr &= src;
	MakeFromSR (regs);
}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* AND.W #<data>.W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0240_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* AND.W #<data>.W,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0250_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* AND.W #<data>.W,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0258_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* AND.W #<data>.W,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_0260_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 18;
}
/* AND.W #<data>.W,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_0268_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s16 dst = get_word (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* AND.W #<data>.W,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_0270_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s16 dst = get_word (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* AND.W #<data>.W,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_0278_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s16 dst = get_word (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* AND.W #<data>.W,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_0279_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
{	uae_s16 dst = get_word (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 24;
}
/* ANDSR.W #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_027c_0)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel96; }
{	MakeSR (regs);
{	uae_s16 src = get_iword (regs, 2);
	regs->sr &= src;
	MakeFromSR (regs);
}}}	m68k_incpc (regs, 4);
endlabel96: ;
return CYCLE_UNIT / 2 * 8;
}
/* AND.L #<data>.L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0280_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* AND.L #<data>.L,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0290_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 28;
}
/* AND.L #<data>.L,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0298_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 28;
}
/* AND.L #<data>.L,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_02a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 30;
}
/* AND.L #<data>.L,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_02a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 6);
{	uae_s32 dst = get_long (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 32;
}
/* AND.L #<data>.L,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_02b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 6);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s32 dst = get_long (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}}return CYCLE_UNIT / 2 * 34;
}
/* AND.L #<data>.L,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_02b8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 6);
{	uae_s32 dst = get_long (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 32;
}
/* AND.L #<data>.L,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_02b9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = get_ilong (regs, 6);
{	uae_s32 dst = get_long (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 10);
return CYCLE_UNIT / 2 * 36;
}
/* CHK2.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_02d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	{uae_s32 upper,lower,reg = regs->regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s16)get_word (dsta); upper = (uae_s32)(uae_s16)get_word (dsta+2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (&regs->ccrflags, (upper == reg || lower == reg) ? 1 : 0);
	SET_CFLG_ALWAYS (&regs->ccrflags, lower <= upper ? ((reg < lower || reg > upper) ? 1 : 0) : ((reg > upper || reg < lower) ? 1 : 0));
	if ((extra & 0x800) && GET_CFLG (&regs->ccrflags)) { Exception (6, regs, oldpc); goto endlabel105; }
}
}}}	m68k_incpc (regs, 4);
endlabel105: ;
return CYCLE_UNIT / 2 * 8;
}
#endif
/* CHK2.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_02e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
	{uae_s32 upper,lower,reg = regs->regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s16)get_word (dsta); upper = (uae_s32)(uae_s16)get_word (dsta+2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (&regs->ccrflags, (upper == reg || lower == reg) ? 1 : 0);
	SET_CFLG_ALWAYS (&regs->ccrflags, lower <= upper ? ((reg < lower || reg > upper) ? 1 : 0) : ((reg > upper || reg < lower) ? 1 : 0));
	if ((extra & 0x800) && GET_CFLG (&regs->ccrflags)) { Exception (6, regs, oldpc); goto endlabel106; }
}
}}}	m68k_incpc (regs, 6);
endlabel106: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* CHK2.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_02f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	{uae_s32 upper,lower,reg = regs->regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s16)get_word (dsta); upper = (uae_s32)(uae_s16)get_word (dsta+2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (&regs->ccrflags, (upper == reg || lower == reg) ? 1 : 0);
	SET_CFLG_ALWAYS (&regs->ccrflags, lower <= upper ? ((reg < lower || reg > upper) ? 1 : 0) : ((reg > upper || reg < lower) ? 1 : 0));
	if ((extra & 0x800) && GET_CFLG (&regs->ccrflags)) { Exception (6, regs, oldpc); goto endlabel107; }
}
}}}}endlabel107: ;
return CYCLE_UNIT / 2 * 14;
}
#endif
/* CHK2.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_02f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
	{uae_s32 upper,lower,reg = regs->regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s16)get_word (dsta); upper = (uae_s32)(uae_s16)get_word (dsta+2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (&regs->ccrflags, (upper == reg || lower == reg) ? 1 : 0);
	SET_CFLG_ALWAYS (&regs->ccrflags, lower <= upper ? ((reg < lower || reg > upper) ? 1 : 0) : ((reg > upper || reg < lower) ? 1 : 0));
	if ((extra & 0x800) && GET_CFLG (&regs->ccrflags)) { Exception (6, regs, oldpc); goto endlabel108; }
}
}}}	m68k_incpc (regs, 6);
endlabel108: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* CHK2.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_02f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
	{uae_s32 upper,lower,reg = regs->regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s16)get_word (dsta); upper = (uae_s32)(uae_s16)get_word (dsta+2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (&regs->ccrflags, (upper == reg || lower == reg) ? 1 : 0);
	SET_CFLG_ALWAYS (&regs->ccrflags, lower <= upper ? ((reg < lower || reg > upper) ? 1 : 0) : ((reg > upper || reg < lower) ? 1 : 0));
	if ((extra & 0x800) && GET_CFLG (&regs->ccrflags)) { Exception (6, regs, oldpc); goto endlabel109; }
}
}}}	m68k_incpc (regs, 8);
endlabel109: ;
return CYCLE_UNIT / 2 * 16;
}
#endif
/* CHK2.W #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_02fa_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 2;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta = m68k_getpc (regs) + 4;
	dsta += (uae_s32)(uae_s16)get_iword (regs, 4);
	{uae_s32 upper,lower,reg = regs->regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s16)get_word (dsta); upper = (uae_s32)(uae_s16)get_word (dsta+2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (&regs->ccrflags, (upper == reg || lower == reg) ? 1 : 0);
	SET_CFLG_ALWAYS (&regs->ccrflags, lower <= upper ? ((reg < lower || reg > upper) ? 1 : 0) : ((reg > upper || reg < lower) ? 1 : 0));
	if ((extra & 0x800) && GET_CFLG (&regs->ccrflags)) { Exception (6, regs, oldpc); goto endlabel110; }
}
}}}	m68k_incpc (regs, 6);
endlabel110: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* CHK2.W #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_02fb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 3;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpc (regs, 4);
{	tmppc = m68k_getpc (regs);
	dsta = get_disp_ea_020 (regs, tmppc, next_iword (regs));
	{uae_s32 upper,lower,reg = regs->regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s16)get_word (dsta); upper = (uae_s32)(uae_s16)get_word (dsta+2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (&regs->ccrflags, (upper == reg || lower == reg) ? 1 : 0);
	SET_CFLG_ALWAYS (&regs->ccrflags, lower <= upper ? ((reg < lower || reg > upper) ? 1 : 0) : ((reg > upper || reg < lower) ? 1 : 0));
	if ((extra & 0x800) && GET_CFLG (&regs->ccrflags)) { Exception (6, regs, oldpc); goto endlabel111; }
}
}}}}endlabel111: ;
return CYCLE_UNIT / 2 * 14;
}
#endif
/* SUB.B #<data>.B,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0400_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* SUB.B #<data>.B,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0410_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 20;
}
/* SUB.B #<data>.B,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0418_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 20;
}
/* SUB.B #<data>.B,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_0420_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 22;
}
/* SUB.B #<data>.B,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_0428_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 24;
}
/* SUB.B #<data>.B,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_0430_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}}return CYCLE_UNIT / 2 * 26;
}
/* SUB.B #<data>.B,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_0438_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 24;
}
/* SUB.B #<data>.B,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_0439_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 28;
}
/* SUB.W #<data>.W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0440_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* SUB.W #<data>.W,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0450_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* SUB.W #<data>.W,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0458_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* SUB.W #<data>.W,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_0460_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 18;
}
/* SUB.W #<data>.W,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_0468_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* SUB.W #<data>.W,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_0470_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}}return CYCLE_UNIT / 2 * 22;
}
/* SUB.W #<data>.W,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_0478_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* SUB.W #<data>.W,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_0479_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 24;
}
/* SUB.L #<data>.L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0480_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* SUB.L #<data>.L,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0490_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 28;
}
/* SUB.L #<data>.L,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0498_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 28;
}
/* SUB.L #<data>.L,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_04a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 30;
}
/* SUB.L #<data>.L,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_04a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 6);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 32;
}
/* SUB.L #<data>.L,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_04b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 6);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}}return CYCLE_UNIT / 2 * 34;
}
/* SUB.L #<data>.L,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_04b8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 6);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 32;
}
/* SUB.L #<data>.L,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_04b9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = get_ilong (regs, 6);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 10);
return CYCLE_UNIT / 2 * 36;
}
/* CHK2.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_04d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	{uae_s32 upper,lower,reg = regs->regs[(extra >> 12) & 15];
	lower=get_long (dsta); upper = get_long (dsta+4);
	SET_ZFLG (&regs->ccrflags, (upper == reg || lower == reg) ? 1 : 0);
	SET_CFLG_ALWAYS (&regs->ccrflags, lower <= upper ? ((reg < lower || reg > upper) ? 1 : 0) : ((reg > upper || reg < lower) ? 1 : 0));
	if ((extra & 0x800) && GET_CFLG (&regs->ccrflags)) { Exception (6, regs, oldpc); goto endlabel136; }
}
}}}	m68k_incpc (regs, 4);
endlabel136: ;
return CYCLE_UNIT / 2 * 8;
}
#endif
/* CHK2.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_04e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
	{uae_s32 upper,lower,reg = regs->regs[(extra >> 12) & 15];
	lower=get_long (dsta); upper = get_long (dsta+4);
	SET_ZFLG (&regs->ccrflags, (upper == reg || lower == reg) ? 1 : 0);
	SET_CFLG_ALWAYS (&regs->ccrflags, lower <= upper ? ((reg < lower || reg > upper) ? 1 : 0) : ((reg > upper || reg < lower) ? 1 : 0));
	if ((extra & 0x800) && GET_CFLG (&regs->ccrflags)) { Exception (6, regs, oldpc); goto endlabel137; }
}
}}}	m68k_incpc (regs, 6);
endlabel137: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* CHK2.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_04f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	{uae_s32 upper,lower,reg = regs->regs[(extra >> 12) & 15];
	lower=get_long (dsta); upper = get_long (dsta+4);
	SET_ZFLG (&regs->ccrflags, (upper == reg || lower == reg) ? 1 : 0);
	SET_CFLG_ALWAYS (&regs->ccrflags, lower <= upper ? ((reg < lower || reg > upper) ? 1 : 0) : ((reg > upper || reg < lower) ? 1 : 0));
	if ((extra & 0x800) && GET_CFLG (&regs->ccrflags)) { Exception (6, regs, oldpc); goto endlabel138; }
}
}}}}endlabel138: ;
return CYCLE_UNIT / 2 * 14;
}
#endif
/* CHK2.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_04f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
	{uae_s32 upper,lower,reg = regs->regs[(extra >> 12) & 15];
	lower=get_long (dsta); upper = get_long (dsta+4);
	SET_ZFLG (&regs->ccrflags, (upper == reg || lower == reg) ? 1 : 0);
	SET_CFLG_ALWAYS (&regs->ccrflags, lower <= upper ? ((reg < lower || reg > upper) ? 1 : 0) : ((reg > upper || reg < lower) ? 1 : 0));
	if ((extra & 0x800) && GET_CFLG (&regs->ccrflags)) { Exception (6, regs, oldpc); goto endlabel139; }
}
}}}	m68k_incpc (regs, 6);
endlabel139: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* CHK2.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_04f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
	{uae_s32 upper,lower,reg = regs->regs[(extra >> 12) & 15];
	lower=get_long (dsta); upper = get_long (dsta+4);
	SET_ZFLG (&regs->ccrflags, (upper == reg || lower == reg) ? 1 : 0);
	SET_CFLG_ALWAYS (&regs->ccrflags, lower <= upper ? ((reg < lower || reg > upper) ? 1 : 0) : ((reg > upper || reg < lower) ? 1 : 0));
	if ((extra & 0x800) && GET_CFLG (&regs->ccrflags)) { Exception (6, regs, oldpc); goto endlabel140; }
}
}}}	m68k_incpc (regs, 8);
endlabel140: ;
return CYCLE_UNIT / 2 * 16;
}
#endif
/* CHK2.L #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_04fa_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 2;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta = m68k_getpc (regs) + 4;
	dsta += (uae_s32)(uae_s16)get_iword (regs, 4);
	{uae_s32 upper,lower,reg = regs->regs[(extra >> 12) & 15];
	lower=get_long (dsta); upper = get_long (dsta+4);
	SET_ZFLG (&regs->ccrflags, (upper == reg || lower == reg) ? 1 : 0);
	SET_CFLG_ALWAYS (&regs->ccrflags, lower <= upper ? ((reg < lower || reg > upper) ? 1 : 0) : ((reg > upper || reg < lower) ? 1 : 0));
	if ((extra & 0x800) && GET_CFLG (&regs->ccrflags)) { Exception (6, regs, oldpc); goto endlabel141; }
}
}}}	m68k_incpc (regs, 6);
endlabel141: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* CHK2.L #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_04fb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 3;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpc (regs, 4);
{	tmppc = m68k_getpc (regs);
	dsta = get_disp_ea_020 (regs, tmppc, next_iword (regs));
	{uae_s32 upper,lower,reg = regs->regs[(extra >> 12) & 15];
	lower=get_long (dsta); upper = get_long (dsta+4);
	SET_ZFLG (&regs->ccrflags, (upper == reg || lower == reg) ? 1 : 0);
	SET_CFLG_ALWAYS (&regs->ccrflags, lower <= upper ? ((reg < lower || reg > upper) ? 1 : 0) : ((reg > upper || reg < lower) ? 1 : 0));
	if ((extra & 0x800) && GET_CFLG (&regs->ccrflags)) { Exception (6, regs, oldpc); goto endlabel142; }
}
}}}}endlabel142: ;
return CYCLE_UNIT / 2 * 14;
}
#endif
/* ADD.B #<data>.B,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0600_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* ADD.B #<data>.B,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0610_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 20;
}
/* ADD.B #<data>.B,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0618_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 20;
}
/* ADD.B #<data>.B,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_0620_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 22;
}
/* ADD.B #<data>.B,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_0628_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 24;
}
/* ADD.B #<data>.B,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_0630_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}}return CYCLE_UNIT / 2 * 26;
}
/* ADD.B #<data>.B,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_0638_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 24;
}
/* ADD.B #<data>.B,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_0639_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 28;
}
/* ADD.W #<data>.W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0640_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* ADD.W #<data>.W,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0650_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* ADD.W #<data>.W,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0658_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* ADD.W #<data>.W,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_0660_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 18;
}
/* ADD.W #<data>.W,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_0668_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* ADD.W #<data>.W,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_0670_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}}return CYCLE_UNIT / 2 * 22;
}
/* ADD.W #<data>.W,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_0678_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* ADD.W #<data>.W,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_0679_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 24;
}
/* ADD.L #<data>.L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0680_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* ADD.L #<data>.L,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0690_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 28;
}
/* ADD.L #<data>.L,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0698_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 28;
}
/* ADD.L #<data>.L,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_06a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 30;
}
/* ADD.L #<data>.L,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_06a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 6);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 32;
}
/* ADD.L #<data>.L,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_06b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 6);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}}return CYCLE_UNIT / 2 * 34;
}
/* ADD.L #<data>.L,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_06b8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 6);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 32;
}
/* ADD.L #<data>.L,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_06b9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = get_ilong (regs, 6);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 10);
return CYCLE_UNIT / 2 * 36;
}
/* RTM.L Dn */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_06c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{	m68k_incpc (regs, 2);
	op_illg (opcode, regs);
}return CYCLE_UNIT / 2 * 4;
}
#endif
/* RTM.L An */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_06c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{	m68k_incpc (regs, 2);
	op_illg (opcode, regs);
}return CYCLE_UNIT / 2 * 4;
}
#endif
/* CALLM.L (An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_06d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{	m68k_incpc (regs, 2);
	op_illg (opcode, regs);
}return CYCLE_UNIT / 2 * 4;
}
#endif
/* CALLM.L (d16,An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_06e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{	m68k_incpc (regs, 2);
	op_illg (opcode, regs);
}return CYCLE_UNIT / 2 * 4;
}
#endif
/* CALLM.L (d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_06f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{	m68k_incpc (regs, 2);
	op_illg (opcode, regs);
}return CYCLE_UNIT / 2 * 4;
}
#endif
/* CALLM.L (xxx).W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_06f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{	m68k_incpc (regs, 2);
	op_illg (opcode, regs);
}return CYCLE_UNIT / 2 * 4;
}
#endif
/* CALLM.L (xxx).L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_06f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{	m68k_incpc (regs, 2);
	op_illg (opcode, regs);
}return CYCLE_UNIT / 2 * 4;
}
#endif
/* CALLM.L (d16,PC) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_06fa_0)(uae_u32 opcode, struct regstruct *regs)
{
{	m68k_incpc (regs, 2);
	op_illg (opcode, regs);
}return CYCLE_UNIT / 2 * 4;
}
#endif
/* CALLM.L (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_06fb_0)(uae_u32 opcode, struct regstruct *regs)
{
{	m68k_incpc (regs, 2);
	op_illg (opcode, regs);
}return CYCLE_UNIT / 2 * 4;
}
#endif
/* BTST.L #<data>.W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0800_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= 31;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* BTST.B #<data>.W,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0810_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* BTST.B #<data>.W,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0818_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* BTST.B #<data>.W,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_0820_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 14;
}
/* BTST.B #<data>.W,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_0828_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* BTST.B #<data>.W,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_0830_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* BTST.B #<data>.W,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_0838_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* BTST.B #<data>.W,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_0839_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 20;
}
/* BTST.B #<data>.W,(d16,PC) */
unsigned long REGPARAM2 CPUFUNC(op_083a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 2;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_getpc (regs) + 4;
	dsta += (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* BTST.B #<data>.W,(d8,PC,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_083b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 3;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpc (regs, 4);
{	tmppc = m68k_getpc (regs);
	dsta = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* BTST.B #<data>.W,#<data>.B */
unsigned long REGPARAM2 CPUFUNC(op_083c_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uae_s8 dst = get_ibyte (regs, 4);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* BCHG.L #<data>.W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0840_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= 31;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* BCHG.B #<data>.W,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0850_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* BCHG.B #<data>.W,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0858_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* BCHG.B #<data>.W,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_0860_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 18;
}
/* BCHG.B #<data>.W,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_0868_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* BCHG.B #<data>.W,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_0870_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte (dsta,dst);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* BCHG.B #<data>.W,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_0878_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* BCHG.B #<data>.W,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_0879_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 24;
}
/* BCHG.B #<data>.W,(d16,PC) */
unsigned long REGPARAM2 CPUFUNC(op_087a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 2;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_getpc (regs) + 4;
	dsta += (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* BCHG.B #<data>.W,(d8,PC,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_087b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 3;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpc (regs, 4);
{	tmppc = m68k_getpc (regs);
	dsta = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte (dsta,dst);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* BCLR.L #<data>.W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0880_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= 31;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* BCLR.B #<data>.W,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0890_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* BCLR.B #<data>.W,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0898_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* BCLR.B #<data>.W,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_08a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 18;
}
/* BCLR.B #<data>.W,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_08a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* BCLR.B #<data>.W,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_08b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte (dsta,dst);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* BCLR.B #<data>.W,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_08b8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* BCLR.B #<data>.W,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_08b9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 24;
}
/* BCLR.B #<data>.W,(d16,PC) */
unsigned long REGPARAM2 CPUFUNC(op_08ba_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 2;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_getpc (regs) + 4;
	dsta += (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* BCLR.B #<data>.W,(d8,PC,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_08bb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 3;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpc (regs, 4);
{	tmppc = m68k_getpc (regs);
	dsta = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte (dsta,dst);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* BSET.L #<data>.W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_08c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= 31;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* BSET.B #<data>.W,(An) */
unsigned long REGPARAM2 CPUFUNC(op_08d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* BSET.B #<data>.W,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_08d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* BSET.B #<data>.W,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_08e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 18;
}
/* BSET.B #<data>.W,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_08e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* BSET.B #<data>.W,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_08f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte (dsta,dst);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* BSET.B #<data>.W,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_08f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* BSET.B #<data>.W,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_08f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 24;
}
/* BSET.B #<data>.W,(d16,PC) */
unsigned long REGPARAM2 CPUFUNC(op_08fa_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 2;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_getpc (regs) + 4;
	dsta += (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte (dsta,dst);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* BSET.B #<data>.W,(d8,PC,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_08fb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 3;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpc (regs, 4);
{	tmppc = m68k_getpc (regs);
	dsta = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte (dsta,dst);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* EOR.B #<data>.B,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0a00_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* EOR.B #<data>.B,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0a10_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 20;
}
/* EOR.B #<data>.B,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0a18_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 20;
}
/* EOR.B #<data>.B,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_0a20_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 22;
}
/* EOR.B #<data>.B,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_0a28_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 24;
}
/* EOR.B #<data>.B,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_0a30_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}}return CYCLE_UNIT / 2 * 26;
}
/* EOR.B #<data>.B,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_0a38_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 24;
}
/* EOR.B #<data>.B,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_0a39_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
{	uae_s8 dst = get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 28;
}
/* EORSR.B #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_0a3c_0)(uae_u32 opcode, struct regstruct *regs)
{
{	MakeSR (regs);
{	uae_s16 src = get_iword (regs, 2);
	src &= 0xFF;
	regs->sr ^= src;
	MakeFromSR (regs);
}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* EOR.W #<data>.W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0a40_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* EOR.W #<data>.W,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0a50_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* EOR.W #<data>.W,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0a58_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* EOR.W #<data>.W,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_0a60_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 18;
}
/* EOR.W #<data>.W,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_0a68_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s16 dst = get_word (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* EOR.W #<data>.W,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_0a70_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s16 dst = get_word (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* EOR.W #<data>.W,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_0a78_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s16 dst = get_word (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* EOR.W #<data>.W,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_0a79_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
{	uae_s16 dst = get_word (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 24;
}
#endif

#ifdef PART_2
/* EORSR.W #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_0a7c_0)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel234; }
{	MakeSR (regs);
{	uae_s16 src = get_iword (regs, 2);
	regs->sr ^= src;
	MakeFromSR (regs);
}}}	m68k_incpc (regs, 4);
endlabel234: ;
return CYCLE_UNIT / 2 * 8;
}
/* EOR.L #<data>.L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0a80_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* EOR.L #<data>.L,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0a90_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 28;
}
/* EOR.L #<data>.L,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0a98_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 28;
}
/* EOR.L #<data>.L,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_0aa0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 30;
}
/* EOR.L #<data>.L,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_0aa8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 6);
{	uae_s32 dst = get_long (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 32;
}
/* EOR.L #<data>.L,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_0ab0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 6);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s32 dst = get_long (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}}return CYCLE_UNIT / 2 * 34;
}
/* EOR.L #<data>.L,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_0ab8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 6);
{	uae_s32 dst = get_long (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 32;
}
/* EOR.L #<data>.L,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_0ab9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = get_ilong (regs, 6);
{	uae_s32 dst = get_long (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 10);
return CYCLE_UNIT / 2 * 36;
}
/* CAS.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0ad0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(m68k_dreg (regs, rc)));
{	int flgs = (((uae_s8)(m68k_dreg (regs, rc))) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(m68k_dreg (regs, rc))) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)){	put_byte (dsta,(m68k_dreg (regs, ru)));
}else{m68k_dreg (regs, rc) = dst;
}}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
#endif
/* CAS.B #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0ad8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(m68k_dreg (regs, rc)));
{	int flgs = (((uae_s8)(m68k_dreg (regs, rc))) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(m68k_dreg (regs, rc))) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)){	put_byte (dsta,(m68k_dreg (regs, ru)));
}else{m68k_dreg (regs, rc) = dst;
}}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
#endif
/* CAS.B #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0ae0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(m68k_dreg (regs, rc)));
{	int flgs = (((uae_s8)(m68k_dreg (regs, rc))) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(m68k_dreg (regs, rc))) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)){	put_byte (dsta,(m68k_dreg (regs, ru)));
}else{m68k_dreg (regs, rc) = dst;
}}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 18;
}
#endif
/* CAS.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0ae8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(m68k_dreg (regs, rc)));
{	int flgs = (((uae_s8)(m68k_dreg (regs, rc))) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(m68k_dreg (regs, rc))) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)){	put_byte (dsta,(m68k_dreg (regs, ru)));
}else{m68k_dreg (regs, rc) = dst;
}}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
#endif
/* CAS.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0af0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(m68k_dreg (regs, rc)));
{	int flgs = (((uae_s8)(m68k_dreg (regs, rc))) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(m68k_dreg (regs, rc))) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)){	put_byte (dsta,(m68k_dreg (regs, ru)));
}else{m68k_dreg (regs, rc) = dst;
}}}}}}}}}return CYCLE_UNIT / 2 * 22;
}
#endif
/* CAS.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0af8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(m68k_dreg (regs, rc)));
{	int flgs = (((uae_s8)(m68k_dreg (regs, rc))) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(m68k_dreg (regs, rc))) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)){	put_byte (dsta,(m68k_dreg (regs, ru)));
}else{m68k_dreg (regs, rc) = dst;
}}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
#endif
/* CAS.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0af9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
{	uae_s8 dst = get_byte (dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(m68k_dreg (regs, rc)));
{	int flgs = (((uae_s8)(m68k_dreg (regs, rc))) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(m68k_dreg (regs, rc))) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)){	put_byte (dsta,(m68k_dreg (regs, ru)));
}else{m68k_dreg (regs, rc) = dst;
}}}}}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 24;
}
#endif
/* CMP.B #<data>.B,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0c00_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* CMP.B #<data>.B,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0c10_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* CMP.B #<data>.B,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0c18_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* CMP.B #<data>.B,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_0c20_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 18;
}
/* CMP.B #<data>.B,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_0c28_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* CMP.B #<data>.B,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_0c30_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}return CYCLE_UNIT / 2 * 22;
}
/* CMP.B #<data>.B,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_0c38_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* CMP.B #<data>.B,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_0c39_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 24;
}
/* CMP.B #<data>.B,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0c3a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 2;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = m68k_getpc (regs) + 4;
	dsta += (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
#endif
/* CMP.B #<data>.B,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0c3b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 3;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpc (regs, 4);
{	tmppc = m68k_getpc (regs);
	dsta = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}return CYCLE_UNIT / 2 * 22;
}
#endif
/* CMP.W #<data>.W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0c40_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* CMP.W #<data>.W,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0c50_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* CMP.W #<data>.W,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0c58_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* CMP.W #<data>.W,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_0c60_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 14;
}
/* CMP.W #<data>.W,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_0c68_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* CMP.W #<data>.W,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_0c70_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* CMP.W #<data>.W,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_0c78_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* CMP.W #<data>.W,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_0c79_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 20;
}
/* CMP.W #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0c7a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 2;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_getpc (regs) + 4;
	dsta += (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
#endif
/* CMP.W #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0c7b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 3;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpc (regs, 4);
{	tmppc = m68k_getpc (regs);
	dsta = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}return CYCLE_UNIT / 2 * 18;
}
#endif
/* CMP.L #<data>.L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_0c80_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* CMP.L #<data>.L,(An) */
unsigned long REGPARAM2 CPUFUNC(op_0c90_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* CMP.L #<data>.L,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_0c98_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* CMP.L #<data>.L,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_0ca0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 22;
}
/* CMP.L #<data>.L,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_0ca8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 6);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 24;
}
/* CMP.L #<data>.L,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_0cb0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 6);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}return CYCLE_UNIT / 2 * 26;
}
/* CMP.L #<data>.L,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_0cb8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 6);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 24;
}
/* CMP.L #<data>.L,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_0cb9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = get_ilong (regs, 6);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 10);
return CYCLE_UNIT / 2 * 28;
}
/* CMP.L #<data>.L,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0cba_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 2;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = m68k_getpc (regs) + 6;
	dsta += (uae_s32)(uae_s16)get_iword (regs, 6);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 24;
}
#endif
/* CMP.L #<data>.L,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0cbb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 3;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpc (regs, 6);
{	tmppc = m68k_getpc (regs);
	dsta = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}return CYCLE_UNIT / 2 * 26;
}
#endif
/* CAS.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0cd0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(m68k_dreg (regs, rc)));
{	int flgs = (((uae_s16)(m68k_dreg (regs, rc))) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(m68k_dreg (regs, rc))) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)){	put_word (dsta,(m68k_dreg (regs, ru)));
}else{m68k_dreg (regs, rc) = dst;
}}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
#endif
/* CAS.W #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0cd8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(m68k_dreg (regs, rc)));
{	int flgs = (((uae_s16)(m68k_dreg (regs, rc))) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(m68k_dreg (regs, rc))) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)){	put_word (dsta,(m68k_dreg (regs, ru)));
}else{m68k_dreg (regs, rc) = dst;
}}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
#endif
/* CAS.W #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0ce0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(m68k_dreg (regs, rc)));
{	int flgs = (((uae_s16)(m68k_dreg (regs, rc))) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(m68k_dreg (regs, rc))) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)){	put_word (dsta,(m68k_dreg (regs, ru)));
}else{m68k_dreg (regs, rc) = dst;
}}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 18;
}
#endif
/* CAS.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0ce8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s16 dst = get_word (dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(m68k_dreg (regs, rc)));
{	int flgs = (((uae_s16)(m68k_dreg (regs, rc))) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(m68k_dreg (regs, rc))) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)){	put_word (dsta,(m68k_dreg (regs, ru)));
}else{m68k_dreg (regs, rc) = dst;
}}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
#endif
/* CAS.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0cf0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s16 dst = get_word (dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(m68k_dreg (regs, rc)));
{	int flgs = (((uae_s16)(m68k_dreg (regs, rc))) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(m68k_dreg (regs, rc))) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)){	put_word (dsta,(m68k_dreg (regs, ru)));
}else{m68k_dreg (regs, rc) = dst;
}}}}}}}}}return CYCLE_UNIT / 2 * 22;
}
#endif
/* CAS.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0cf8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s16 dst = get_word (dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(m68k_dreg (regs, rc)));
{	int flgs = (((uae_s16)(m68k_dreg (regs, rc))) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(m68k_dreg (regs, rc))) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)){	put_word (dsta,(m68k_dreg (regs, ru)));
}else{m68k_dreg (regs, rc) = dst;
}}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
#endif
/* CAS.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0cf9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
{	uae_s16 dst = get_word (dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(m68k_dreg (regs, rc)));
{	int flgs = (((uae_s16)(m68k_dreg (regs, rc))) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(m68k_dreg (regs, rc))) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)){	put_word (dsta,(m68k_dreg (regs, ru)));
}else{m68k_dreg (regs, rc) = dst;
}}}}}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 24;
}
#endif
/* CAS2.W #<data>.L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0cfc_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 extra = get_ilong (regs, 2);
	uae_u32 rn1 = regs->regs[(extra >> 28) & 15];
	uae_u32 rn2 = regs->regs[(extra >> 12) & 15];
	uae_u16 dst1 = get_word (rn1), dst2 = get_word (rn2);
{uae_u32 newv = ((uae_s16)(dst1)) - ((uae_s16)(m68k_dreg (regs, (extra >> 16) & 7)));
{	int flgs = (((uae_s16)(m68k_dreg (regs, (extra >> 16) & 7))) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst1)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(m68k_dreg (regs, (extra >> 16) & 7))) > ((uae_u16)(dst1))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)) {
{uae_u32 newv = ((uae_s16)(dst2)) - ((uae_s16)(m68k_dreg (regs, extra & 7)));
{	int flgs = (((uae_s16)(m68k_dreg (regs, extra & 7))) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst2)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(m68k_dreg (regs, extra & 7))) > ((uae_u16)(dst2))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)) {
	put_word (rn1, m68k_dreg (regs, (extra >> 22) & 7));
	put_word (rn1, m68k_dreg (regs, (extra >> 6) & 7));
	}}
}}}}	if (! GET_ZFLG (&regs->ccrflags)) {
	m68k_dreg (regs, (extra >> 22) & 7) = (m68k_dreg (regs, (extra >> 22) & 7) & ~0xffff) | (dst1 & 0xffff);
	m68k_dreg (regs, (extra >> 6) & 7) = (m68k_dreg (regs, (extra >> 6) & 7) & ~0xffff) | (dst2 & 0xffff);
	}
}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
#endif
/* MOVES.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0e10_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs->s) { Exception (8, regs, 0); goto endlabel288; }
{{	uae_s16 extra = get_iword (regs, 2);
	if (extra & 0x800)
{	uae_u32 src = regs->regs[(extra >> 12) & 15];
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte (dsta,src);
}}else{{	uaecptr srca = m68k_areg (regs, dstreg);
{	uae_s8 src = get_byte (srca);
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}}}}	m68k_incpc (regs, 4);
endlabel288: ;
return CYCLE_UNIT / 2 * 16;
}
#endif
/* MOVES.B #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0e18_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs->s) { Exception (8, regs, 0); goto endlabel289; }
{{	uae_s16 extra = get_iword (regs, 2);
	if (extra & 0x800)
{	uae_u32 src = regs->regs[(extra >> 12) & 15];
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte (dsta,src);
}}else{{	uaecptr srca = m68k_areg (regs, dstreg);
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}}}}	m68k_incpc (regs, 4);
endlabel289: ;
return CYCLE_UNIT / 2 * 16;
}
#endif
/* MOVES.B #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0e20_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs->s) { Exception (8, regs, 0); goto endlabel290; }
{{	uae_s16 extra = get_iword (regs, 2);
	if (extra & 0x800)
{	uae_u32 src = regs->regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	put_byte (dsta,src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, dstreg) = srca;
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}}}}	m68k_incpc (regs, 4);
endlabel290: ;
return CYCLE_UNIT / 2 * 20;
}
#endif
/* MOVES.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0e28_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs->s) { Exception (8, regs, 0); goto endlabel291; }
{{	uae_s16 extra = get_iword (regs, 2);
	if (extra & 0x800)
{	uae_u32 src = regs->regs[(extra >> 12) & 15];
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
	put_byte (dsta,src);
}}else{{	uaecptr srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 6);
{	uae_s8 src = get_byte (srca);
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}}}}	m68k_incpc (regs, 8);
endlabel291: ;
return CYCLE_UNIT / 2 * 24;
}
#endif
/* MOVES.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0e30_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs->s) { Exception (8, regs, 0); goto endlabel292; }
{{	uae_s16 extra = get_iword (regs, 2);
	if (extra & 0x800)
{	uae_u32 src = regs->regs[(extra >> 12) & 15];
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_byte (dsta,src);
}}}else{{	uaecptr srca;
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 src = get_byte (srca);
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}}}}}endlabel292: ;
return CYCLE_UNIT / 2 * 28;
}
#endif
/* MOVES.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0e38_0)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel293; }
{{	uae_s16 extra = get_iword (regs, 2);
	if (extra & 0x800)
{	uae_u32 src = regs->regs[(extra >> 12) & 15];
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
	put_byte (dsta,src);
}}else{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 6);
{	uae_s8 src = get_byte (srca);
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}}}}	m68k_incpc (regs, 8);
endlabel293: ;
return CYCLE_UNIT / 2 * 24;
}
#endif
/* MOVES.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0e39_0)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel294; }
{{	uae_s16 extra = get_iword (regs, 2);
	if (extra & 0x800)
{	uae_u32 src = regs->regs[(extra >> 12) & 15];
{	uaecptr dsta = get_ilong (regs, 4);
	put_byte (dsta,src);
}}else{{	uaecptr srca = get_ilong (regs, 8);
{	uae_s8 src = get_byte (srca);
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}}}}	m68k_incpc (regs, 12);
endlabel294: ;
return CYCLE_UNIT / 2 * 32;
}
#endif
/* MOVES.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0e50_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs->s) { Exception (8, regs, 0); goto endlabel295; }
{{	uae_s16 extra = get_iword (regs, 2);
	if (extra & 0x800)
{	uae_u32 src = regs->regs[(extra >> 12) & 15];
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_word (dsta,src);
}}else{{	uaecptr srca = m68k_areg (regs, dstreg);
{	uae_s16 src = get_word (srca);
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}}}}	m68k_incpc (regs, 4);
endlabel295: ;
return CYCLE_UNIT / 2 * 16;
}
#endif
/* MOVES.W #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0e58_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs->s) { Exception (8, regs, 0); goto endlabel296; }
{{	uae_s16 extra = get_iword (regs, 2);
	if (extra & 0x800)
{	uae_u32 src = regs->regs[(extra >> 12) & 15];
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	put_word (dsta,src);
}}else{{	uaecptr srca = m68k_areg (regs, dstreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, dstreg) += 2;
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}}}}	m68k_incpc (regs, 4);
endlabel296: ;
return CYCLE_UNIT / 2 * 16;
}
#endif
/* MOVES.W #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0e60_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs->s) { Exception (8, regs, 0); goto endlabel297; }
{{	uae_s16 extra = get_iword (regs, 2);
	if (extra & 0x800)
{	uae_u32 src = regs->regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	put_word (dsta,src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, dstreg) = srca;
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}}}}	m68k_incpc (regs, 4);
endlabel297: ;
return CYCLE_UNIT / 2 * 20;
}
#endif
/* MOVES.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0e68_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs->s) { Exception (8, regs, 0); goto endlabel298; }
{{	uae_s16 extra = get_iword (regs, 2);
	if (extra & 0x800)
{	uae_u32 src = regs->regs[(extra >> 12) & 15];
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
	put_word (dsta,src);
}}else{{	uaecptr srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 6);
{	uae_s16 src = get_word (srca);
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}}}}	m68k_incpc (regs, 8);
endlabel298: ;
return CYCLE_UNIT / 2 * 24;
}
#endif
/* MOVES.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0e70_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs->s) { Exception (8, regs, 0); goto endlabel299; }
{{	uae_s16 extra = get_iword (regs, 2);
	if (extra & 0x800)
{	uae_u32 src = regs->regs[(extra >> 12) & 15];
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_word (dsta,src);
}}}else{{	uaecptr srca;
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}}}}}endlabel299: ;
return CYCLE_UNIT / 2 * 28;
}
#endif
/* MOVES.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0e78_0)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel300; }
{{	uae_s16 extra = get_iword (regs, 2);
	if (extra & 0x800)
{	uae_u32 src = regs->regs[(extra >> 12) & 15];
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
	put_word (dsta,src);
}}else{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 6);
{	uae_s16 src = get_word (srca);
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}}}}	m68k_incpc (regs, 8);
endlabel300: ;
return CYCLE_UNIT / 2 * 24;
}
#endif
/* MOVES.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0e79_0)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel301; }
{{	uae_s16 extra = get_iword (regs, 2);
	if (extra & 0x800)
{	uae_u32 src = regs->regs[(extra >> 12) & 15];
{	uaecptr dsta = get_ilong (regs, 4);
	put_word (dsta,src);
}}else{{	uaecptr srca = get_ilong (regs, 8);
{	uae_s16 src = get_word (srca);
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}}}}	m68k_incpc (regs, 12);
endlabel301: ;
return CYCLE_UNIT / 2 * 32;
}
#endif
/* MOVES.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0e90_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs->s) { Exception (8, regs, 0); goto endlabel302; }
{{	uae_s16 extra = get_iword (regs, 2);
	if (extra & 0x800)
{	uae_u32 src = regs->regs[(extra >> 12) & 15];
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_long (dsta,src);
}}else{{	uaecptr srca = m68k_areg (regs, dstreg);
{	uae_s32 src = get_long (srca);
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (src);
	}
}}}}}}	m68k_incpc (regs, 4);
endlabel302: ;
return CYCLE_UNIT / 2 * 24;
}
#endif
/* MOVES.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0e98_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs->s) { Exception (8, regs, 0); goto endlabel303; }
{{	uae_s16 extra = get_iword (regs, 2);
	if (extra & 0x800)
{	uae_u32 src = regs->regs[(extra >> 12) & 15];
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	put_long (dsta,src);
}}else{{	uaecptr srca = m68k_areg (regs, dstreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, dstreg) += 4;
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (src);
	}
}}}}}}	m68k_incpc (regs, 4);
endlabel303: ;
return CYCLE_UNIT / 2 * 24;
}
#endif
/* MOVES.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0ea0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs->s) { Exception (8, regs, 0); goto endlabel304; }
{{	uae_s16 extra = get_iword (regs, 2);
	if (extra & 0x800)
{	uae_u32 src = regs->regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	put_long (dsta,src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, dstreg) = srca;
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (src);
	}
}}}}}}	m68k_incpc (regs, 4);
endlabel304: ;
return CYCLE_UNIT / 2 * 28;
}
#endif
/* MOVES.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0ea8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs->s) { Exception (8, regs, 0); goto endlabel305; }
{{	uae_s16 extra = get_iword (regs, 2);
	if (extra & 0x800)
{	uae_u32 src = regs->regs[(extra >> 12) & 15];
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
	put_long (dsta,src);
}}else{{	uaecptr srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 6);
{	uae_s32 src = get_long (srca);
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (src);
	}
}}}}}}	m68k_incpc (regs, 8);
endlabel305: ;
return CYCLE_UNIT / 2 * 32;
}
#endif
/* MOVES.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0eb0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs->s) { Exception (8, regs, 0); goto endlabel306; }
{{	uae_s16 extra = get_iword (regs, 2);
	if (extra & 0x800)
{	uae_u32 src = regs->regs[(extra >> 12) & 15];
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_long (dsta,src);
}}}else{{	uaecptr srca;
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (src);
	}
}}}}}}}endlabel306: ;
return CYCLE_UNIT / 2 * 36;
}
#endif
/* MOVES.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0eb8_0)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel307; }
{{	uae_s16 extra = get_iword (regs, 2);
	if (extra & 0x800)
{	uae_u32 src = regs->regs[(extra >> 12) & 15];
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
	put_long (dsta,src);
}}else{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 6);
{	uae_s32 src = get_long (srca);
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (src);
	}
}}}}}}	m68k_incpc (regs, 8);
endlabel307: ;
return CYCLE_UNIT / 2 * 32;
}
#endif
/* MOVES.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0eb9_0)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel308; }
{{	uae_s16 extra = get_iword (regs, 2);
	if (extra & 0x800)
{	uae_u32 src = regs->regs[(extra >> 12) & 15];
{	uaecptr dsta = get_ilong (regs, 4);
	put_long (dsta,src);
}}else{{	uaecptr srca = get_ilong (regs, 8);
{	uae_s32 src = get_long (srca);
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (src);
	}
}}}}}}	m68k_incpc (regs, 12);
endlabel308: ;
return CYCLE_UNIT / 2 * 40;
}
#endif
/* CAS.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0ed0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(m68k_dreg (regs, rc)));
{	int flgs = (((uae_s32)(m68k_dreg (regs, rc))) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(m68k_dreg (regs, rc))) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)){	put_long (dsta,(m68k_dreg (regs, ru)));
}else{m68k_dreg (regs, rc) = dst;
}}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 24;
}
#endif
/* CAS.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0ed8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(m68k_dreg (regs, rc)));
{	int flgs = (((uae_s32)(m68k_dreg (regs, rc))) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(m68k_dreg (regs, rc))) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)){	put_long (dsta,(m68k_dreg (regs, ru)));
}else{m68k_dreg (regs, rc) = dst;
}}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 24;
}
#endif
/* CAS.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0ee0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(m68k_dreg (regs, rc)));
{	int flgs = (((uae_s32)(m68k_dreg (regs, rc))) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(m68k_dreg (regs, rc))) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)){	put_long (dsta,(m68k_dreg (regs, ru)));
}else{m68k_dreg (regs, rc) = dst;
}}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 26;
}
#endif
/* CAS.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0ee8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s32 dst = get_long (dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(m68k_dreg (regs, rc)));
{	int flgs = (((uae_s32)(m68k_dreg (regs, rc))) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(m68k_dreg (regs, rc))) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)){	put_long (dsta,(m68k_dreg (regs, ru)));
}else{m68k_dreg (regs, rc) = dst;
}}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 28;
}
#endif
/* CAS.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0ef0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s32 dst = get_long (dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(m68k_dreg (regs, rc)));
{	int flgs = (((uae_s32)(m68k_dreg (regs, rc))) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(m68k_dreg (regs, rc))) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)){	put_long (dsta,(m68k_dreg (regs, ru)));
}else{m68k_dreg (regs, rc) = dst;
}}}}}}}}}return CYCLE_UNIT / 2 * 30;
}
#endif
/* CAS.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0ef8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s32 dst = get_long (dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(m68k_dreg (regs, rc)));
{	int flgs = (((uae_s32)(m68k_dreg (regs, rc))) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(m68k_dreg (regs, rc))) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)){	put_long (dsta,(m68k_dreg (regs, ru)));
}else{m68k_dreg (regs, rc) = dst;
}}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 28;
}
#endif
/* CAS.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0ef9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
{	uae_s32 dst = get_long (dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(m68k_dreg (regs, rc)));
{	int flgs = (((uae_s32)(m68k_dreg (regs, rc))) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(m68k_dreg (regs, rc))) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)){	put_long (dsta,(m68k_dreg (regs, ru)));
}else{m68k_dreg (regs, rc) = dst;
}}}}}}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 32;
}
#endif
/* CAS2.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_0efc_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 extra = get_ilong (regs, 2);
	uae_u32 rn1 = regs->regs[(extra >> 28) & 15];
	uae_u32 rn2 = regs->regs[(extra >> 12) & 15];
	uae_u32 dst1 = get_long (rn1), dst2 = get_long (rn2);
{uae_u32 newv = ((uae_s32)(dst1)) - ((uae_s32)(m68k_dreg (regs, (extra >> 16) & 7)));
{	int flgs = (((uae_s32)(m68k_dreg (regs, (extra >> 16) & 7))) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst1)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(m68k_dreg (regs, (extra >> 16) & 7))) > ((uae_u32)(dst1))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)) {
{uae_u32 newv = ((uae_s32)(dst2)) - ((uae_s32)(m68k_dreg (regs, extra & 7)));
{	int flgs = (((uae_s32)(m68k_dreg (regs, extra & 7))) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst2)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(m68k_dreg (regs, extra & 7))) > ((uae_u32)(dst2))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
	if (GET_ZFLG (&regs->ccrflags)) {
	put_long (rn1, m68k_dreg (regs, (extra >> 22) & 7));
	put_long (rn1, m68k_dreg (regs, (extra >> 6) & 7));
	}}
}}}}	if (! GET_ZFLG (&regs->ccrflags)) {
	m68k_dreg (regs, (extra >> 22) & 7) = dst1;
	m68k_dreg (regs, (extra >> 6) & 7) = dst2;
	}
}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
#endif
/* MOVE.B Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_1000_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 4;
}
/* MOVE.B (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_1010_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 8;
}
/* MOVE.B (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_1018_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 8;
}
/* MOVE.B -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_1020_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 10;
}
/* MOVE.B (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_1028_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.B (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_1030_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* MOVE.B (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_1038_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.B (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_1039_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s8 src = get_byte (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.B (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_103a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.B (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_103b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* MOVE.B #<data>.B,Dn */
unsigned long REGPARAM2 CPUFUNC(op_103c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.B Dn,(An) */
unsigned long REGPARAM2 CPUFUNC(op_1080_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 8;
}
/* MOVE.B (An),(An) */
unsigned long REGPARAM2 CPUFUNC(op_1090_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.B (An)+,(An) */
unsigned long REGPARAM2 CPUFUNC(op_1098_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.B -(An),(An) */
unsigned long REGPARAM2 CPUFUNC(op_10a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 14;
}
/* MOVE.B (d16,An),(An) */
unsigned long REGPARAM2 CPUFUNC(op_10a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.B (d8,An,Xn),(An) */
unsigned long REGPARAM2 CPUFUNC(op_10b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.B (xxx).W,(An) */
unsigned long REGPARAM2 CPUFUNC(op_10b8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.B (xxx).L,(An) */
unsigned long REGPARAM2 CPUFUNC(op_10b9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.B (d16,PC),(An) */
unsigned long REGPARAM2 CPUFUNC(op_10ba_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.B (d8,PC,Xn),(An) */
unsigned long REGPARAM2 CPUFUNC(op_10bb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.B #<data>.B,(An) */
unsigned long REGPARAM2 CPUFUNC(op_10bc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.B Dn,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_10c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 8;
}
/* MOVE.B (An),(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_10d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.B (An)+,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_10d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.B -(An),(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_10e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 14;
}
/* MOVE.B (d16,An),(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_10e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.B (d8,An,Xn),(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_10f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.B (xxx).W,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_10f8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.B (xxx).L,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_10f9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.B (d16,PC),(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_10fa_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.B (d8,PC,Xn),(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_10fb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.B #<data>.B,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_10fc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.B Dn,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_1100_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 8;
}
/* MOVE.B (An),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_1110_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.B (An)+,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_1118_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.B -(An),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_1120_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 14;
}
/* MOVE.B (d16,An),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_1128_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.B (d8,An,Xn),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_1130_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.B (xxx).W,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_1138_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.B (xxx).L,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_1139_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.B (d16,PC),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_113a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.B (d8,PC,Xn),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_113b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.B #<data>.B,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_113c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.B Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_1140_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.B (An),(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_1150_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.B (An)+,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_1158_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.B -(An),(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_1160_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.B (d16,An),(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_1168_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.B (d8,An,Xn),(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_1170_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 0);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* MOVE.B (xxx).W,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_1178_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.B (xxx).L,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_1179_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 6);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.B (d16,PC),(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_117a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.B (d8,PC,Xn),(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_117b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 0);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* MOVE.B #<data>.B,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_117c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.B Dn,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_1180_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}}return CYCLE_UNIT / 2 * 14;
}
/* MOVE.B (An),(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_1190_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.B (An)+,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_1198_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.B -(An),(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_11a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.B (d16,An),(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_11a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* MOVE.B (d8,An,Xn),(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_11b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta;
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.B (xxx).W,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_11b8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* MOVE.B (xxx).L,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_11b9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta;
	m68k_incpc (regs, 6);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 26;
}
/* MOVE.B (d16,PC),(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_11ba_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* MOVE.B (d8,PC,Xn),(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_11bb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta;
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.B #<data>.B,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_11bc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}}return CYCLE_UNIT / 2 * 22;
}
/* MOVE.B Dn,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_11c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.B (An),(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_11d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.B (An)+,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_11d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.B -(An),(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_11e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.B (d16,An),(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_11e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.B (d8,An,Xn),(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_11f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 0);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* MOVE.B (xxx).W,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_11f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.B (xxx).L,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_11f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 6);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.B (d16,PC),(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_11fa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.B (d8,PC,Xn),(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_11fb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 0);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* MOVE.B #<data>.B,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_11fc_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.B Dn,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_13c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.B (An),(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_13d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = get_ilong (regs, 2);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.B (An)+,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_13d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta = get_ilong (regs, 2);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.B -(An),(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_13e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = get_ilong (regs, 2);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 22;
}
/* MOVE.B (d16,An),(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_13e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = get_ilong (regs, 4);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.B (d8,An,Xn),(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_13f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = get_ilong (regs, 0);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}}return CYCLE_UNIT / 2 * 26;
}
/* MOVE.B (xxx).W,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_13f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = get_ilong (regs, 4);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.B (xxx).L,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_13f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = get_ilong (regs, 6);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 10);
}}}}return CYCLE_UNIT / 2 * 28;
}
/* MOVE.B (d16,PC),(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_13fa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = get_ilong (regs, 4);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.B (d8,PC,Xn),(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_13fb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uaecptr dsta = get_ilong (regs, 0);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}}return CYCLE_UNIT / 2 * 26;
}
/* MOVE.B #<data>.B,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_13fc_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = get_ibyte (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
	put_byte (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.L Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_2000_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 4;
}
/* MOVE.L An,Dn */
unsigned long REGPARAM2 CPUFUNC(op_2008_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 4;
}
/* MOVE.L (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_2010_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.L (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_2018_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.L -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_2020_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 14;
}
/* MOVE.L (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_2028_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.L (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_2030_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.L (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_2038_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.L (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_2039_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s32 src = get_long (srca);
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.L (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_203a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.L (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_203b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s32 src = get_long (srca);
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.L #<data>.L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_203c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVEA.L Dn,An */
unsigned long REGPARAM2 CPUFUNC(op_2040_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 4;
}
/* MOVEA.L An,An */
unsigned long REGPARAM2 CPUFUNC(op_2048_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 4;
}
/* MOVEA.L (An),An */
unsigned long REGPARAM2 CPUFUNC(op_2050_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVEA.L (An)+,An */
unsigned long REGPARAM2 CPUFUNC(op_2058_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVEA.L -(An),An */
unsigned long REGPARAM2 CPUFUNC(op_2060_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 14;
}
/* MOVEA.L (d16,An),An */
unsigned long REGPARAM2 CPUFUNC(op_2068_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVEA.L (d8,An,Xn),An */
unsigned long REGPARAM2 CPUFUNC(op_2070_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
{	m68k_areg (regs, dstreg) = (src);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVEA.L (xxx).W,An */
unsigned long REGPARAM2 CPUFUNC(op_2078_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVEA.L (xxx).L,An */
unsigned long REGPARAM2 CPUFUNC(op_2079_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s32 src = get_long (srca);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVEA.L (d16,PC),An */
unsigned long REGPARAM2 CPUFUNC(op_207a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVEA.L (d8,PC,Xn),An */
unsigned long REGPARAM2 CPUFUNC(op_207b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s32 src = get_long (srca);
{	m68k_areg (regs, dstreg) = (src);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVEA.L #<data>.L,An */
unsigned long REGPARAM2 CPUFUNC(op_207c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpc (regs, 6);
}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.L Dn,(An) */
unsigned long REGPARAM2 CPUFUNC(op_2080_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.L An,(An) */
unsigned long REGPARAM2 CPUFUNC(op_2088_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.L (An),(An) */
unsigned long REGPARAM2 CPUFUNC(op_2090_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.L (An)+,(An) */
unsigned long REGPARAM2 CPUFUNC(op_2098_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.L -(An),(An) */
unsigned long REGPARAM2 CPUFUNC(op_20a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 22;
}
/* MOVE.L (d16,An),(An) */
unsigned long REGPARAM2 CPUFUNC(op_20a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.L (d8,An,Xn),(An) */
unsigned long REGPARAM2 CPUFUNC(op_20b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 26;
}
/* MOVE.L (xxx).W,(An) */
unsigned long REGPARAM2 CPUFUNC(op_20b8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.L (xxx).L,(An) */
unsigned long REGPARAM2 CPUFUNC(op_20b9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 28;
}
/* MOVE.L (d16,PC),(An) */
unsigned long REGPARAM2 CPUFUNC(op_20ba_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.L (d8,PC,Xn),(An) */
unsigned long REGPARAM2 CPUFUNC(op_20bb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 26;
}
/* MOVE.L #<data>.L,(An) */
unsigned long REGPARAM2 CPUFUNC(op_20bc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.L Dn,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_20c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.L An,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_20c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.L (An),(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_20d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.L (An)+,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_20d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.L -(An),(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_20e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 22;
}
/* MOVE.L (d16,An),(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_20e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.L (d8,An,Xn),(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_20f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 26;
}
/* MOVE.L (xxx).W,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_20f8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.L (xxx).L,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_20f9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 28;
}
/* MOVE.L (d16,PC),(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_20fa_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.L (d8,PC,Xn),(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_20fb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 26;
}
/* MOVE.L #<data>.L,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_20fc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.L Dn,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_2100_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.L An,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_2108_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.L (An),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_2110_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.L (An)+,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_2118_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.L -(An),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_2120_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 22;
}
/* MOVE.L (d16,An),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_2128_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.L (d8,An,Xn),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_2130_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 26;
}
/* MOVE.L (xxx).W,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_2138_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.L (xxx).L,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_2139_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 28;
}
/* MOVE.L (d16,PC),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_213a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.L (d8,PC,Xn),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_213b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 26;
}
/* MOVE.L #<data>.L,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_213c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.L Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_2140_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.L An,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_2148_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}return CYCLE_UNIT / 2 * 16;
}
#endif

#ifdef PART_3
/* MOVE.L (An),(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_2150_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.L (An)+,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_2158_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.L -(An),(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_2160_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 26;
}
/* MOVE.L (d16,An),(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_2168_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 28;
}
/* MOVE.L (d8,An,Xn),(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_2170_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 0);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}}return CYCLE_UNIT / 2 * 30;
}
/* MOVE.L (xxx).W,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_2178_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 28;
}
/* MOVE.L (xxx).L,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_2179_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 6);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
}}}}return CYCLE_UNIT / 2 * 32;
}
/* MOVE.L (d16,PC),(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_217a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 28;
}
/* MOVE.L (d8,PC,Xn),(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_217b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 0);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}}return CYCLE_UNIT / 2 * 30;
}
/* MOVE.L #<data>.L,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_217c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 6);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.L Dn,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_2180_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.L An,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_2188_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.L (An),(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_2190_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 26;
}
/* MOVE.L (An)+,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_2198_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 26;
}
/* MOVE.L -(An),(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_21a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 28;
}
/* MOVE.L (d16,An),(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_21a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 30;
}
/* MOVE.L (d8,An,Xn),(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_21b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uaecptr dsta;
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}}}return CYCLE_UNIT / 2 * 32;
}
/* MOVE.L (xxx).W,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_21b8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 30;
}
/* MOVE.L (xxx).L,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_21b9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta;
	m68k_incpc (regs, 6);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 34;
}
/* MOVE.L (d16,PC),(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_21ba_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 30;
}
/* MOVE.L (d8,PC,Xn),(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_21bb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uaecptr dsta;
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}}}return CYCLE_UNIT / 2 * 32;
}
/* MOVE.L #<data>.L,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_21bc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 6);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}return CYCLE_UNIT / 2 * 26;
}
/* MOVE.L Dn,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_21c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.L An,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_21c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.L (An),(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_21d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.L (An)+,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_21d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.L -(An),(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_21e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 26;
}
/* MOVE.L (d16,An),(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_21e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 28;
}
/* MOVE.L (d8,An,Xn),(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_21f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 0);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}}return CYCLE_UNIT / 2 * 30;
}
/* MOVE.L (xxx).W,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_21f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 28;
}
/* MOVE.L (xxx).L,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_21f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 6);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
}}}}return CYCLE_UNIT / 2 * 32;
}
/* MOVE.L (d16,PC),(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_21fa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 28;
}
/* MOVE.L (d8,PC,Xn),(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_21fb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 0);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}}return CYCLE_UNIT / 2 * 30;
}
/* MOVE.L #<data>.L,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_21fc_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 6);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.L Dn,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_23c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.L An,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_23c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.L (An),(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_23d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = get_ilong (regs, 2);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 28;
}
/* MOVE.L (An)+,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_23d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta = get_ilong (regs, 2);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 28;
}
/* MOVE.L -(An),(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_23e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = get_ilong (regs, 2);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 30;
}
/* MOVE.L (d16,An),(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_23e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = get_ilong (regs, 4);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
}}}}return CYCLE_UNIT / 2 * 32;
}
/* MOVE.L (d8,An,Xn),(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_23f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = get_ilong (regs, 0);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}}return CYCLE_UNIT / 2 * 34;
}
/* MOVE.L (xxx).W,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_23f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = get_ilong (regs, 4);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
}}}}return CYCLE_UNIT / 2 * 32;
}
/* MOVE.L (xxx).L,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_23f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = get_ilong (regs, 6);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 10);
}}}}return CYCLE_UNIT / 2 * 36;
}
/* MOVE.L (d16,PC),(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_23fa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = get_ilong (regs, 4);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
}}}}return CYCLE_UNIT / 2 * 32;
}
/* MOVE.L (d8,PC,Xn),(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_23fb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uaecptr dsta = get_ilong (regs, 0);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}}return CYCLE_UNIT / 2 * 34;
}
/* MOVE.L #<data>.L,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_23fc_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
{	uaecptr dsta = get_ilong (regs, 6);
	put_long (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 10);
}}}return CYCLE_UNIT / 2 * 28;
}
/* MOVE.W Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_3000_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 4;
}
/* MOVE.W An,Dn */
unsigned long REGPARAM2 CPUFUNC(op_3008_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 4;
}
/* MOVE.W (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_3010_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 8;
}
/* MOVE.W (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_3018_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 8;
}
/* MOVE.W -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_3020_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 10;
}
/* MOVE.W (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_3028_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.W (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_3030_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* MOVE.W (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_3038_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.W (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_3039_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.W (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_303a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.W (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_303b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* MOVE.W #<data>.W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_303c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}return CYCLE_UNIT / 2 * 8;
}
/* MOVEA.W Dn,An */
unsigned long REGPARAM2 CPUFUNC(op_3040_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 4;
}
/* MOVEA.W An,An */
unsigned long REGPARAM2 CPUFUNC(op_3048_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 4;
}
/* MOVEA.W (An),An */
unsigned long REGPARAM2 CPUFUNC(op_3050_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 8;
}
/* MOVEA.W (An)+,An */
unsigned long REGPARAM2 CPUFUNC(op_3058_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 8;
}
/* MOVEA.W -(An),An */
unsigned long REGPARAM2 CPUFUNC(op_3060_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 10;
}
/* MOVEA.W (d16,An),An */
unsigned long REGPARAM2 CPUFUNC(op_3068_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVEA.W (d8,An,Xn),An */
unsigned long REGPARAM2 CPUFUNC(op_3070_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* MOVEA.W (xxx).W,An */
unsigned long REGPARAM2 CPUFUNC(op_3078_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVEA.W (xxx).L,An */
unsigned long REGPARAM2 CPUFUNC(op_3079_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVEA.W (d16,PC),An */
unsigned long REGPARAM2 CPUFUNC(op_307a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVEA.W (d8,PC,Xn),An */
unsigned long REGPARAM2 CPUFUNC(op_307b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* MOVEA.W #<data>.W,An */
unsigned long REGPARAM2 CPUFUNC(op_307c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpc (regs, 4);
}}}return CYCLE_UNIT / 2 * 8;
}
/* MOVE.W Dn,(An) */
unsigned long REGPARAM2 CPUFUNC(op_3080_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 8;
}
/* MOVE.W An,(An) */
unsigned long REGPARAM2 CPUFUNC(op_3088_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 8;
}
/* MOVE.W (An),(An) */
unsigned long REGPARAM2 CPUFUNC(op_3090_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.W (An)+,(An) */
unsigned long REGPARAM2 CPUFUNC(op_3098_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.W -(An),(An) */
unsigned long REGPARAM2 CPUFUNC(op_30a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 14;
}
/* MOVE.W (d16,An),(An) */
unsigned long REGPARAM2 CPUFUNC(op_30a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.W (d8,An,Xn),(An) */
unsigned long REGPARAM2 CPUFUNC(op_30b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.W (xxx).W,(An) */
unsigned long REGPARAM2 CPUFUNC(op_30b8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.W (xxx).L,(An) */
unsigned long REGPARAM2 CPUFUNC(op_30b9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.W (d16,PC),(An) */
unsigned long REGPARAM2 CPUFUNC(op_30ba_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.W (d8,PC,Xn),(An) */
unsigned long REGPARAM2 CPUFUNC(op_30bb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.W #<data>.W,(An) */
unsigned long REGPARAM2 CPUFUNC(op_30bc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.W Dn,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_30c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 8;
}
/* MOVE.W An,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_30c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 8;
}
/* MOVE.W (An),(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_30d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.W (An)+,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_30d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.W -(An),(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_30e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 14;
}
/* MOVE.W (d16,An),(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_30e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.W (d8,An,Xn),(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_30f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.W (xxx).W,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_30f8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.W (xxx).L,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_30f9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.W (d16,PC),(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_30fa_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.W (d8,PC,Xn),(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_30fb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.W #<data>.W,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_30fc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.W Dn,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_3100_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 8;
}
/* MOVE.W An,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_3108_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 8;
}
/* MOVE.W (An),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_3110_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.W (An)+,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_3118_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.W -(An),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_3120_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 14;
}
/* MOVE.W (d16,An),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_3128_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.W (d8,An,Xn),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_3130_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.W (xxx).W,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_3138_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.W (xxx).L,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_3139_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.W (d16,PC),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_313a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.W (d8,PC,Xn),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_313b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.W #<data>.W,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_313c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.W Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_3140_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.W An,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_3148_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.W (An),(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_3150_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.W (An)+,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_3158_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.W -(An),(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_3160_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.W (d16,An),(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_3168_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.W (d8,An,Xn),(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_3170_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 0);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* MOVE.W (xxx).W,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_3178_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.W (xxx).L,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_3179_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 6);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.W (d16,PC),(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_317a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.W (d8,PC,Xn),(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_317b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 0);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* MOVE.W #<data>.W,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_317c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.W Dn,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_3180_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}return CYCLE_UNIT / 2 * 14;
}
/* MOVE.W An,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_3188_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}return CYCLE_UNIT / 2 * 14;
}
/* MOVE.W (An),(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_3190_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.W (An)+,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_3198_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.W -(An),(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_31a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.W (d16,An),(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_31a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* MOVE.W (d8,An,Xn),(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_31b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uaecptr dsta;
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.W (xxx).W,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_31b8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* MOVE.W (xxx).L,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_31b9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta;
	m68k_incpc (regs, 6);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 26;
}
/* MOVE.W (d16,PC),(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_31ba_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* MOVE.W (d8,PC,Xn),(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_31bb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uaecptr dsta;
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.W #<data>.W,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_31bc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.W Dn,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_31c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.W An,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_31c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}return CYCLE_UNIT / 2 * 12;
}
/* MOVE.W (An),(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_31d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.W (An)+,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_31d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.W -(An),(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_31e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 18;
}
/* MOVE.W (d16,An),(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_31e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.W (d8,An,Xn),(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_31f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 0);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* MOVE.W (xxx).W,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_31f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.W (xxx).L,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_31f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 6);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.W (d16,PC),(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_31fa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.W (d8,PC,Xn),(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_31fb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 0);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}}return CYCLE_UNIT / 2 * 22;
}
/* MOVE.W #<data>.W,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_31fc_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.W Dn,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_33c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.W An,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_33c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVE.W (An),(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_33d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = get_ilong (regs, 2);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.W (An)+,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_33d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta = get_ilong (regs, 2);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 20;
}
/* MOVE.W -(An),(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_33e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = get_ilong (regs, 2);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}return CYCLE_UNIT / 2 * 22;
}
/* MOVE.W (d16,An),(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_33e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = get_ilong (regs, 4);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.W (d8,An,Xn),(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_33f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = get_ilong (regs, 0);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}}return CYCLE_UNIT / 2 * 26;
}
/* MOVE.W (xxx).W,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_33f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = get_ilong (regs, 4);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.W (xxx).L,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_33f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = get_ilong (regs, 6);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 10);
}}}}return CYCLE_UNIT / 2 * 28;
}
/* MOVE.W (d16,PC),(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_33fa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = get_ilong (regs, 4);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
}}}}return CYCLE_UNIT / 2 * 24;
}
/* MOVE.W (d8,PC,Xn),(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_33fb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uaecptr dsta = get_ilong (regs, 0);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}}return CYCLE_UNIT / 2 * 26;
}
/* MOVE.W #<data>.W,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_33fc_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
	put_word (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
}}}return CYCLE_UNIT / 2 * 20;
}
/* NEGX.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_4000_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((newv) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* NEGX.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_4010_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte (srca,newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* NEGX.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_4018_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte (srca,newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* NEGX.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_4020_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte (srca,newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* NEGX.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_4028_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte (srca,newv);
}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* NEGX.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_4030_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte (srca,newv);
}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* NEGX.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_4038_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte (srca,newv);
}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* NEGX.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_4039_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte (srca,newv);
}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* NEGX.W Dn */
unsigned long REGPARAM2 CPUFUNC(op_4040_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s16)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((newv) & 0xffff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* NEGX.W (An) */
unsigned long REGPARAM2 CPUFUNC(op_4050_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s16)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
	put_word (srca,newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* NEGX.W (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_4058_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s16)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
	put_word (srca,newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* NEGX.W -(An) */
unsigned long REGPARAM2 CPUFUNC(op_4060_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s16)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
	put_word (srca,newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* NEGX.W (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_4068_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s16)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
	put_word (srca,newv);
}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* NEGX.W (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_4070_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s16)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
	put_word (srca,newv);
}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* NEGX.W (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_4078_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s16)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
	put_word (srca,newv);
}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* NEGX.W (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_4079_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s16)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
	put_word (srca,newv);
}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* NEGX.L Dn */
unsigned long REGPARAM2 CPUFUNC(op_4080_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s32)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (newv);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* NEGX.L (An) */
unsigned long REGPARAM2 CPUFUNC(op_4090_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s32)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	put_long (srca,newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 20;
}
/* NEGX.L (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_4098_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s32)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	put_long (srca,newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 20;
}
/* NEGX.L -(An) */
unsigned long REGPARAM2 CPUFUNC(op_40a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s32)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	put_long (srca,newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 22;
}
/* NEGX.L (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_40a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s32)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	put_long (srca,newv);
}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 24;
}
/* NEGX.L (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_40b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s32)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	put_long (srca,newv);
}}}}}}return CYCLE_UNIT / 2 * 26;
}
/* NEGX.L (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_40b8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s32)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	put_long (srca,newv);
}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 24;
}
/* NEGX.L (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_40b9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s32)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	put_long (srca,newv);
}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 28;
}
/* MVSR2.W Dn */
unsigned long REGPARAM2 CPUFUNC(op_40c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs->s) { Exception (8, regs, 0); goto endlabel645; }
{{	MakeSR (regs);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((regs->sr) & 0xffff);
}}}	m68k_incpc (regs, 2);
endlabel645: ;
return CYCLE_UNIT / 2 * 4;
}
/* MVSR2.W (An) */
unsigned long REGPARAM2 CPUFUNC(op_40d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs->s) { Exception (8, regs, 0); goto endlabel646; }
{{	uaecptr srca = m68k_areg (regs, srcreg);
	MakeSR (regs);
	put_word (srca,regs->sr);
}}}	m68k_incpc (regs, 2);
endlabel646: ;
return CYCLE_UNIT / 2 * 8;
}
/* MVSR2.W (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_40d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs->s) { Exception (8, regs, 0); goto endlabel647; }
{{	uaecptr srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += 2;
	MakeSR (regs);
	put_word (srca,regs->sr);
}}}	m68k_incpc (regs, 2);
endlabel647: ;
return CYCLE_UNIT / 2 * 8;
}
/* MVSR2.W -(An) */
unsigned long REGPARAM2 CPUFUNC(op_40e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs->s) { Exception (8, regs, 0); goto endlabel648; }
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	m68k_areg (regs, srcreg) = srca;
	MakeSR (regs);
	put_word (srca,regs->sr);
}}}	m68k_incpc (regs, 2);
endlabel648: ;
return CYCLE_UNIT / 2 * 10;
}
/* MVSR2.W (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_40e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs->s) { Exception (8, regs, 0); goto endlabel649; }
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
	MakeSR (regs);
	put_word (srca,regs->sr);
}}}	m68k_incpc (regs, 4);
endlabel649: ;
return CYCLE_UNIT / 2 * 12;
}
/* MVSR2.W (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_40f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs->s) { Exception (8, regs, 0); goto endlabel650; }
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
	MakeSR (regs);
	put_word (srca,regs->sr);
}}}}endlabel650: ;
return CYCLE_UNIT / 2 * 14;
}
/* MVSR2.W (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_40f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel651; }
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
	MakeSR (regs);
	put_word (srca,regs->sr);
}}}	m68k_incpc (regs, 4);
endlabel651: ;
return CYCLE_UNIT / 2 * 12;
}
/* MVSR2.W (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_40f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel652; }
{{	uaecptr srca = get_ilong (regs, 2);
	MakeSR (regs);
	put_word (srca,regs->sr);
}}}	m68k_incpc (regs, 6);
endlabel652: ;
return CYCLE_UNIT / 2 * 16;
}
/* CHK.L Dn,Dn */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4100_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel653;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel653;
	}
}}}endlabel653: ;
return CYCLE_UNIT / 2 * 4;
}
#endif
/* CHK.L (An),Dn */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4110_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel654;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel654;
	}
}}}}endlabel654: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* CHK.L (An)+,Dn */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4118_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel655;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel655;
	}
}}}}endlabel655: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* CHK.L -(An),Dn */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4120_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel656;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel656;
	}
}}}}endlabel656: ;
return CYCLE_UNIT / 2 * 14;
}
#endif
/* CHK.L (d16,An),Dn */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4128_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 4);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel657;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel657;
	}
}}}}endlabel657: ;
return CYCLE_UNIT / 2 * 16;
}
#endif
/* CHK.L (d8,An,Xn),Dn */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4130_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel658;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel658;
	}
}}}}}endlabel658: ;
return CYCLE_UNIT / 2 * 18;
}
#endif
/* CHK.L (xxx).W,Dn */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4138_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 4);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel659;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel659;
	}
}}}}endlabel659: ;
return CYCLE_UNIT / 2 * 16;
}
#endif
/* CHK.L (xxx).L,Dn */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4139_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = get_ilong (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 6);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel660;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel660;
	}
}}}}endlabel660: ;
return CYCLE_UNIT / 2 * 20;
}
#endif
/* CHK.L (d16,PC),Dn */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_413a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 4);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel661;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel661;
	}
}}}}endlabel661: ;
return CYCLE_UNIT / 2 * 16;
}
#endif
/* CHK.L (d8,PC,Xn),Dn */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_413b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel662;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel662;
	}
}}}}}endlabel662: ;
return CYCLE_UNIT / 2 * 18;
}
#endif
/* CHK.L #<data>.L,Dn */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_413c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s32 src = get_ilong (regs, 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 6);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel663;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel663;
	}
}}}endlabel663: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* CHK.W Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_4180_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel664;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel664;
	}
}}}endlabel664: ;
return CYCLE_UNIT / 2 * 4;
}
/* CHK.W (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_4190_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel665;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel665;
	}
}}}}endlabel665: ;
return CYCLE_UNIT / 2 * 8;
}
/* CHK.W (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_4198_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel666;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel666;
	}
}}}}endlabel666: ;
return CYCLE_UNIT / 2 * 8;
}
/* CHK.W -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_41a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel667;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel667;
	}
}}}}endlabel667: ;
return CYCLE_UNIT / 2 * 10;
}
/* CHK.W (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_41a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 4);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel668;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel668;
	}
}}}}endlabel668: ;
return CYCLE_UNIT / 2 * 12;
}
/* CHK.W (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_41b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel669;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel669;
	}
}}}}}endlabel669: ;
return CYCLE_UNIT / 2 * 14;
}
/* CHK.W (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_41b8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 4);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel670;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel670;
	}
}}}}endlabel670: ;
return CYCLE_UNIT / 2 * 12;
}
/* CHK.W (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_41b9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 6);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel671;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel671;
	}
}}}}endlabel671: ;
return CYCLE_UNIT / 2 * 16;
}
/* CHK.W (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_41ba_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 4);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel672;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel672;
	}
}}}}endlabel672: ;
return CYCLE_UNIT / 2 * 12;
}
/* CHK.W (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_41bb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel673;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel673;
	}
}}}}}endlabel673: ;
return CYCLE_UNIT / 2 * 14;
}
/* CHK.W #<data>.W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_41bc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 src = get_iword (regs, 2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 4);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel674;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel674;
	}
}}}endlabel674: ;
return CYCLE_UNIT / 2 * 8;
}
/* LEA.L (An),An */
unsigned long REGPARAM2 CPUFUNC(op_41d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* LEA.L (d16,An),An */
unsigned long REGPARAM2 CPUFUNC(op_41e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* LEA.L (d8,An,Xn),An */
unsigned long REGPARAM2 CPUFUNC(op_41f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	m68k_areg (regs, dstreg) = (srca);
}}}}return CYCLE_UNIT / 2 * 8;
}
/* LEA.L (xxx).W,An */
unsigned long REGPARAM2 CPUFUNC(op_41f8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* LEA.L (xxx).L,An */
unsigned long REGPARAM2 CPUFUNC(op_41f9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* LEA.L (d16,PC),An */
unsigned long REGPARAM2 CPUFUNC(op_41fa_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* LEA.L (d8,PC,Xn),An */
unsigned long REGPARAM2 CPUFUNC(op_41fb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	m68k_areg (regs, dstreg) = (srca);
}}}}return CYCLE_UNIT / 2 * 8;
}
/* CLR.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_4200_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(0)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((0) & 0xff);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* CLR.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_4210_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(0)) < 0) ? 1 : 0);
	put_byte (srca,0);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* CLR.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_4218_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(0)) < 0) ? 1 : 0);
	put_byte (srca,0);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* CLR.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_4220_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(0)) < 0) ? 1 : 0);
	put_byte (srca,0);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* CLR.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_4228_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(0)) < 0) ? 1 : 0);
	put_byte (srca,0);
}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* CLR.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_4230_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(0)) < 0) ? 1 : 0);
	put_byte (srca,0);
}}}return CYCLE_UNIT / 2 * 14;
}
/* CLR.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_4238_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(0)) < 0) ? 1 : 0);
	put_byte (srca,0);
}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* CLR.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_4239_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(0)) < 0) ? 1 : 0);
	put_byte (srca,0);
}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* CLR.W Dn */
unsigned long REGPARAM2 CPUFUNC(op_4240_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(0)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((0) & 0xffff);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* CLR.W (An) */
unsigned long REGPARAM2 CPUFUNC(op_4250_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(0)) < 0) ? 1 : 0);
	put_word (srca,0);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* CLR.W (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_4258_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += 2;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(0)) < 0) ? 1 : 0);
	put_word (srca,0);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* CLR.W -(An) */
unsigned long REGPARAM2 CPUFUNC(op_4260_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	m68k_areg (regs, srcreg) = srca;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(0)) < 0) ? 1 : 0);
	put_word (srca,0);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* CLR.W (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_4268_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(0)) < 0) ? 1 : 0);
	put_word (srca,0);
}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* CLR.W (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_4270_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(0)) < 0) ? 1 : 0);
	put_word (srca,0);
}}}return CYCLE_UNIT / 2 * 14;
}
/* CLR.W (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_4278_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(0)) < 0) ? 1 : 0);
	put_word (srca,0);
}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* CLR.W (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_4279_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(0)) < 0) ? 1 : 0);
	put_word (srca,0);
}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* CLR.L Dn */
unsigned long REGPARAM2 CPUFUNC(op_4280_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(0)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (0);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* CLR.L (An) */
unsigned long REGPARAM2 CPUFUNC(op_4290_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(0)) < 0) ? 1 : 0);
	put_long (srca,0);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
#endif

#ifdef PART_4
/* CLR.L (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_4298_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += 4;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(0)) < 0) ? 1 : 0);
	put_long (srca,0);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* CLR.L -(An) */
unsigned long REGPARAM2 CPUFUNC(op_42a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	m68k_areg (regs, srcreg) = srca;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(0)) < 0) ? 1 : 0);
	put_long (srca,0);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* CLR.L (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_42a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(0)) < 0) ? 1 : 0);
	put_long (srca,0);
}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* CLR.L (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_42b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(0)) < 0) ? 1 : 0);
	put_long (srca,0);
}}}return CYCLE_UNIT / 2 * 18;
}
/* CLR.L (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_42b8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(0)) < 0) ? 1 : 0);
	put_long (srca,0);
}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* CLR.L (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_42b9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(0)) < 0) ? 1 : 0);
	put_long (srca,0);
}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* MVSR2.B Dn */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_42c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	MakeSR (regs);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((regs->sr & 0xff) & 0xffff);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
#endif
/* MVSR2.B (An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_42d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	MakeSR (regs);
	put_word (srca,regs->sr & 0xff);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
#endif
/* MVSR2.B (An)+ */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_42d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += 2;
	MakeSR (regs);
	put_word (srca,regs->sr & 0xff);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
#endif
/* MVSR2.B -(An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_42e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	m68k_areg (regs, srcreg) = srca;
	MakeSR (regs);
	put_word (srca,regs->sr & 0xff);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
#endif
/* MVSR2.B (d16,An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_42e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
	MakeSR (regs);
	put_word (srca,regs->sr & 0xff);
}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
#endif
/* MVSR2.B (d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_42f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
	MakeSR (regs);
	put_word (srca,regs->sr & 0xff);
}}}return CYCLE_UNIT / 2 * 14;
}
#endif
/* MVSR2.B (xxx).W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_42f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
	MakeSR (regs);
	put_word (srca,regs->sr & 0xff);
}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
#endif
/* MVSR2.B (xxx).L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_42f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
	MakeSR (regs);
	put_word (srca,regs->sr & 0xff);
}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
#endif
/* NEG.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_4400_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((dst) & 0xff);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* NEG.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_4410_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (srca,dst);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* NEG.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_4418_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (srca,dst);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* NEG.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_4420_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (srca,dst);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* NEG.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_4428_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (srca,dst);
}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* NEG.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_4430_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s8 src = get_byte (srca);
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (srca,dst);
}}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* NEG.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_4438_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (srca,dst);
}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* NEG.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_4439_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s8 src = get_byte (srca);
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (srca,dst);
}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* NEG.W Dn */
unsigned long REGPARAM2 CPUFUNC(op_4440_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* NEG.W (An) */
unsigned long REGPARAM2 CPUFUNC(op_4450_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (srca,dst);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* NEG.W (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_4458_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (srca,dst);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* NEG.W -(An) */
unsigned long REGPARAM2 CPUFUNC(op_4460_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (srca,dst);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* NEG.W (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_4468_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (srca,dst);
}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* NEG.W (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_4470_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (srca,dst);
}}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* NEG.W (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_4478_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (srca,dst);
}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* NEG.W (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_4479_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (srca,dst);
}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* NEG.L Dn */
unsigned long REGPARAM2 CPUFUNC(op_4480_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, srcreg) = (dst);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* NEG.L (An) */
unsigned long REGPARAM2 CPUFUNC(op_4490_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (srca,dst);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 20;
}
/* NEG.L (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_4498_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (srca,dst);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 20;
}
/* NEG.L -(An) */
unsigned long REGPARAM2 CPUFUNC(op_44a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (srca,dst);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 22;
}
/* NEG.L (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_44a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (srca,dst);
}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 24;
}
/* NEG.L (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_44b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (srca,dst);
}}}}}}}return CYCLE_UNIT / 2 * 26;
}
/* NEG.L (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_44b8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (srca,dst);
}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 24;
}
/* NEG.L (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_44b9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s32 src = get_long (srca);
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (srca,dst);
}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 28;
}
/* MV2SR.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_44c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	MakeSR (regs);
	regs->sr &= 0xFF00;
	regs->sr |= src & 0xFF;
	MakeFromSR (regs);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* MV2SR.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_44d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	MakeSR (regs);
	regs->sr &= 0xFF00;
	regs->sr |= src & 0xFF;
	MakeFromSR (regs);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* MV2SR.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_44d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	MakeSR (regs);
	regs->sr &= 0xFF00;
	regs->sr |= src & 0xFF;
	MakeFromSR (regs);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* MV2SR.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_44e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	MakeSR (regs);
	regs->sr &= 0xFF00;
	regs->sr |= src & 0xFF;
	MakeFromSR (regs);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* MV2SR.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_44e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
	MakeSR (regs);
	regs->sr &= 0xFF00;
	regs->sr |= src & 0xFF;
	MakeFromSR (regs);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* MV2SR.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_44f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
	MakeSR (regs);
	regs->sr &= 0xFF00;
	regs->sr |= src & 0xFF;
	MakeFromSR (regs);
}}}}return CYCLE_UNIT / 2 * 14;
}
/* MV2SR.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_44f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
	MakeSR (regs);
	regs->sr &= 0xFF00;
	regs->sr |= src & 0xFF;
	MakeFromSR (regs);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* MV2SR.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_44f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
	MakeSR (regs);
	regs->sr &= 0xFF00;
	regs->sr |= src & 0xFF;
	MakeFromSR (regs);
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* MV2SR.B (d16,PC) */
unsigned long REGPARAM2 CPUFUNC(op_44fa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
	MakeSR (regs);
	regs->sr &= 0xFF00;
	regs->sr |= src & 0xFF;
	MakeFromSR (regs);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* MV2SR.B (d8,PC,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_44fb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
	MakeSR (regs);
	regs->sr &= 0xFF00;
	regs->sr |= src & 0xFF;
	MakeFromSR (regs);
}}}}return CYCLE_UNIT / 2 * 14;
}
/* MV2SR.B #<data>.B */
unsigned long REGPARAM2 CPUFUNC(op_44fc_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
	MakeSR (regs);
	regs->sr &= 0xFF00;
	regs->sr |= src & 0xFF;
	MakeFromSR (regs);
}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* NOT.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_4600_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(dst)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((dst) & 0xff);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* NOT.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_4610_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(dst)) < 0) ? 1 : 0);
	put_byte (srca,dst);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* NOT.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_4618_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(dst)) < 0) ? 1 : 0);
	put_byte (srca,dst);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* NOT.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_4620_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(dst)) < 0) ? 1 : 0);
	put_byte (srca,dst);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* NOT.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_4628_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(dst)) < 0) ? 1 : 0);
	put_byte (srca,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* NOT.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_4630_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(dst)) < 0) ? 1 : 0);
	put_byte (srca,dst);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* NOT.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_4638_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(dst)) < 0) ? 1 : 0);
	put_byte (srca,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* NOT.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_4639_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(dst)) < 0) ? 1 : 0);
	put_byte (srca,dst);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* NOT.W Dn */
unsigned long REGPARAM2 CPUFUNC(op_4640_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(dst)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* NOT.W (An) */
unsigned long REGPARAM2 CPUFUNC(op_4650_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(dst)) < 0) ? 1 : 0);
	put_word (srca,dst);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* NOT.W (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_4658_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(dst)) < 0) ? 1 : 0);
	put_word (srca,dst);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* NOT.W -(An) */
unsigned long REGPARAM2 CPUFUNC(op_4660_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(dst)) < 0) ? 1 : 0);
	put_word (srca,dst);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* NOT.W (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_4668_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(dst)) < 0) ? 1 : 0);
	put_word (srca,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* NOT.W (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_4670_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(dst)) < 0) ? 1 : 0);
	put_word (srca,dst);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* NOT.W (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_4678_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(dst)) < 0) ? 1 : 0);
	put_word (srca,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* NOT.W (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_4679_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(dst)) < 0) ? 1 : 0);
	put_word (srca,dst);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* NOT.L Dn */
unsigned long REGPARAM2 CPUFUNC(op_4680_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(dst)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (dst);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* NOT.L (An) */
unsigned long REGPARAM2 CPUFUNC(op_4690_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(dst)) < 0) ? 1 : 0);
	put_long (srca,dst);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 20;
}
/* NOT.L (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_4698_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(dst)) < 0) ? 1 : 0);
	put_long (srca,dst);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 20;
}
/* NOT.L -(An) */
unsigned long REGPARAM2 CPUFUNC(op_46a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(dst)) < 0) ? 1 : 0);
	put_long (srca,dst);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 22;
}
/* NOT.L (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_46a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(dst)) < 0) ? 1 : 0);
	put_long (srca,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 24;
}
/* NOT.L (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_46b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(dst)) < 0) ? 1 : 0);
	put_long (srca,dst);
}}}}}return CYCLE_UNIT / 2 * 26;
}
/* NOT.L (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_46b8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(dst)) < 0) ? 1 : 0);
	put_long (srca,dst);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 24;
}
/* NOT.L (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_46b9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(dst)) < 0) ? 1 : 0);
	put_long (srca,dst);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 28;
}
/* MV2SR.W Dn */
unsigned long REGPARAM2 CPUFUNC(op_46c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs->s) { Exception (8, regs, 0); goto endlabel773; }
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	regs->sr = src;
	MakeFromSR (regs);
}}}	m68k_incpc (regs, 2);
endlabel773: ;
return CYCLE_UNIT / 2 * 4;
}
/* MV2SR.W (An) */
unsigned long REGPARAM2 CPUFUNC(op_46d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs->s) { Exception (8, regs, 0); goto endlabel774; }
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	regs->sr = src;
	MakeFromSR (regs);
}}}}	m68k_incpc (regs, 2);
endlabel774: ;
return CYCLE_UNIT / 2 * 8;
}
/* MV2SR.W (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_46d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs->s) { Exception (8, regs, 0); goto endlabel775; }
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	regs->sr = src;
	MakeFromSR (regs);
}}}}	m68k_incpc (regs, 2);
endlabel775: ;
return CYCLE_UNIT / 2 * 8;
}
/* MV2SR.W -(An) */
unsigned long REGPARAM2 CPUFUNC(op_46e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs->s) { Exception (8, regs, 0); goto endlabel776; }
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	regs->sr = src;
	MakeFromSR (regs);
}}}}	m68k_incpc (regs, 2);
endlabel776: ;
return CYCLE_UNIT / 2 * 10;
}
/* MV2SR.W (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_46e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs->s) { Exception (8, regs, 0); goto endlabel777; }
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
	regs->sr = src;
	MakeFromSR (regs);
}}}}	m68k_incpc (regs, 4);
endlabel777: ;
return CYCLE_UNIT / 2 * 12;
}
/* MV2SR.W (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_46f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs->s) { Exception (8, regs, 0); goto endlabel778; }
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
	regs->sr = src;
	MakeFromSR (regs);
}}}}}endlabel778: ;
return CYCLE_UNIT / 2 * 14;
}
/* MV2SR.W (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_46f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel779; }
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
	regs->sr = src;
	MakeFromSR (regs);
}}}}	m68k_incpc (regs, 4);
endlabel779: ;
return CYCLE_UNIT / 2 * 12;
}
/* MV2SR.W (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_46f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel780; }
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
	regs->sr = src;
	MakeFromSR (regs);
}}}}	m68k_incpc (regs, 6);
endlabel780: ;
return CYCLE_UNIT / 2 * 16;
}
/* MV2SR.W (d16,PC) */
unsigned long REGPARAM2 CPUFUNC(op_46fa_0)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel781; }
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
	regs->sr = src;
	MakeFromSR (regs);
}}}}	m68k_incpc (regs, 4);
endlabel781: ;
return CYCLE_UNIT / 2 * 12;
}
/* MV2SR.W (d8,PC,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_46fb_0)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel782; }
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
	regs->sr = src;
	MakeFromSR (regs);
}}}}}endlabel782: ;
return CYCLE_UNIT / 2 * 14;
}
/* MV2SR.W #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_46fc_0)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel783; }
{{	uae_s16 src = get_iword (regs, 2);
	regs->sr = src;
	MakeFromSR (regs);
}}}	m68k_incpc (regs, 4);
endlabel783: ;
return CYCLE_UNIT / 2 * 8;
}
/* NBCD.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_4800_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_u16 newv_lo = - (src & 0xF) - GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (&regs->ccrflags, cflg ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((newv) & 0xff);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* LINK.L An,#<data>.L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4808_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr olda;
	olda = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = olda;
{	uae_s32 src = m68k_areg (regs, srcreg);
	put_long (olda,src);
	m68k_areg (regs, srcreg) = (m68k_areg (regs, 7));
{	uae_s32 offs = get_ilong (regs, 2);
	m68k_areg (regs, 7) += offs;
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
#endif
/* NBCD.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_4810_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
{	uae_u16 newv_lo = - (src & 0xF) - GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (&regs->ccrflags, cflg ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte (srca,newv);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* NBCD.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_4818_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_u16 newv_lo = - (src & 0xF) - GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (&regs->ccrflags, cflg ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte (srca,newv);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* NBCD.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_4820_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_u16 newv_lo = - (src & 0xF) - GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (&regs->ccrflags, cflg ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte (srca,newv);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* NBCD.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_4828_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_u16 newv_lo = - (src & 0xF) - GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (&regs->ccrflags, cflg ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte (srca,newv);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* NBCD.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_4830_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uae_u16 newv_lo = - (src & 0xF) - GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (&regs->ccrflags, cflg ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte (srca,newv);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* NBCD.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_4838_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_u16 newv_lo = - (src & 0xF) - GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (&regs->ccrflags, cflg ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte (srca,newv);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* NBCD.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_4839_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_u16 newv_lo = - (src & 0xF) - GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (&regs->ccrflags, cflg ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte (srca,newv);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* SWAP.W Dn */
unsigned long REGPARAM2 CPUFUNC(op_4840_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_u32 dst = ((src >> 16)&0xFFFF) | ((src&0xFFFF)<<16);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(dst)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (dst);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* BKPT.L #<data> */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4848_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{	m68k_incpc (regs, 2);
	op_illg (opcode, regs);
}return CYCLE_UNIT / 2 * 4;
}
#endif
/* PEA.L (An) */
unsigned long REGPARAM2 CPUFUNC(op_4850_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	put_long (dsta,srca);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* PEA.L (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_4868_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	put_long (dsta,srca);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* PEA.L (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_4870_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	put_long (dsta,srca);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* PEA.L (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_4878_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	put_long (dsta,srca);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* PEA.L (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_4879_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	put_long (dsta,srca);
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* PEA.L (d16,PC) */
unsigned long REGPARAM2 CPUFUNC(op_487a_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	put_long (dsta,srca);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* PEA.L (d8,PC,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_487b_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	put_long (dsta,srca);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* EXT.W Dn */
unsigned long REGPARAM2 CPUFUNC(op_4880_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_u16 dst = (uae_s16)(uae_s8)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(dst)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* MVMLE.W #<data>.W,(An) */
unsigned long REGPARAM2 CPUFUNC(op_4890_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_iword (regs, 2);
{	uaecptr srca = m68k_areg (regs, dstreg);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_word (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { put_word (srca, m68k_areg (regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* MVMLE.W #<data>.W,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_48a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_iword (regs, 2);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) - 0;
{	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	while (amask) { srca -= 2; put_word (srca, m68k_areg (regs, movem_index2[amask])); amask = movem_next[amask]; }
	while (dmask) { srca -= 2; put_word (srca, m68k_dreg (regs, movem_index2[dmask])); dmask = movem_next[dmask]; }
	m68k_areg (regs, dstreg) = srca;
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 10;
}
/* MVMLE.W #<data>.W,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_48a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_iword (regs, 2);
{	uaecptr srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_word (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { put_word (srca, m68k_areg (regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* MVMLE.W #<data>.W,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_48b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_iword (regs, 2);
{	uaecptr srca;
	m68k_incpc (regs, 4);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_word (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { put_word (srca, m68k_areg (regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
}}}}return CYCLE_UNIT / 2 * 14;
}
/* MVMLE.W #<data>.W,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_48b8_0)(uae_u32 opcode, struct regstruct *regs)
{
{	uae_u16 mask = get_iword (regs, 2);
{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_word (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { put_word (srca, m68k_areg (regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* MVMLE.W #<data>.W,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_48b9_0)(uae_u32 opcode, struct regstruct *regs)
{
{	uae_u16 mask = get_iword (regs, 2);
{	uaecptr srca = get_ilong (regs, 4);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_word (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { put_word (srca, m68k_areg (regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 16;
}
/* EXT.L Dn */
unsigned long REGPARAM2 CPUFUNC(op_48c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_u32 dst = (uae_s32)(uae_s16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(dst)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (dst);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* MVMLE.L #<data>.W,(An) */
unsigned long REGPARAM2 CPUFUNC(op_48d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_iword (regs, 2);
{	uaecptr srca = m68k_areg (regs, dstreg);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_long (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { put_long (srca, m68k_areg (regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* MVMLE.L #<data>.W,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_48e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_iword (regs, 2);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) - 0;
{	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	while (amask) { srca -= 4; put_long (srca, m68k_areg (regs, movem_index2[amask])); amask = movem_next[amask]; }
	while (dmask) { srca -= 4; put_long (srca, m68k_dreg (regs, movem_index2[dmask])); dmask = movem_next[dmask]; }
	m68k_areg (regs, dstreg) = srca;
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 10;
}
/* MVMLE.L #<data>.W,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_48e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_iword (regs, 2);
{	uaecptr srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_long (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { put_long (srca, m68k_areg (regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* MVMLE.L #<data>.W,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_48f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_iword (regs, 2);
{	uaecptr srca;
	m68k_incpc (regs, 4);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_long (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { put_long (srca, m68k_areg (regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
}}}}return CYCLE_UNIT / 2 * 14;
}
/* MVMLE.L #<data>.W,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_48f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{	uae_u16 mask = get_iword (regs, 2);
{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_long (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { put_long (srca, m68k_areg (regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* MVMLE.L #<data>.W,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_48f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{	uae_u16 mask = get_iword (regs, 2);
{	uaecptr srca = get_ilong (regs, 4);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_long (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { put_long (srca, m68k_areg (regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 16;
}
/* EXT.B Dn */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_49c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_u32 dst = (uae_s32)(uae_s8)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(dst)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (dst);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
#endif
/* TST.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_4a00_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* TST.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_4a10_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* TST.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_4a18_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* TST.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_4a20_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* TST.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_4a28_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* TST.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_4a30_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s8 src = get_byte (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}}return CYCLE_UNIT / 2 * 14;
}
/* TST.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_4a38_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* TST.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_4a39_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s8 src = get_byte (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* TST.B (d16,PC) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4a3a_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
#endif
/* TST.B (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4a3b_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 src = get_byte (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}}return CYCLE_UNIT / 2 * 14;
}
#endif
/* TST.B #<data>.B */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4a3c_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = get_ibyte (regs, 2);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
#endif
/* TST.W Dn */
unsigned long REGPARAM2 CPUFUNC(op_4a40_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* TST.W An */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4a48_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_areg (regs, srcreg);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
#endif
/* TST.W (An) */
unsigned long REGPARAM2 CPUFUNC(op_4a50_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* TST.W (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_4a58_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* TST.W -(An) */
unsigned long REGPARAM2 CPUFUNC(op_4a60_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* TST.W (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_4a68_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* TST.W (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_4a70_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}return CYCLE_UNIT / 2 * 14;
}
/* TST.W (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_4a78_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* TST.W (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_4a79_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* TST.W (d16,PC) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4a7a_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
#endif
/* TST.W (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4a7b_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}return CYCLE_UNIT / 2 * 14;
}
#endif
/* TST.W #<data>.W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4a7c_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
#endif
/* TST.L Dn */
unsigned long REGPARAM2 CPUFUNC(op_4a80_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* TST.L An */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4a88_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_areg (regs, srcreg);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
#endif
/* TST.L (An) */
unsigned long REGPARAM2 CPUFUNC(op_4a90_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* TST.L (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_4a98_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* TST.L -(An) */
unsigned long REGPARAM2 CPUFUNC(op_4aa0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* TST.L (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_4aa8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* TST.L (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_4ab0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}return CYCLE_UNIT / 2 * 18;
}
/* TST.L (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_4ab8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* TST.L (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_4ab9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s32 src = get_long (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* TST.L (d16,PC) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4aba_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
#endif
/* TST.L (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4abb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s32 src = get_long (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}return CYCLE_UNIT / 2 * 18;
}
#endif
/* TST.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4abc_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
#endif
/* TAS.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_4ac0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	src |= 0x80;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((src) & 0xff);
}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* TAS.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_4ad0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	src |= 0x80;
	put_byte (srca,src);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* TAS.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_4ad8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	src |= 0x80;
	put_byte (srca,src);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* TAS.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_4ae0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	src |= 0x80;
	put_byte (srca,src);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* TAS.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_4ae8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	src |= 0x80;
	put_byte (srca,src);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* TAS.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_4af0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s8 src = get_byte (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	src |= 0x80;
	put_byte (srca,src);
}}}}return CYCLE_UNIT / 2 * 18;
}
/* TAS.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_4af8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	src |= 0x80;
	put_byte (srca,src);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* TAS.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_4af9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s8 src = get_byte (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	src |= 0x80;
	put_byte (srca,src);
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* MULL.L #<data>.W,Dn */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4c00_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_iword (regs, 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 4);
	m68k_mull(opcode, dst, extra);
}}}return CYCLE_UNIT / 2 * 8;
}
#endif
/* MULL.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4c10_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	m68k_incpc (regs, 4);
	m68k_mull(opcode, dst, extra);
}}}}return CYCLE_UNIT / 2 * 16;
}
#endif
/* MULL.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4c18_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	m68k_incpc (regs, 4);
	m68k_mull(opcode, dst, extra);
}}}}return CYCLE_UNIT / 2 * 16;
}
#endif
/* MULL.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4c20_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	m68k_incpc (regs, 4);
	m68k_mull(opcode, dst, extra);
}}}}return CYCLE_UNIT / 2 * 18;
}
#endif
/* MULL.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4c28_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s32 dst = get_long (dsta);
	m68k_incpc (regs, 6);
	m68k_mull(opcode, dst, extra);
}}}}return CYCLE_UNIT / 2 * 20;
}
#endif
/* MULL.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4c30_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta;
	m68k_incpc (regs, 4);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s32 dst = get_long (dsta);
	m68k_mull(opcode, dst, extra);
}}}}}return CYCLE_UNIT / 2 * 22;
}
#endif
/* MULL.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4c38_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s32 dst = get_long (dsta);
	m68k_incpc (regs, 6);
	m68k_mull(opcode, dst, extra);
}}}}return CYCLE_UNIT / 2 * 20;
}
#endif
/* MULL.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4c39_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta = get_ilong (regs, 4);
{	uae_s32 dst = get_long (dsta);
	m68k_incpc (regs, 8);
	m68k_mull(opcode, dst, extra);
}}}}return CYCLE_UNIT / 2 * 24;
}
#endif
/* MULL.L #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4c3a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 2;
{{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr dsta = m68k_getpc (regs) + 4;
	dsta += (uae_s32)(uae_s16)get_iword (regs, 4);
{	uae_s32 dst = get_long (dsta);
	m68k_incpc (regs, 6);
	m68k_mull(opcode, dst, extra);
}}}}return CYCLE_UNIT / 2 * 20;
}
#endif
/* MULL.L #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4c3b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 3;
{{	uae_s16 extra = get_iword (regs, 2);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpc (regs, 4);
{	tmppc = m68k_getpc (regs);
	dsta = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s32 dst = get_long (dsta);
	m68k_mull(opcode, dst, extra);
}}}}}return CYCLE_UNIT / 2 * 22;
}
#endif
/* MULL.L #<data>.W,#<data>.L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4c3c_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 extra = get_iword (regs, 2);
{	uae_s32 dst = get_ilong (regs, 4);
	m68k_incpc (regs, 8);
	m68k_mull(opcode, dst, extra);
}}}return CYCLE_UNIT / 2 * 16;
}
#endif
/* DIVL.L #<data>.W,Dn */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4c40_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	m68k_incpc (regs, 2);
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 0);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 2);
	m68k_divl(opcode, dst, extra, oldpc);
}}}}return CYCLE_UNIT / 2 * 8;
}
#endif
/* DIVL.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4c50_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	m68k_incpc (regs, 2);
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 0);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	m68k_incpc (regs, 2);
	m68k_divl(opcode, dst, extra, oldpc);
}}}}}return CYCLE_UNIT / 2 * 16;
}
#endif
/* DIVL.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4c58_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	m68k_incpc (regs, 2);
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 0);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	m68k_incpc (regs, 2);
	m68k_divl(opcode, dst, extra, oldpc);
}}}}}return CYCLE_UNIT / 2 * 16;
}
#endif
/* DIVL.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4c60_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	m68k_incpc (regs, 2);
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 0);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	m68k_incpc (regs, 2);
	m68k_divl(opcode, dst, extra, oldpc);
}}}}}return CYCLE_UNIT / 2 * 18;
}
#endif
/* DIVL.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4c68_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	m68k_incpc (regs, 2);
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 0);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 dst = get_long (dsta);
	m68k_incpc (regs, 4);
	m68k_divl(opcode, dst, extra, oldpc);
}}}}}return CYCLE_UNIT / 2 * 20;
}
#endif
/* DIVL.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4c70_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	m68k_incpc (regs, 2);
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 0);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s32 dst = get_long (dsta);
	m68k_divl(opcode, dst, extra, oldpc);
}}}}}}return CYCLE_UNIT / 2 * 22;
}
#endif
/* DIVL.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4c78_0)(uae_u32 opcode, struct regstruct *regs)
{
{	m68k_incpc (regs, 2);
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 0);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 dst = get_long (dsta);
	m68k_incpc (regs, 4);
	m68k_divl(opcode, dst, extra, oldpc);
}}}}}return CYCLE_UNIT / 2 * 20;
}
#endif
/* DIVL.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4c79_0)(uae_u32 opcode, struct regstruct *regs)
{
{	m68k_incpc (regs, 2);
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 0);
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s32 dst = get_long (dsta);
	m68k_incpc (regs, 6);
	m68k_divl(opcode, dst, extra, oldpc);
}}}}}return CYCLE_UNIT / 2 * 24;
}
#endif
/* DIVL.L #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4c7a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 2;
{	m68k_incpc (regs, 2);
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 0);
{	uaecptr dsta = m68k_getpc (regs) + 2;
	dsta += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 dst = get_long (dsta);
	m68k_incpc (regs, 4);
	m68k_divl(opcode, dst, extra, oldpc);
}}}}}return CYCLE_UNIT / 2 * 20;
}
#endif
/* DIVL.L #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4c7b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 3;
{	m68k_incpc (regs, 2);
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 0);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	dsta = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s32 dst = get_long (dsta);
	m68k_divl(opcode, dst, extra, oldpc);
}}}}}}return CYCLE_UNIT / 2 * 22;
}
#endif
/* DIVL.L #<data>.W,#<data>.L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4c7c_0)(uae_u32 opcode, struct regstruct *regs)
{
{	m68k_incpc (regs, 2);
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 extra = get_iword (regs, 0);
{	uae_s32 dst = get_ilong (regs, 2);
	m68k_incpc (regs, 6);
	m68k_divl(opcode, dst, extra, oldpc);
}}}}return CYCLE_UNIT / 2 * 16;
}
#endif
/* MVMEL.W #<data>.W,(An) */
unsigned long REGPARAM2 CPUFUNC(op_4c90_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_iword (regs, 2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = m68k_areg (regs, dstreg);
{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word (srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word (srca); srca += 2; amask = movem_next[amask]; }
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* MVMEL.W #<data>.W,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_4c98_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_iword (regs, 2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = m68k_areg (regs, dstreg);
{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word (srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word (srca); srca += 2; amask = movem_next[amask]; }
	m68k_areg (regs, dstreg) = srca;
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* MVMEL.W #<data>.W,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_4ca8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_iword (regs, 2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word (srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word (srca); srca += 2; amask = movem_next[amask]; }
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* MVMEL.W #<data>.W,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_4cb0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_iword (regs, 2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	m68k_incpc (regs, 4);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word (srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word (srca); srca += 2; amask = movem_next[amask]; }
}}}}return CYCLE_UNIT / 2 * 14;
}
/* MVMEL.W #<data>.W,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_4cb8_0)(uae_u32 opcode, struct regstruct *regs)
{
{	uae_u16 mask = get_iword (regs, 2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 4);
{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word (srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word (srca); srca += 2; amask = movem_next[amask]; }
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* MVMEL.W #<data>.W,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_4cb9_0)(uae_u32 opcode, struct regstruct *regs)
{
{	uae_u16 mask = get_iword (regs, 2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = get_ilong (regs, 4);
{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word (srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word (srca); srca += 2; amask = movem_next[amask]; }
}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 16;
}
/* MVMEL.W #<data>.W,(d16,PC) */
unsigned long REGPARAM2 CPUFUNC(op_4cba_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 2;
{	uae_u16 mask = get_iword (regs, 2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = m68k_getpc (regs) + 4;
	srca += (uae_s32)(uae_s16)get_iword (regs, 4);
{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word (srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word (srca); srca += 2; amask = movem_next[amask]; }
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* MVMEL.W #<data>.W,(d8,PC,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_4cbb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 3;
{	uae_u16 mask = get_iword (regs, 2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 4);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word (srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word (srca); srca += 2; amask = movem_next[amask]; }
}}}}return CYCLE_UNIT / 2 * 14;
}
/* MVMEL.L #<data>.W,(An) */
unsigned long REGPARAM2 CPUFUNC(op_4cd0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_iword (regs, 2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = m68k_areg (regs, dstreg);
{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = get_long (srca); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = get_long (srca); srca += 4; amask = movem_next[amask]; }
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* MVMEL.L #<data>.W,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_4cd8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_iword (regs, 2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = m68k_areg (regs, dstreg);
{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = get_long (srca); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = get_long (srca); srca += 4; amask = movem_next[amask]; }
	m68k_areg (regs, dstreg) = srca;
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* MVMEL.L #<data>.W,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_4ce8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_iword (regs, 2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 4);
{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = get_long (srca); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = get_long (srca); srca += 4; amask = movem_next[amask]; }
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* MVMEL.L #<data>.W,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_4cf0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_iword (regs, 2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	m68k_incpc (regs, 4);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = get_long (srca); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = get_long (srca); srca += 4; amask = movem_next[amask]; }
}}}}return CYCLE_UNIT / 2 * 14;
}
/* MVMEL.L #<data>.W,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_4cf8_0)(uae_u32 opcode, struct regstruct *regs)
{
{	uae_u16 mask = get_iword (regs, 2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 4);
{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = get_long (srca); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = get_long (srca); srca += 4; amask = movem_next[amask]; }
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* MVMEL.L #<data>.W,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_4cf9_0)(uae_u32 opcode, struct regstruct *regs)
{
{	uae_u16 mask = get_iword (regs, 2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = get_ilong (regs, 4);
{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = get_long (srca); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = get_long (srca); srca += 4; amask = movem_next[amask]; }
}}}	m68k_incpc (regs, 8);
return CYCLE_UNIT / 2 * 16;
}
/* MVMEL.L #<data>.W,(d16,PC) */
unsigned long REGPARAM2 CPUFUNC(op_4cfa_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 2;
{	uae_u16 mask = get_iword (regs, 2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = m68k_getpc (regs) + 4;
	srca += (uae_s32)(uae_s16)get_iword (regs, 4);
{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = get_long (srca); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = get_long (srca); srca += 4; amask = movem_next[amask]; }
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* MVMEL.L #<data>.W,(d8,PC,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_4cfb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 3;
{	uae_u16 mask = get_iword (regs, 2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 4);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = get_long (srca); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = get_long (srca); srca += 4; amask = movem_next[amask]; }
}}}}return CYCLE_UNIT / 2 * 14;
}
/* TRAP.L #<data> */
unsigned long REGPARAM2 CPUFUNC(op_4e40_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 15);
{{	uae_u32 src = srcreg;
	m68k_incpc (regs, 2);
	Exception (src + 32, regs, 0);
}}return CYCLE_UNIT / 2 * 4;
}
/* LINK.W An,#<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_4e50_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr olda;
	olda = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = olda;
{	uae_s32 src = m68k_areg (regs, srcreg);
	put_long (olda,src);
	m68k_areg (regs, srcreg) = (m68k_areg (regs, 7));
{	uae_s16 offs = get_iword (regs, 2);
	m68k_areg (regs, 7) += offs;
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* UNLK.L An */
unsigned long REGPARAM2 CPUFUNC(op_4e58_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_areg (regs, srcreg);
	m68k_areg (regs, 7) = src;
{	uaecptr olda = m68k_areg (regs, 7);
{	uae_s32 old = get_long (olda);
	m68k_areg (regs, 7) += 4;
	m68k_areg (regs, srcreg) = (old);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* MVR2USP.L An */
unsigned long REGPARAM2 CPUFUNC(op_4e60_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs->s) { Exception (8, regs, 0); goto endlabel901; }
{{	uae_s32 src = m68k_areg (regs, srcreg);
	regs->usp = src;
}}}	m68k_incpc (regs, 2);
endlabel901: ;
return CYCLE_UNIT / 2 * 4;
}
/* MVUSP2R.L An */
unsigned long REGPARAM2 CPUFUNC(op_4e68_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs->s) { Exception (8, regs, 0); goto endlabel902; }
{{	m68k_areg (regs, srcreg) = (regs->usp);
}}}	m68k_incpc (regs, 2);
endlabel902: ;
return CYCLE_UNIT / 2 * 4;
}
/* RESET.L  */
unsigned long REGPARAM2 CPUFUNC(op_4e70_0)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel903; }
{	cpureset();
}}	m68k_incpc (regs, 2);
endlabel903: ;
return CYCLE_UNIT / 2 * 4;
}
/* NOP.L  */
unsigned long REGPARAM2 CPUFUNC(op_4e71_0)(uae_u32 opcode, struct regstruct *regs)
{
{}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* STOP.L #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_4e72_0)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel905; }
{{	uae_s16 src = get_iword (regs, 2);
	regs->sr = src;
	MakeFromSR (regs);
	m68k_setstopped (regs, 1);
	m68k_incpc (regs, 4);
}}}endlabel905: ;
return CYCLE_UNIT / 2 * 8;
}
/* RTE.L  */
unsigned long REGPARAM2 CPUFUNC(op_4e73_0)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel906; }
{	uae_u16 newsr; uae_u32 newpc; for (;;) {
{	uaecptr sra = m68k_areg (regs, 7);
{	uae_s16 sr = get_word (sra);
	m68k_areg (regs, 7) += 2;
{	uaecptr pca = m68k_areg (regs, 7);
{	uae_s32 pc = get_long (pca);
	m68k_areg (regs, 7) += 4;
{	uaecptr formata = m68k_areg (regs, 7);
{	uae_s16 format = get_word (formata);
	m68k_areg (regs, 7) += 2;
	newsr = sr; newpc = pc;
	if ((format & 0xF000) == 0x0000) { break; }
	else if ((format & 0xF000) == 0x1000) { ; }
	else if ((format & 0xF000) == 0x2000) { m68k_areg (regs, 7) += 4; break; }
	else if ((format & 0xF000) == 0x8000) { m68k_areg (regs, 7) += 50; break; }
	else if ((format & 0xF000) == 0x7000) { m68k_areg (regs, 7) += 52; break; }
	else if ((format & 0xF000) == 0x9000) { m68k_areg (regs, 7) += 12; break; }
	else if ((format & 0xF000) == 0xa000) { m68k_areg (regs, 7) += 24; break; }
	else if ((format & 0xF000) == 0xb000) { m68k_areg (regs, 7) += 84; break; }
	else { Exception (14, regs, 0); goto endlabel906; }
	regs->sr = newsr; MakeFromSR (regs);
}
}}}}}}	regs->sr = newsr; MakeFromSR (regs);
	if (newpc & 1)
		exception3 (0x4e73, m68k_getpc (regs), newpc);
	else
		m68k_setpc (regs, newpc);
}}endlabel906: ;
return CYCLE_UNIT / 2 * 20;
}
/* RTD.L #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_4e74_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr pca = m68k_areg (regs, 7);
{	uae_s32 pc = get_long (pca);
	m68k_areg (regs, 7) += 4;
{	uae_s16 offs = get_iword (regs, 2);
	m68k_areg (regs, 7) += offs;
	if (pc & 1)
		exception3 (0x4e74, m68k_getpc (regs), pc);
	else
		m68k_setpc (regs, pc);
}}}}return CYCLE_UNIT / 2 * 16;
}
/* RTS.L  */
unsigned long REGPARAM2 CPUFUNC(op_4e75_0)(uae_u32 opcode, struct regstruct *regs)
{
{	m68k_do_rts (regs);
}return CYCLE_UNIT / 2 * 4;
}
/* TRAPV.L  */
unsigned long REGPARAM2 CPUFUNC(op_4e76_0)(uae_u32 opcode, struct regstruct *regs)
{
{	m68k_incpc (regs, 2);
	if (GET_VFLG (&regs->ccrflags)) {
		Exception (7, regs, m68k_getpc (regs));
		goto endlabel909;
	}
}endlabel909: ;
return CYCLE_UNIT / 2 * 4;
}
/* RTR.L  */
unsigned long REGPARAM2 CPUFUNC(op_4e77_0)(uae_u32 opcode, struct regstruct *regs)
{
{	MakeSR (regs);
{	uaecptr sra = m68k_areg (regs, 7);
{	uae_s16 sr = get_word (sra);
	m68k_areg (regs, 7) += 2;
{	uaecptr pca = m68k_areg (regs, 7);
{	uae_s32 pc = get_long (pca);
	m68k_areg (regs, 7) += 4;
	regs->sr &= 0xFF00; sr &= 0xFF;
	regs->sr |= sr; m68k_setpc (regs, pc);
	MakeFromSR (regs);
}}}}}return CYCLE_UNIT / 2 * 16;
}
/* MOVEC2.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4e7a_0)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel911; }
{{	uae_s16 src = get_iword (regs, 2);
{	int regno = (src >> 12) & 15;
	uae_u32 *regp = regs->regs + regno;
	if (! m68k_movec2(src & 0xFFF, regp)) goto endlabel911;
}}}}	m68k_incpc (regs, 4);
endlabel911: ;
return CYCLE_UNIT / 2 * 8;
}
#endif
/* MOVE2C.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_4e7b_0)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel912; }
{{	uae_s16 src = get_iword (regs, 2);
{	int regno = (src >> 12) & 15;
	uae_u32 *regp = regs->regs + regno;
	if (! m68k_move2c(src & 0xFFF, regp)) goto endlabel912;
}}}}	m68k_incpc (regs, 4);
endlabel912: ;
return CYCLE_UNIT / 2 * 8;
}
#endif
/* JSR.L (An) */
unsigned long REGPARAM2 CPUFUNC(op_4e90_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uaecptr oldpc = m68k_getpc (regs) + 2;
	if (srca & 1) {
		exception3i (opcode, oldpc, srca);
		goto endlabel913;
	}
	m68k_setpc (regs, srca);
	m68k_areg (regs, 7) -= 4;
	put_long (m68k_areg (regs, 7), oldpc);
}}}endlabel913: ;
return CYCLE_UNIT / 2 * 4;
}
/* JSR.L (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_4ea8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uaecptr oldpc = m68k_getpc (regs) + 4;
	if (srca & 1) {
		exception3i (opcode, oldpc, srca);
		goto endlabel914;
	}
	m68k_setpc (regs, srca);
	m68k_areg (regs, 7) -= 4;
	put_long (m68k_areg (regs, 7), oldpc);
}}}endlabel914: ;
return CYCLE_UNIT / 2 * 8;
}
/* JSR.L (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_4eb0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uaecptr oldpc = m68k_getpc (regs) + 0;
	if (srca & 1) {
		exception3i (opcode, oldpc, srca);
		goto endlabel915;
	}
	m68k_setpc (regs, srca);
	m68k_areg (regs, 7) -= 4;
	put_long (m68k_areg (regs, 7), oldpc);
}}}}endlabel915: ;
return CYCLE_UNIT / 2 * 8;
}
/* JSR.L (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_4eb8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uaecptr oldpc = m68k_getpc (regs) + 4;
	if (srca & 1) {
		exception3i (opcode, oldpc, srca);
		goto endlabel916;
	}
	m68k_setpc (regs, srca);
	m68k_areg (regs, 7) -= 4;
	put_long (m68k_areg (regs, 7), oldpc);
}}}endlabel916: ;
return CYCLE_UNIT / 2 * 8;
}
/* JSR.L (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_4eb9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{	uaecptr oldpc = m68k_getpc (regs) + 6;
	if (srca & 1) {
		exception3i (opcode, oldpc, srca);
		goto endlabel917;
	}
	m68k_setpc (regs, srca);
	m68k_areg (regs, 7) -= 4;
	put_long (m68k_areg (regs, 7), oldpc);
}}}endlabel917: ;
return CYCLE_UNIT / 2 * 12;
}
/* JSR.L (d16,PC) */
unsigned long REGPARAM2 CPUFUNC(op_4eba_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uaecptr oldpc = m68k_getpc (regs) + 4;
	if (srca & 1) {
		exception3i (opcode, oldpc, srca);
		goto endlabel918;
	}
	m68k_setpc (regs, srca);
	m68k_areg (regs, 7) -= 4;
	put_long (m68k_areg (regs, 7), oldpc);
}}}endlabel918: ;
return CYCLE_UNIT / 2 * 8;
}
/* JSR.L (d8,PC,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_4ebb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uaecptr oldpc = m68k_getpc (regs) + 0;
	if (srca & 1) {
		exception3i (opcode, oldpc, srca);
		goto endlabel919;
	}
	m68k_setpc (regs, srca);
	m68k_areg (regs, 7) -= 4;
	put_long (m68k_areg (regs, 7), oldpc);
}}}}endlabel919: ;
return CYCLE_UNIT / 2 * 8;
}
/* JMP.L (An) */
unsigned long REGPARAM2 CPUFUNC(op_4ed0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3i (opcode, m68k_getpc (regs) + 6, srca);
		goto endlabel920;
	}
	m68k_setpc (regs, srca);
}}endlabel920: ;
return CYCLE_UNIT / 2 * 4;
}
/* JMP.L (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_4ee8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
	if (srca & 1) {
		exception3i (opcode, m68k_getpc (regs) + 6, srca);
		goto endlabel921;
	}
	m68k_setpc (regs, srca);
}}endlabel921: ;
return CYCLE_UNIT / 2 * 8;
}
/* JMP.L (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_4ef0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
	if (srca & 1) {
		exception3i (opcode, m68k_getpc (regs) + 6, srca);
		goto endlabel922;
	}
	m68k_setpc (regs, srca);
}}}endlabel922: ;
return CYCLE_UNIT / 2 * 8;
}
/* JMP.L (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_4ef8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
	if (srca & 1) {
		exception3i (opcode, m68k_getpc (regs) + 6, srca);
		goto endlabel923;
	}
	m68k_setpc (regs, srca);
}}endlabel923: ;
return CYCLE_UNIT / 2 * 8;
}
/* JMP.L (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_4ef9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
	if (srca & 1) {
		exception3i (opcode, m68k_getpc (regs) + 6, srca);
		goto endlabel924;
	}
	m68k_setpc (regs, srca);
}}endlabel924: ;
return CYCLE_UNIT / 2 * 12;
}
/* JMP.L (d16,PC) */
unsigned long REGPARAM2 CPUFUNC(op_4efa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
	if (srca & 1) {
		exception3i (opcode, m68k_getpc (regs) + 6, srca);
		goto endlabel925;
	}
	m68k_setpc (regs, srca);
}}endlabel925: ;
return CYCLE_UNIT / 2 * 8;
}
/* JMP.L (d8,PC,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_4efb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
	if (srca & 1) {
		exception3i (opcode, m68k_getpc (regs) + 6, srca);
		goto endlabel926;
	}
	m68k_setpc (regs, srca);
}}}endlabel926: ;
return CYCLE_UNIT / 2 * 8;
}
/* ADD.B #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_5000_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ADD.B #<data>,(An) */
unsigned long REGPARAM2 CPUFUNC(op_5010_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* ADD.B #<data>,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_5018_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* ADD.B #<data>,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_5020_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* ADD.B #<data>,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_5028_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* ADD.B #<data>,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_5030_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* ADD.B #<data>,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_5038_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
#endif

#ifdef PART_5
/* ADD.B #<data>,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_5039_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* ADD.W #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_5040_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ADDA.W #<data>,An */
unsigned long REGPARAM2 CPUFUNC(op_5048_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ADD.W #<data>,(An) */
unsigned long REGPARAM2 CPUFUNC(op_5050_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* ADD.W #<data>,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_5058_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* ADD.W #<data>,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_5060_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* ADD.W #<data>,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_5068_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* ADD.W #<data>,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_5070_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* ADD.W #<data>,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_5078_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* ADD.W #<data>,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_5079_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* ADD.L #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_5080_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ADDA.L #<data>,An */
unsigned long REGPARAM2 CPUFUNC(op_5088_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ADD.L #<data>,(An) */
unsigned long REGPARAM2 CPUFUNC(op_5090_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 20;
}
/* ADD.L #<data>,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_5098_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 20;
}
/* ADD.L #<data>,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_50a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 22;
}
/* ADD.L #<data>,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_50a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 24;
}
/* ADD.L #<data>,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_50b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}}return CYCLE_UNIT / 2 * 26;
}
/* ADD.L #<data>,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_50b8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 24;
}
/* ADD.L #<data>,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_50b9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 28;
}
/* Scc.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_50c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{{{	int val = cctrue (&regs->ccrflags, 0) ? 0xff : 0;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* DBcc.W Dn,#<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_50c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_iword (regs, 2);
	uaecptr oldpc = m68k_getpc (regs);
	if (!cctrue (&regs->ccrflags, 0)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel954;
			}
			return CYCLE_UNIT / 2 * 12;
		}
	} else {
	}
	m68k_setpc (regs, oldpc + 4);
}}}endlabel954: ;
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_50d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{{	int val = cctrue (&regs->ccrflags, 0) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_50d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{{	int val = cctrue (&regs->ccrflags, 0) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_50e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{{	int val = cctrue (&regs->ccrflags, 0) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* Scc.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_50e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 0) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_50f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{{	int val = cctrue (&regs->ccrflags, 0) ? 0xff : 0;
	put_byte (srca,val);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* Scc.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_50f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 0) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_50f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 0) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* TRAPcc.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_50fa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 dummy = get_iword (regs, 2);
	if (cctrue (&regs->ccrflags, 0)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel962; }
}}	m68k_incpc (regs, 4);
endlabel962: ;
return CYCLE_UNIT / 2 * 8;
}
#endif
/* TRAPcc.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_50fb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 dummy = get_ilong (regs, 2);
	if (cctrue (&regs->ccrflags, 0)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel963; }
}}	m68k_incpc (regs, 6);
endlabel963: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* TRAPcc.L  */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_50fc_0)(uae_u32 opcode, struct regstruct *regs)
{
{	if (cctrue (&regs->ccrflags, 0)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel964; }
}	m68k_incpc (regs, 2);
endlabel964: ;
return CYCLE_UNIT / 2 * 4;
}
#endif
/* SUB.B #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_5100_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* SUB.B #<data>,(An) */
unsigned long REGPARAM2 CPUFUNC(op_5110_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* SUB.B #<data>,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_5118_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* SUB.B #<data>,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_5120_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* SUB.B #<data>,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_5128_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* SUB.B #<data>,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_5130_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* SUB.B #<data>,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_5138_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* SUB.B #<data>,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_5139_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* SUB.W #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_5140_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* SUBA.W #<data>,An */
unsigned long REGPARAM2 CPUFUNC(op_5148_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* SUB.W #<data>,(An) */
unsigned long REGPARAM2 CPUFUNC(op_5150_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* SUB.W #<data>,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_5158_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* SUB.W #<data>,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_5160_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* SUB.W #<data>,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_5168_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* SUB.W #<data>,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_5170_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* SUB.W #<data>,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_5178_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* SUB.W #<data>,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_5179_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* SUB.L #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_5180_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* SUBA.L #<data>,An */
unsigned long REGPARAM2 CPUFUNC(op_5188_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* SUB.L #<data>,(An) */
unsigned long REGPARAM2 CPUFUNC(op_5190_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 20;
}
/* SUB.L #<data>,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_5198_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 20;
}
/* SUB.L #<data>,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_51a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 22;
}
/* SUB.L #<data>,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_51a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 24;
}
/* SUB.L #<data>,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_51b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}}return CYCLE_UNIT / 2 * 26;
}
/* SUB.L #<data>,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_51b8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 24;
}
/* SUB.L #<data>,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_51b9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 28;
}
/* Scc.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_51c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{{{	int val = cctrue (&regs->ccrflags, 1) ? 0xff : 0;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* DBcc.W Dn,#<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_51c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_iword (regs, 2);
	uaecptr oldpc = m68k_getpc (regs);
	if (!cctrue (&regs->ccrflags, 1)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel992;
			}
			return CYCLE_UNIT / 2 * 12;
		}
	} else {
	}
	m68k_setpc (regs, oldpc + 4);
}}}endlabel992: ;
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_51d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{{	int val = cctrue (&regs->ccrflags, 1) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_51d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{{	int val = cctrue (&regs->ccrflags, 1) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_51e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{{	int val = cctrue (&regs->ccrflags, 1) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* Scc.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_51e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 1) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_51f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{{	int val = cctrue (&regs->ccrflags, 1) ? 0xff : 0;
	put_byte (srca,val);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* Scc.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_51f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 1) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_51f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 1) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* TRAPcc.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_51fa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 dummy = get_iword (regs, 2);
	if (cctrue (&regs->ccrflags, 1)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1000; }
}}	m68k_incpc (regs, 4);
endlabel1000: ;
return CYCLE_UNIT / 2 * 8;
}
#endif
/* TRAPcc.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_51fb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 dummy = get_ilong (regs, 2);
	if (cctrue (&regs->ccrflags, 1)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1001; }
}}	m68k_incpc (regs, 6);
endlabel1001: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* TRAPcc.L  */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_51fc_0)(uae_u32 opcode, struct regstruct *regs)
{
{	if (cctrue (&regs->ccrflags, 1)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1002; }
}	m68k_incpc (regs, 2);
endlabel1002: ;
return CYCLE_UNIT / 2 * 4;
}
#endif
/* Scc.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_52c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{{{	int val = cctrue (&regs->ccrflags, 2) ? 0xff : 0;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* DBcc.W Dn,#<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_52c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_iword (regs, 2);
	uaecptr oldpc = m68k_getpc (regs);
	if (!cctrue (&regs->ccrflags, 2)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel1004;
			}
			return CYCLE_UNIT / 2 * 12;
		}
	} else {
	}
	m68k_setpc (regs, oldpc + 4);
}}}endlabel1004: ;
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_52d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{{	int val = cctrue (&regs->ccrflags, 2) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_52d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{{	int val = cctrue (&regs->ccrflags, 2) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_52e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{{	int val = cctrue (&regs->ccrflags, 2) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* Scc.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_52e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 2) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_52f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{{	int val = cctrue (&regs->ccrflags, 2) ? 0xff : 0;
	put_byte (srca,val);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* Scc.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_52f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 2) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_52f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 2) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* TRAPcc.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_52fa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 dummy = get_iword (regs, 2);
	if (cctrue (&regs->ccrflags, 2)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1012; }
}}	m68k_incpc (regs, 4);
endlabel1012: ;
return CYCLE_UNIT / 2 * 8;
}
#endif
/* TRAPcc.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_52fb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 dummy = get_ilong (regs, 2);
	if (cctrue (&regs->ccrflags, 2)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1013; }
}}	m68k_incpc (regs, 6);
endlabel1013: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* TRAPcc.L  */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_52fc_0)(uae_u32 opcode, struct regstruct *regs)
{
{	if (cctrue (&regs->ccrflags, 2)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1014; }
}	m68k_incpc (regs, 2);
endlabel1014: ;
return CYCLE_UNIT / 2 * 4;
}
#endif
/* Scc.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_53c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{{{	int val = cctrue (&regs->ccrflags, 3) ? 0xff : 0;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* DBcc.W Dn,#<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_53c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_iword (regs, 2);
	uaecptr oldpc = m68k_getpc (regs);
	if (!cctrue (&regs->ccrflags, 3)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel1016;
			}
			return CYCLE_UNIT / 2 * 12;
		}
	} else {
	}
	m68k_setpc (regs, oldpc + 4);
}}}endlabel1016: ;
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_53d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{{	int val = cctrue (&regs->ccrflags, 3) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_53d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{{	int val = cctrue (&regs->ccrflags, 3) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_53e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{{	int val = cctrue (&regs->ccrflags, 3) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* Scc.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_53e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 3) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_53f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{{	int val = cctrue (&regs->ccrflags, 3) ? 0xff : 0;
	put_byte (srca,val);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* Scc.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_53f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 3) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_53f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 3) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* TRAPcc.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_53fa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 dummy = get_iword (regs, 2);
	if (cctrue (&regs->ccrflags, 3)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1024; }
}}	m68k_incpc (regs, 4);
endlabel1024: ;
return CYCLE_UNIT / 2 * 8;
}
#endif
/* TRAPcc.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_53fb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 dummy = get_ilong (regs, 2);
	if (cctrue (&regs->ccrflags, 3)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1025; }
}}	m68k_incpc (regs, 6);
endlabel1025: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* TRAPcc.L  */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_53fc_0)(uae_u32 opcode, struct regstruct *regs)
{
{	if (cctrue (&regs->ccrflags, 3)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1026; }
}	m68k_incpc (regs, 2);
endlabel1026: ;
return CYCLE_UNIT / 2 * 4;
}
#endif
/* Scc.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_54c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{{{	int val = cctrue (&regs->ccrflags, 4) ? 0xff : 0;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* DBcc.W Dn,#<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_54c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_iword (regs, 2);
	uaecptr oldpc = m68k_getpc (regs);
	if (!cctrue (&regs->ccrflags, 4)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel1028;
			}
			return CYCLE_UNIT / 2 * 12;
		}
	} else {
	}
	m68k_setpc (regs, oldpc + 4);
}}}endlabel1028: ;
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_54d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{{	int val = cctrue (&regs->ccrflags, 4) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_54d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{{	int val = cctrue (&regs->ccrflags, 4) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_54e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{{	int val = cctrue (&regs->ccrflags, 4) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* Scc.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_54e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 4) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_54f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{{	int val = cctrue (&regs->ccrflags, 4) ? 0xff : 0;
	put_byte (srca,val);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* Scc.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_54f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 4) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_54f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 4) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* TRAPcc.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_54fa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 dummy = get_iword (regs, 2);
	if (cctrue (&regs->ccrflags, 4)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1036; }
}}	m68k_incpc (regs, 4);
endlabel1036: ;
return CYCLE_UNIT / 2 * 8;
}
#endif
/* TRAPcc.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_54fb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 dummy = get_ilong (regs, 2);
	if (cctrue (&regs->ccrflags, 4)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1037; }
}}	m68k_incpc (regs, 6);
endlabel1037: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* TRAPcc.L  */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_54fc_0)(uae_u32 opcode, struct regstruct *regs)
{
{	if (cctrue (&regs->ccrflags, 4)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1038; }
}	m68k_incpc (regs, 2);
endlabel1038: ;
return CYCLE_UNIT / 2 * 4;
}
#endif
/* Scc.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_55c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{{{	int val = cctrue (&regs->ccrflags, 5) ? 0xff : 0;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* DBcc.W Dn,#<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_55c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_iword (regs, 2);
	uaecptr oldpc = m68k_getpc (regs);
	if (!cctrue (&regs->ccrflags, 5)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel1040;
			}
			return CYCLE_UNIT / 2 * 12;
		}
	} else {
	}
	m68k_setpc (regs, oldpc + 4);
}}}endlabel1040: ;
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_55d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{{	int val = cctrue (&regs->ccrflags, 5) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_55d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{{	int val = cctrue (&regs->ccrflags, 5) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_55e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{{	int val = cctrue (&regs->ccrflags, 5) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* Scc.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_55e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 5) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_55f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{{	int val = cctrue (&regs->ccrflags, 5) ? 0xff : 0;
	put_byte (srca,val);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* Scc.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_55f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 5) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_55f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 5) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* TRAPcc.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_55fa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 dummy = get_iword (regs, 2);
	if (cctrue (&regs->ccrflags, 5)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1048; }
}}	m68k_incpc (regs, 4);
endlabel1048: ;
return CYCLE_UNIT / 2 * 8;
}
#endif
/* TRAPcc.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_55fb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 dummy = get_ilong (regs, 2);
	if (cctrue (&regs->ccrflags, 5)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1049; }
}}	m68k_incpc (regs, 6);
endlabel1049: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* TRAPcc.L  */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_55fc_0)(uae_u32 opcode, struct regstruct *regs)
{
{	if (cctrue (&regs->ccrflags, 5)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1050; }
}	m68k_incpc (regs, 2);
endlabel1050: ;
return CYCLE_UNIT / 2 * 4;
}
#endif
/* Scc.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_56c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{{{	int val = cctrue (&regs->ccrflags, 6) ? 0xff : 0;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* DBcc.W Dn,#<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_56c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_iword (regs, 2);
	uaecptr oldpc = m68k_getpc (regs);
	if (!cctrue (&regs->ccrflags, 6)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel1052;
			}
			return CYCLE_UNIT / 2 * 12;
		}
	} else {
	}
	m68k_setpc (regs, oldpc + 4);
}}}endlabel1052: ;
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_56d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{{	int val = cctrue (&regs->ccrflags, 6) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_56d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{{	int val = cctrue (&regs->ccrflags, 6) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_56e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{{	int val = cctrue (&regs->ccrflags, 6) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* Scc.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_56e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 6) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_56f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{{	int val = cctrue (&regs->ccrflags, 6) ? 0xff : 0;
	put_byte (srca,val);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* Scc.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_56f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 6) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_56f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 6) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* TRAPcc.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_56fa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 dummy = get_iword (regs, 2);
	if (cctrue (&regs->ccrflags, 6)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1060; }
}}	m68k_incpc (regs, 4);
endlabel1060: ;
return CYCLE_UNIT / 2 * 8;
}
#endif
/* TRAPcc.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_56fb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 dummy = get_ilong (regs, 2);
	if (cctrue (&regs->ccrflags, 6)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1061; }
}}	m68k_incpc (regs, 6);
endlabel1061: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* TRAPcc.L  */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_56fc_0)(uae_u32 opcode, struct regstruct *regs)
{
{	if (cctrue (&regs->ccrflags, 6)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1062; }
}	m68k_incpc (regs, 2);
endlabel1062: ;
return CYCLE_UNIT / 2 * 4;
}
#endif
/* Scc.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_57c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{{{	int val = cctrue (&regs->ccrflags, 7) ? 0xff : 0;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* DBcc.W Dn,#<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_57c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_iword (regs, 2);
	uaecptr oldpc = m68k_getpc (regs);
	if (!cctrue (&regs->ccrflags, 7)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel1064;
			}
			return CYCLE_UNIT / 2 * 12;
		}
	} else {
	}
	m68k_setpc (regs, oldpc + 4);
}}}endlabel1064: ;
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_57d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{{	int val = cctrue (&regs->ccrflags, 7) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_57d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{{	int val = cctrue (&regs->ccrflags, 7) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_57e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{{	int val = cctrue (&regs->ccrflags, 7) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* Scc.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_57e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 7) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_57f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{{	int val = cctrue (&regs->ccrflags, 7) ? 0xff : 0;
	put_byte (srca,val);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* Scc.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_57f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 7) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_57f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 7) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* TRAPcc.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_57fa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 dummy = get_iword (regs, 2);
	if (cctrue (&regs->ccrflags, 7)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1072; }
}}	m68k_incpc (regs, 4);
endlabel1072: ;
return CYCLE_UNIT / 2 * 8;
}
#endif
/* TRAPcc.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_57fb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 dummy = get_ilong (regs, 2);
	if (cctrue (&regs->ccrflags, 7)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1073; }
}}	m68k_incpc (regs, 6);
endlabel1073: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* TRAPcc.L  */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_57fc_0)(uae_u32 opcode, struct regstruct *regs)
{
{	if (cctrue (&regs->ccrflags, 7)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1074; }
}	m68k_incpc (regs, 2);
endlabel1074: ;
return CYCLE_UNIT / 2 * 4;
}
#endif
/* Scc.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_58c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{{{	int val = cctrue (&regs->ccrflags, 8) ? 0xff : 0;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* DBcc.W Dn,#<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_58c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_iword (regs, 2);
	uaecptr oldpc = m68k_getpc (regs);
	if (!cctrue (&regs->ccrflags, 8)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel1076;
			}
			return CYCLE_UNIT / 2 * 12;
		}
	} else {
	}
	m68k_setpc (regs, oldpc + 4);
}}}endlabel1076: ;
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_58d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{{	int val = cctrue (&regs->ccrflags, 8) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_58d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{{	int val = cctrue (&regs->ccrflags, 8) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_58e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{{	int val = cctrue (&regs->ccrflags, 8) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* Scc.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_58e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 8) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_58f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{{	int val = cctrue (&regs->ccrflags, 8) ? 0xff : 0;
	put_byte (srca,val);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* Scc.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_58f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 8) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_58f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 8) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* TRAPcc.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_58fa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 dummy = get_iword (regs, 2);
	if (cctrue (&regs->ccrflags, 8)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1084; }
}}	m68k_incpc (regs, 4);
endlabel1084: ;
return CYCLE_UNIT / 2 * 8;
}
#endif
/* TRAPcc.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_58fb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 dummy = get_ilong (regs, 2);
	if (cctrue (&regs->ccrflags, 8)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1085; }
}}	m68k_incpc (regs, 6);
endlabel1085: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* TRAPcc.L  */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_58fc_0)(uae_u32 opcode, struct regstruct *regs)
{
{	if (cctrue (&regs->ccrflags, 8)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1086; }
}	m68k_incpc (regs, 2);
endlabel1086: ;
return CYCLE_UNIT / 2 * 4;
}
#endif
/* Scc.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_59c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{{{	int val = cctrue (&regs->ccrflags, 9) ? 0xff : 0;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* DBcc.W Dn,#<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_59c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_iword (regs, 2);
	uaecptr oldpc = m68k_getpc (regs);
	if (!cctrue (&regs->ccrflags, 9)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel1088;
			}
			return CYCLE_UNIT / 2 * 12;
		}
	} else {
	}
	m68k_setpc (regs, oldpc + 4);
}}}endlabel1088: ;
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_59d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{{	int val = cctrue (&regs->ccrflags, 9) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_59d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{{	int val = cctrue (&regs->ccrflags, 9) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_59e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{{	int val = cctrue (&regs->ccrflags, 9) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* Scc.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_59e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 9) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_59f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{{	int val = cctrue (&regs->ccrflags, 9) ? 0xff : 0;
	put_byte (srca,val);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* Scc.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_59f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 9) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_59f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 9) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* TRAPcc.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_59fa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 dummy = get_iword (regs, 2);
	if (cctrue (&regs->ccrflags, 9)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1096; }
}}	m68k_incpc (regs, 4);
endlabel1096: ;
return CYCLE_UNIT / 2 * 8;
}
#endif
/* TRAPcc.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_59fb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 dummy = get_ilong (regs, 2);
	if (cctrue (&regs->ccrflags, 9)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1097; }
}}	m68k_incpc (regs, 6);
endlabel1097: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* TRAPcc.L  */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_59fc_0)(uae_u32 opcode, struct regstruct *regs)
{
{	if (cctrue (&regs->ccrflags, 9)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1098; }
}	m68k_incpc (regs, 2);
endlabel1098: ;
return CYCLE_UNIT / 2 * 4;
}
#endif
/* Scc.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_5ac0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{{{	int val = cctrue (&regs->ccrflags, 10) ? 0xff : 0;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* DBcc.W Dn,#<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_5ac8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_iword (regs, 2);
	uaecptr oldpc = m68k_getpc (regs);
	if (!cctrue (&regs->ccrflags, 10)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel1100;
			}
			return CYCLE_UNIT / 2 * 12;
		}
	} else {
	}
	m68k_setpc (regs, oldpc + 4);
}}}endlabel1100: ;
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_5ad0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{{	int val = cctrue (&regs->ccrflags, 10) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_5ad8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{{	int val = cctrue (&regs->ccrflags, 10) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_5ae0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{{	int val = cctrue (&regs->ccrflags, 10) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* Scc.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_5ae8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 10) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_5af0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{{	int val = cctrue (&regs->ccrflags, 10) ? 0xff : 0;
	put_byte (srca,val);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* Scc.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_5af8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 10) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_5af9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 10) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* TRAPcc.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_5afa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 dummy = get_iword (regs, 2);
	if (cctrue (&regs->ccrflags, 10)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1108; }
}}	m68k_incpc (regs, 4);
endlabel1108: ;
return CYCLE_UNIT / 2 * 8;
}
#endif
/* TRAPcc.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_5afb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 dummy = get_ilong (regs, 2);
	if (cctrue (&regs->ccrflags, 10)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1109; }
}}	m68k_incpc (regs, 6);
endlabel1109: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* TRAPcc.L  */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_5afc_0)(uae_u32 opcode, struct regstruct *regs)
{
{	if (cctrue (&regs->ccrflags, 10)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1110; }
}	m68k_incpc (regs, 2);
endlabel1110: ;
return CYCLE_UNIT / 2 * 4;
}
#endif
/* Scc.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_5bc0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{{{	int val = cctrue (&regs->ccrflags, 11) ? 0xff : 0;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* DBcc.W Dn,#<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_5bc8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_iword (regs, 2);
	uaecptr oldpc = m68k_getpc (regs);
	if (!cctrue (&regs->ccrflags, 11)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel1112;
			}
			return CYCLE_UNIT / 2 * 12;
		}
	} else {
	}
	m68k_setpc (regs, oldpc + 4);
}}}endlabel1112: ;
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_5bd0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{{	int val = cctrue (&regs->ccrflags, 11) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_5bd8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{{	int val = cctrue (&regs->ccrflags, 11) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_5be0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{{	int val = cctrue (&regs->ccrflags, 11) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* Scc.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_5be8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 11) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_5bf0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{{	int val = cctrue (&regs->ccrflags, 11) ? 0xff : 0;
	put_byte (srca,val);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* Scc.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_5bf8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 11) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_5bf9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 11) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* TRAPcc.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_5bfa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 dummy = get_iword (regs, 2);
	if (cctrue (&regs->ccrflags, 11)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1120; }
}}	m68k_incpc (regs, 4);
endlabel1120: ;
return CYCLE_UNIT / 2 * 8;
}
#endif
/* TRAPcc.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_5bfb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 dummy = get_ilong (regs, 2);
	if (cctrue (&regs->ccrflags, 11)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1121; }
}}	m68k_incpc (regs, 6);
endlabel1121: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* TRAPcc.L  */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_5bfc_0)(uae_u32 opcode, struct regstruct *regs)
{
{	if (cctrue (&regs->ccrflags, 11)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1122; }
}	m68k_incpc (regs, 2);
endlabel1122: ;
return CYCLE_UNIT / 2 * 4;
}
#endif
/* Scc.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_5cc0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{{{	int val = cctrue (&regs->ccrflags, 12) ? 0xff : 0;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* DBcc.W Dn,#<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_5cc8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_iword (regs, 2);
	uaecptr oldpc = m68k_getpc (regs);
	if (!cctrue (&regs->ccrflags, 12)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel1124;
			}
			return CYCLE_UNIT / 2 * 12;
		}
	} else {
	}
	m68k_setpc (regs, oldpc + 4);
}}}endlabel1124: ;
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_5cd0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{{	int val = cctrue (&regs->ccrflags, 12) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_5cd8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{{	int val = cctrue (&regs->ccrflags, 12) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_5ce0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{{	int val = cctrue (&regs->ccrflags, 12) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* Scc.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_5ce8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 12) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_5cf0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{{	int val = cctrue (&regs->ccrflags, 12) ? 0xff : 0;
	put_byte (srca,val);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* Scc.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_5cf8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 12) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_5cf9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 12) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* TRAPcc.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_5cfa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 dummy = get_iword (regs, 2);
	if (cctrue (&regs->ccrflags, 12)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1132; }
}}	m68k_incpc (regs, 4);
endlabel1132: ;
return CYCLE_UNIT / 2 * 8;
}
#endif
/* TRAPcc.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_5cfb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 dummy = get_ilong (regs, 2);
	if (cctrue (&regs->ccrflags, 12)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1133; }
}}	m68k_incpc (regs, 6);
endlabel1133: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* TRAPcc.L  */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_5cfc_0)(uae_u32 opcode, struct regstruct *regs)
{
{	if (cctrue (&regs->ccrflags, 12)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1134; }
}	m68k_incpc (regs, 2);
endlabel1134: ;
return CYCLE_UNIT / 2 * 4;
}
#endif
/* Scc.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_5dc0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{{{	int val = cctrue (&regs->ccrflags, 13) ? 0xff : 0;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* DBcc.W Dn,#<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_5dc8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_iword (regs, 2);
	uaecptr oldpc = m68k_getpc (regs);
	if (!cctrue (&regs->ccrflags, 13)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel1136;
			}
			return CYCLE_UNIT / 2 * 12;
		}
	} else {
	}
	m68k_setpc (regs, oldpc + 4);
}}}endlabel1136: ;
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_5dd0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{{	int val = cctrue (&regs->ccrflags, 13) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_5dd8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{{	int val = cctrue (&regs->ccrflags, 13) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_5de0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{{	int val = cctrue (&regs->ccrflags, 13) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* Scc.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_5de8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 13) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_5df0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{{	int val = cctrue (&regs->ccrflags, 13) ? 0xff : 0;
	put_byte (srca,val);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* Scc.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_5df8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 13) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_5df9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 13) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* TRAPcc.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_5dfa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 dummy = get_iword (regs, 2);
	if (cctrue (&regs->ccrflags, 13)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1144; }
}}	m68k_incpc (regs, 4);
endlabel1144: ;
return CYCLE_UNIT / 2 * 8;
}
#endif
/* TRAPcc.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_5dfb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 dummy = get_ilong (regs, 2);
	if (cctrue (&regs->ccrflags, 13)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1145; }
}}	m68k_incpc (regs, 6);
endlabel1145: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* TRAPcc.L  */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_5dfc_0)(uae_u32 opcode, struct regstruct *regs)
{
{	if (cctrue (&regs->ccrflags, 13)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1146; }
}	m68k_incpc (regs, 2);
endlabel1146: ;
return CYCLE_UNIT / 2 * 4;
}
#endif
/* Scc.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_5ec0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{{{	int val = cctrue (&regs->ccrflags, 14) ? 0xff : 0;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* DBcc.W Dn,#<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_5ec8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_iword (regs, 2);
	uaecptr oldpc = m68k_getpc (regs);
	if (!cctrue (&regs->ccrflags, 14)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel1148;
			}
			return CYCLE_UNIT / 2 * 12;
		}
	} else {
	}
	m68k_setpc (regs, oldpc + 4);
}}}endlabel1148: ;
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_5ed0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{{	int val = cctrue (&regs->ccrflags, 14) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_5ed8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{{	int val = cctrue (&regs->ccrflags, 14) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_5ee0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{{	int val = cctrue (&regs->ccrflags, 14) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* Scc.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_5ee8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 14) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_5ef0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{{	int val = cctrue (&regs->ccrflags, 14) ? 0xff : 0;
	put_byte (srca,val);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* Scc.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_5ef8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 14) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_5ef9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 14) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* TRAPcc.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_5efa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 dummy = get_iword (regs, 2);
	if (cctrue (&regs->ccrflags, 14)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1156; }
}}	m68k_incpc (regs, 4);
endlabel1156: ;
return CYCLE_UNIT / 2 * 8;
}
#endif
/* TRAPcc.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_5efb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 dummy = get_ilong (regs, 2);
	if (cctrue (&regs->ccrflags, 14)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1157; }
}}	m68k_incpc (regs, 6);
endlabel1157: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* TRAPcc.L  */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_5efc_0)(uae_u32 opcode, struct regstruct *regs)
{
{	if (cctrue (&regs->ccrflags, 14)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1158; }
}	m68k_incpc (regs, 2);
endlabel1158: ;
return CYCLE_UNIT / 2 * 4;
}
#endif
/* Scc.B Dn */
unsigned long REGPARAM2 CPUFUNC(op_5fc0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{{{	int val = cctrue (&regs->ccrflags, 15) ? 0xff : 0;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* DBcc.W Dn,#<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_5fc8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_iword (regs, 2);
	uaecptr oldpc = m68k_getpc (regs);
	if (!cctrue (&regs->ccrflags, 15)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel1160;
			}
			return CYCLE_UNIT / 2 * 12;
		}
	} else {
	}
	m68k_setpc (regs, oldpc + 4);
}}}endlabel1160: ;
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (An) */
unsigned long REGPARAM2 CPUFUNC(op_5fd0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{{	int val = cctrue (&regs->ccrflags, 15) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_5fd8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{{	int val = cctrue (&regs->ccrflags, 15) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* Scc.B -(An) */
unsigned long REGPARAM2 CPUFUNC(op_5fe0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{{	int val = cctrue (&regs->ccrflags, 15) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* Scc.B (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_5fe8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 15) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* Scc.B (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_5ff0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{{	int val = cctrue (&regs->ccrflags, 15) ? 0xff : 0;
	put_byte (srca,val);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* Scc.B (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_5ff8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 15) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
#endif

#ifdef PART_6
/* Scc.B (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_5ff9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = get_ilong (regs, 2);
{{	int val = cctrue (&regs->ccrflags, 15) ? 0xff : 0;
	put_byte (srca,val);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* TRAPcc.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_5ffa_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 dummy = get_iword (regs, 2);
	if (cctrue (&regs->ccrflags, 15)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1168; }
}}	m68k_incpc (regs, 4);
endlabel1168: ;
return CYCLE_UNIT / 2 * 8;
}
#endif
/* TRAPcc.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_5ffb_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 dummy = get_ilong (regs, 2);
	if (cctrue (&regs->ccrflags, 15)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1169; }
}}	m68k_incpc (regs, 6);
endlabel1169: ;
return CYCLE_UNIT / 2 * 12;
}
#endif
/* TRAPcc.L  */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_5ffc_0)(uae_u32 opcode, struct regstruct *regs)
{
{	if (cctrue (&regs->ccrflags, 15)) { Exception (7, regs, m68k_getpc (regs)); goto endlabel1170; }
}	m68k_incpc (regs, 2);
endlabel1170: ;
return CYCLE_UNIT / 2 * 4;
}
#endif
/* Bcc.W #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_6000_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
	if (!cctrue (&regs->ccrflags, 0)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1171;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 4);
}}endlabel1171: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.B #<data> */
unsigned long REGPARAM2 CPUFUNC(op_6001_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (&regs->ccrflags, 0)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1172;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 2);
}}endlabel1172: ;
return CYCLE_UNIT / 2 * 8;
}
/* Bcc.L #<data>.L */
unsigned long REGPARAM2 CPUFUNC(op_60ff_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
	if (!cctrue (&regs->ccrflags, 0)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1173;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 6);
}}endlabel1173: ;
return CYCLE_UNIT / 2 * 12;
}
/* BSR.W #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_6100_0)(uae_u32 opcode, struct regstruct *regs)
{
{	uae_s32 s;
{	uae_s16 src = get_iword (regs, 2);
	s = (uae_s32)src + 2;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + s);
		goto endlabel1174;
	}
	m68k_do_bsr (regs, m68k_getpc (regs) + 4, s);
}}endlabel1174: ;
return CYCLE_UNIT / 2 * 8;
}
/* BSR.B #<data> */
unsigned long REGPARAM2 CPUFUNC(op_6101_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{	uae_s32 s;
{	uae_u32 src = srcreg;
	s = (uae_s32)src + 2;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + s);
		goto endlabel1175;
	}
	m68k_do_bsr (regs, m68k_getpc (regs) + 2, s);
}}endlabel1175: ;
return CYCLE_UNIT / 2 * 4;
}
/* BSR.L #<data>.L */
unsigned long REGPARAM2 CPUFUNC(op_61ff_0)(uae_u32 opcode, struct regstruct *regs)
{
{	uae_s32 s;
{	uae_s32 src = get_ilong (regs, 2);
	s = (uae_s32)src + 2;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + s);
		goto endlabel1176;
	}
	m68k_do_bsr (regs, m68k_getpc (regs) + 6, s);
}}endlabel1176: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.W #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_6200_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
	if (!cctrue (&regs->ccrflags, 2)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1177;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 4);
}}endlabel1177: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.B #<data> */
unsigned long REGPARAM2 CPUFUNC(op_6201_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (&regs->ccrflags, 2)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1178;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 2);
}}endlabel1178: ;
return CYCLE_UNIT / 2 * 8;
}
/* Bcc.L #<data>.L */
unsigned long REGPARAM2 CPUFUNC(op_62ff_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
	if (!cctrue (&regs->ccrflags, 2)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1179;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 6);
}}endlabel1179: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.W #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_6300_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
	if (!cctrue (&regs->ccrflags, 3)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1180;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 4);
}}endlabel1180: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.B #<data> */
unsigned long REGPARAM2 CPUFUNC(op_6301_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (&regs->ccrflags, 3)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1181;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 2);
}}endlabel1181: ;
return CYCLE_UNIT / 2 * 8;
}
/* Bcc.L #<data>.L */
unsigned long REGPARAM2 CPUFUNC(op_63ff_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
	if (!cctrue (&regs->ccrflags, 3)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1182;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 6);
}}endlabel1182: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.W #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_6400_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
	if (!cctrue (&regs->ccrflags, 4)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1183;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 4);
}}endlabel1183: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.B #<data> */
unsigned long REGPARAM2 CPUFUNC(op_6401_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (&regs->ccrflags, 4)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1184;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 2);
}}endlabel1184: ;
return CYCLE_UNIT / 2 * 8;
}
/* Bcc.L #<data>.L */
unsigned long REGPARAM2 CPUFUNC(op_64ff_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
	if (!cctrue (&regs->ccrflags, 4)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1185;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 6);
}}endlabel1185: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.W #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_6500_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
	if (!cctrue (&regs->ccrflags, 5)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1186;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 4);
}}endlabel1186: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.B #<data> */
unsigned long REGPARAM2 CPUFUNC(op_6501_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (&regs->ccrflags, 5)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1187;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 2);
}}endlabel1187: ;
return CYCLE_UNIT / 2 * 8;
}
/* Bcc.L #<data>.L */
unsigned long REGPARAM2 CPUFUNC(op_65ff_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
	if (!cctrue (&regs->ccrflags, 5)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1188;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 6);
}}endlabel1188: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.W #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_6600_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
	if (!cctrue (&regs->ccrflags, 6)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1189;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 4);
}}endlabel1189: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.B #<data> */
unsigned long REGPARAM2 CPUFUNC(op_6601_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (&regs->ccrflags, 6)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1190;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 2);
}}endlabel1190: ;
return CYCLE_UNIT / 2 * 8;
}
/* Bcc.L #<data>.L */
unsigned long REGPARAM2 CPUFUNC(op_66ff_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
	if (!cctrue (&regs->ccrflags, 6)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1191;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 6);
}}endlabel1191: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.W #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_6700_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
	if (!cctrue (&regs->ccrflags, 7)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1192;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 4);
}}endlabel1192: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.B #<data> */
unsigned long REGPARAM2 CPUFUNC(op_6701_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (&regs->ccrflags, 7)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1193;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 2);
}}endlabel1193: ;
return CYCLE_UNIT / 2 * 8;
}
/* Bcc.L #<data>.L */
unsigned long REGPARAM2 CPUFUNC(op_67ff_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
	if (!cctrue (&regs->ccrflags, 7)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1194;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 6);
}}endlabel1194: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.W #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_6800_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
	if (!cctrue (&regs->ccrflags, 8)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1195;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 4);
}}endlabel1195: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.B #<data> */
unsigned long REGPARAM2 CPUFUNC(op_6801_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (&regs->ccrflags, 8)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1196;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 2);
}}endlabel1196: ;
return CYCLE_UNIT / 2 * 8;
}
/* Bcc.L #<data>.L */
unsigned long REGPARAM2 CPUFUNC(op_68ff_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
	if (!cctrue (&regs->ccrflags, 8)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1197;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 6);
}}endlabel1197: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.W #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_6900_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
	if (!cctrue (&regs->ccrflags, 9)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1198;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 4);
}}endlabel1198: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.B #<data> */
unsigned long REGPARAM2 CPUFUNC(op_6901_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (&regs->ccrflags, 9)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1199;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 2);
}}endlabel1199: ;
return CYCLE_UNIT / 2 * 8;
}
/* Bcc.L #<data>.L */
unsigned long REGPARAM2 CPUFUNC(op_69ff_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
	if (!cctrue (&regs->ccrflags, 9)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1200;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 6);
}}endlabel1200: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.W #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_6a00_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
	if (!cctrue (&regs->ccrflags, 10)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1201;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 4);
}}endlabel1201: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.B #<data> */
unsigned long REGPARAM2 CPUFUNC(op_6a01_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (&regs->ccrflags, 10)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1202;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 2);
}}endlabel1202: ;
return CYCLE_UNIT / 2 * 8;
}
/* Bcc.L #<data>.L */
unsigned long REGPARAM2 CPUFUNC(op_6aff_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
	if (!cctrue (&regs->ccrflags, 10)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1203;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 6);
}}endlabel1203: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.W #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_6b00_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
	if (!cctrue (&regs->ccrflags, 11)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1204;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 4);
}}endlabel1204: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.B #<data> */
unsigned long REGPARAM2 CPUFUNC(op_6b01_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (&regs->ccrflags, 11)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1205;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 2);
}}endlabel1205: ;
return CYCLE_UNIT / 2 * 8;
}
/* Bcc.L #<data>.L */
unsigned long REGPARAM2 CPUFUNC(op_6bff_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
	if (!cctrue (&regs->ccrflags, 11)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1206;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 6);
}}endlabel1206: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.W #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_6c00_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
	if (!cctrue (&regs->ccrflags, 12)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1207;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 4);
}}endlabel1207: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.B #<data> */
unsigned long REGPARAM2 CPUFUNC(op_6c01_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (&regs->ccrflags, 12)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1208;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 2);
}}endlabel1208: ;
return CYCLE_UNIT / 2 * 8;
}
/* Bcc.L #<data>.L */
unsigned long REGPARAM2 CPUFUNC(op_6cff_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
	if (!cctrue (&regs->ccrflags, 12)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1209;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 6);
}}endlabel1209: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.W #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_6d00_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
	if (!cctrue (&regs->ccrflags, 13)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1210;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 4);
}}endlabel1210: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.B #<data> */
unsigned long REGPARAM2 CPUFUNC(op_6d01_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (&regs->ccrflags, 13)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1211;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 2);
}}endlabel1211: ;
return CYCLE_UNIT / 2 * 8;
}
/* Bcc.L #<data>.L */
unsigned long REGPARAM2 CPUFUNC(op_6dff_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
	if (!cctrue (&regs->ccrflags, 13)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1212;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 6);
}}endlabel1212: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.W #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_6e00_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
	if (!cctrue (&regs->ccrflags, 14)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1213;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 4);
}}endlabel1213: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.B #<data> */
unsigned long REGPARAM2 CPUFUNC(op_6e01_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (&regs->ccrflags, 14)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1214;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 2);
}}endlabel1214: ;
return CYCLE_UNIT / 2 * 8;
}
/* Bcc.L #<data>.L */
unsigned long REGPARAM2 CPUFUNC(op_6eff_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
	if (!cctrue (&regs->ccrflags, 14)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1215;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 6);
}}endlabel1215: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.W #<data>.W */
unsigned long REGPARAM2 CPUFUNC(op_6f00_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_iword (regs, 2);
	if (!cctrue (&regs->ccrflags, 15)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1216;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 4);
}}endlabel1216: ;
return CYCLE_UNIT / 2 * 12;
}
/* Bcc.B #<data> */
unsigned long REGPARAM2 CPUFUNC(op_6f01_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (&regs->ccrflags, 15)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1217;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 2);
}}endlabel1217: ;
return CYCLE_UNIT / 2 * 8;
}
/* Bcc.L #<data>.L */
unsigned long REGPARAM2 CPUFUNC(op_6fff_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src = get_ilong (regs, 2);
	if (!cctrue (&regs->ccrflags, 15)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel1218;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	return CYCLE_UNIT / 2 * 10;
didnt_jump:;
	m68k_incpc (regs, 6);
}}endlabel1218: ;
return CYCLE_UNIT / 2 * 12;
}
/* MOVE.L #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_7000_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_u32 src = srcreg;
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}return CYCLE_UNIT / 2 * 4;
}
/* OR.B Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_8000_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* OR.B (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_8010_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* OR.B (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_8018_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* OR.B -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_8020_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* OR.B (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_8028_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* OR.B (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_8030_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* OR.B (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_8038_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* OR.B (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_8039_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* OR.B (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_803a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* OR.B (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_803b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* OR.B #<data>.B,Dn */
unsigned long REGPARAM2 CPUFUNC(op_803c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* OR.W Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_8040_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* OR.W (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_8050_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* OR.W (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_8058_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* OR.W -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_8060_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* OR.W (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_8068_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* OR.W (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_8070_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* OR.W (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_8078_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* OR.W (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_8079_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* OR.W (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_807a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* OR.W (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_807b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* OR.W #<data>.W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_807c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* OR.L Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_8080_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* OR.L (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_8090_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* OR.L (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_8098_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* OR.L -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_80a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* OR.L (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_80a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* OR.L (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_80b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* OR.L (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_80b8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* OR.L (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_80b9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* OR.L (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_80ba_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* OR.L (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_80bb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* OR.L #<data>.L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_80bc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* DIVU.W Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_80c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		SET_VFLG (&regs->ccrflags, 1);
		if (dst < 0) SET_NFLG (&regs->ccrflags, 1);
		m68k_incpc (regs, 2);
		Exception (5, regs, oldpc);
		goto endlabel1253;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpc (regs, 2);
	}
}}}endlabel1253: ;
return CYCLE_UNIT / 2 * 110;
}
/* DIVU.W (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_80d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		SET_VFLG (&regs->ccrflags, 1);
		if (dst < 0) SET_NFLG (&regs->ccrflags, 1);
		m68k_incpc (regs, 2);
		Exception (5, regs, oldpc);
		goto endlabel1254;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpc (regs, 2);
	}
}}}}endlabel1254: ;
return CYCLE_UNIT / 2 * 114;
}
/* DIVU.W (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_80d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		SET_VFLG (&regs->ccrflags, 1);
		if (dst < 0) SET_NFLG (&regs->ccrflags, 1);
		m68k_incpc (regs, 2);
		Exception (5, regs, oldpc);
		goto endlabel1255;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpc (regs, 2);
	}
}}}}endlabel1255: ;
return CYCLE_UNIT / 2 * 114;
}
/* DIVU.W -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_80e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		SET_VFLG (&regs->ccrflags, 1);
		if (dst < 0) SET_NFLG (&regs->ccrflags, 1);
		m68k_incpc (regs, 2);
		Exception (5, regs, oldpc);
		goto endlabel1256;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpc (regs, 2);
	}
}}}}endlabel1256: ;
return CYCLE_UNIT / 2 * 116;
}
/* DIVU.W (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_80e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		SET_VFLG (&regs->ccrflags, 1);
		if (dst < 0) SET_NFLG (&regs->ccrflags, 1);
		m68k_incpc (regs, 4);
		Exception (5, regs, oldpc);
		goto endlabel1257;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpc (regs, 4);
	}
}}}}endlabel1257: ;
return CYCLE_UNIT / 2 * 118;
}
/* DIVU.W (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_80f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		SET_VFLG (&regs->ccrflags, 1);
		if (dst < 0) SET_NFLG (&regs->ccrflags, 1);
		m68k_incpc (regs, 0);
		Exception (5, regs, oldpc);
		goto endlabel1258;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
}}}}}endlabel1258: ;
return CYCLE_UNIT / 2 * 120;
}
/* DIVU.W (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_80f8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		SET_VFLG (&regs->ccrflags, 1);
		if (dst < 0) SET_NFLG (&regs->ccrflags, 1);
		m68k_incpc (regs, 4);
		Exception (5, regs, oldpc);
		goto endlabel1259;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpc (regs, 4);
	}
}}}}endlabel1259: ;
return CYCLE_UNIT / 2 * 118;
}
/* DIVU.W (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_80f9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		SET_VFLG (&regs->ccrflags, 1);
		if (dst < 0) SET_NFLG (&regs->ccrflags, 1);
		m68k_incpc (regs, 6);
		Exception (5, regs, oldpc);
		goto endlabel1260;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpc (regs, 6);
	}
}}}}endlabel1260: ;
return CYCLE_UNIT / 2 * 122;
}
/* DIVU.W (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_80fa_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		SET_VFLG (&regs->ccrflags, 1);
		if (dst < 0) SET_NFLG (&regs->ccrflags, 1);
		m68k_incpc (regs, 4);
		Exception (5, regs, oldpc);
		goto endlabel1261;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpc (regs, 4);
	}
}}}}endlabel1261: ;
return CYCLE_UNIT / 2 * 118;
}
/* DIVU.W (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_80fb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		SET_VFLG (&regs->ccrflags, 1);
		if (dst < 0) SET_NFLG (&regs->ccrflags, 1);
		m68k_incpc (regs, 0);
		Exception (5, regs, oldpc);
		goto endlabel1262;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
}}}}}endlabel1262: ;
return CYCLE_UNIT / 2 * 120;
}
/* DIVU.W #<data>.W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_80fc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 src = get_iword (regs, 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		SET_VFLG (&regs->ccrflags, 1);
		if (dst < 0) SET_NFLG (&regs->ccrflags, 1);
		m68k_incpc (regs, 4);
		Exception (5, regs, oldpc);
		goto endlabel1263;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpc (regs, 4);
	}
}}}endlabel1263: ;
return CYCLE_UNIT / 2 * 114;
}
/* SBCD.B Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_8100_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{	uae_u16 newv_lo = (dst & 0xF) - (src & 0xF) - GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = (dst & 0xF0) - (src & 0xF0);
	uae_u16 newv, tmp_newv;
	int bcd = 0;
	newv = tmp_newv = newv_hi + newv_lo;
	if (newv_lo & 0xF0) { newv -= 6; bcd = 6; };
	if ((((dst & 0xFF) - (src & 0xFF) - GET_XFLG (&regs->ccrflags)) & 0x100) > 0xFF) { newv -= 0x60; }
	SET_CFLG (&regs->ccrflags, ((((dst & 0xFF) - (src & 0xFF) - bcd - GET_XFLG (&regs->ccrflags)) & 0x300) > 0xFF) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* SBCD.B -(An),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_8108_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uae_u16 newv_lo = (dst & 0xF) - (src & 0xF) - GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = (dst & 0xF0) - (src & 0xF0);
	uae_u16 newv, tmp_newv;
	int bcd = 0;
	newv = tmp_newv = newv_hi + newv_lo;
	if (newv_lo & 0xF0) { newv -= 6; bcd = 6; };
	if ((((dst & 0xFF) - (src & 0xFF) - GET_XFLG (&regs->ccrflags)) & 0x100) > 0xFF) { newv -= 0x60; }
	SET_CFLG (&regs->ccrflags, ((((dst & 0xFF) - (src & 0xFF) - bcd - GET_XFLG (&regs->ccrflags)) & 0x300) > 0xFF) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0) ? 1 : 0);
	put_byte (dsta,newv);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 16;
}
/* OR.B Dn,(An) */
unsigned long REGPARAM2 CPUFUNC(op_8110_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* OR.B Dn,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_8118_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* OR.B Dn,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_8120_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* OR.B Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_8128_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* OR.B Dn,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_8130_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* OR.B Dn,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_8138_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* OR.B Dn,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_8139_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* PACK.L Dn,Dn */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_8140_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uae_u16 val = m68k_dreg (regs, srcreg) + get_iword (regs, 2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & 0xffffff00) | ((val >> 4) & 0xf0) | (val & 0xf);
}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
#endif
/* PACK.L -(An),-(An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_8148_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uae_u16 val;
	m68k_areg (regs, srcreg) -= areg_byteinc[srcreg];
	val = (uae_u16)get_byte (m68k_areg (regs, srcreg));
	m68k_areg (regs, srcreg) -= areg_byteinc[srcreg];
	val = (val | ((uae_u16)get_byte (m68k_areg (regs, srcreg)) << 8)) + get_iword (regs, 2);
	m68k_areg (regs, dstreg) -= areg_byteinc[dstreg];
	put_byte (m68k_areg (regs, dstreg),((val >> 4) & 0xf0) | (val & 0xf));
}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
#endif
/* OR.W Dn,(An) */
unsigned long REGPARAM2 CPUFUNC(op_8150_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* OR.W Dn,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_8158_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* OR.W Dn,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_8160_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* OR.W Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_8168_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 dst = get_word (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* OR.W Dn,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_8170_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s16 dst = get_word (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* OR.W Dn,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_8178_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 dst = get_word (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* OR.W Dn,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_8179_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s16 dst = get_word (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* UNPK.L Dn,Dn */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_8180_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uae_u16 val = m68k_dreg (regs, srcreg);
	val = (((val << 4) & 0xf00) | (val & 0xf)) + get_iword (regs, 2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & 0xffff0000) | (val & 0xffff);
}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
#endif
/* UNPK.L -(An),-(An) */
#ifndef CPUEMU_68000_ONLY
unsigned long REGPARAM2 CPUFUNC(op_8188_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uae_u16 val;
	m68k_areg (regs, srcreg) -= areg_byteinc[srcreg];
	val = (uae_u16)get_byte (m68k_areg (regs, srcreg));
	val = (((val << 4) & 0xf00) | (val & 0xf)) + get_iword (regs, 2);
	m68k_areg (regs, dstreg) -= areg_byteinc[dstreg];
	put_byte (m68k_areg (regs, dstreg),val);
	m68k_areg (regs, dstreg) -= areg_byteinc[dstreg];
	put_byte (m68k_areg (regs, dstreg),val >> 8);
}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
#endif
/* OR.L Dn,(An) */
unsigned long REGPARAM2 CPUFUNC(op_8190_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 20;
}
/* OR.L Dn,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_8198_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 20;
}
/* OR.L Dn,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_81a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 22;
}
/* OR.L Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_81a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 dst = get_long (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 24;
}
/* OR.L Dn,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_81b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s32 dst = get_long (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}}return CYCLE_UNIT / 2 * 26;
}
/* OR.L Dn,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_81b8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 dst = get_long (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 24;
}
/* OR.L Dn,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_81b9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s32 dst = get_long (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 28;
}
/* DIVS.W Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_81c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		SET_VFLG (&regs->ccrflags, 1);
		SET_ZFLG (&regs->ccrflags, 1);
		m68k_incpc (regs, 2);
		Exception (5, regs, oldpc);
		goto endlabel1291;
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpc (regs, 2);
	}
}}}endlabel1291: ;
return CYCLE_UNIT / 2 * 142;
}
/* DIVS.W (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_81d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		SET_VFLG (&regs->ccrflags, 1);
		SET_ZFLG (&regs->ccrflags, 1);
		m68k_incpc (regs, 2);
		Exception (5, regs, oldpc);
		goto endlabel1292;
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpc (regs, 2);
	}
}}}}endlabel1292: ;
return CYCLE_UNIT / 2 * 146;
}
/* DIVS.W (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_81d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		SET_VFLG (&regs->ccrflags, 1);
		SET_ZFLG (&regs->ccrflags, 1);
		m68k_incpc (regs, 2);
		Exception (5, regs, oldpc);
		goto endlabel1293;
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpc (regs, 2);
	}
}}}}endlabel1293: ;
return CYCLE_UNIT / 2 * 146;
}
/* DIVS.W -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_81e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		SET_VFLG (&regs->ccrflags, 1);
		SET_ZFLG (&regs->ccrflags, 1);
		m68k_incpc (regs, 2);
		Exception (5, regs, oldpc);
		goto endlabel1294;
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpc (regs, 2);
	}
}}}}endlabel1294: ;
return CYCLE_UNIT / 2 * 148;
}
/* DIVS.W (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_81e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		SET_VFLG (&regs->ccrflags, 1);
		SET_ZFLG (&regs->ccrflags, 1);
		m68k_incpc (regs, 4);
		Exception (5, regs, oldpc);
		goto endlabel1295;
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpc (regs, 4);
	}
}}}}endlabel1295: ;
return CYCLE_UNIT / 2 * 150;
}
/* DIVS.W (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_81f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		SET_VFLG (&regs->ccrflags, 1);
		SET_ZFLG (&regs->ccrflags, 1);
		m68k_incpc (regs, 0);
		Exception (5, regs, oldpc);
		goto endlabel1296;
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
}}}}}endlabel1296: ;
return CYCLE_UNIT / 2 * 152;
}
/* DIVS.W (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_81f8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		SET_VFLG (&regs->ccrflags, 1);
		SET_ZFLG (&regs->ccrflags, 1);
		m68k_incpc (regs, 4);
		Exception (5, regs, oldpc);
		goto endlabel1297;
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpc (regs, 4);
	}
}}}}endlabel1297: ;
return CYCLE_UNIT / 2 * 150;
}
/* DIVS.W (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_81f9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		SET_VFLG (&regs->ccrflags, 1);
		SET_ZFLG (&regs->ccrflags, 1);
		m68k_incpc (regs, 6);
		Exception (5, regs, oldpc);
		goto endlabel1298;
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpc (regs, 6);
	}
}}}}endlabel1298: ;
return CYCLE_UNIT / 2 * 154;
}
/* DIVS.W (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_81fa_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		SET_VFLG (&regs->ccrflags, 1);
		SET_ZFLG (&regs->ccrflags, 1);
		m68k_incpc (regs, 4);
		Exception (5, regs, oldpc);
		goto endlabel1299;
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpc (regs, 4);
	}
}}}}endlabel1299: ;
return CYCLE_UNIT / 2 * 150;
}
/* DIVS.W (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_81fb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		SET_VFLG (&regs->ccrflags, 1);
		SET_ZFLG (&regs->ccrflags, 1);
		m68k_incpc (regs, 0);
		Exception (5, regs, oldpc);
		goto endlabel1300;
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
}}}}}endlabel1300: ;
return CYCLE_UNIT / 2 * 152;
}
/* DIVS.W #<data>.W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_81fc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 src = get_iword (regs, 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		SET_VFLG (&regs->ccrflags, 1);
		SET_ZFLG (&regs->ccrflags, 1);
		m68k_incpc (regs, 4);
		Exception (5, regs, oldpc);
		goto endlabel1301;
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpc (regs, 4);
	}
}}}endlabel1301: ;
return CYCLE_UNIT / 2 * 146;
}
/* SUB.B Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_9000_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* SUB.B (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_9010_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* SUB.B (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_9018_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* SUB.B -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_9020_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* SUB.B (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_9028_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* SUB.B (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_9030_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}}return CYCLE_UNIT / 2 * 14;
}
/* SUB.B (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_9038_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* SUB.B (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_9039_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* SUB.B (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_903a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* SUB.B (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_903b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}}return CYCLE_UNIT / 2 * 14;
}
/* SUB.B #<data>.B,Dn */
unsigned long REGPARAM2 CPUFUNC(op_903c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* SUB.W Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_9040_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* SUB.W An,Dn */
unsigned long REGPARAM2 CPUFUNC(op_9048_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* SUB.W (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_9050_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* SUB.W (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_9058_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* SUB.W -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_9060_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* SUB.W (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_9068_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* SUB.W (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_9070_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}return CYCLE_UNIT / 2 * 14;
}
/* SUB.W (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_9078_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* SUB.W (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_9079_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* SUB.W (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_907a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* SUB.W (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_907b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}return CYCLE_UNIT / 2 * 14;
}
/* SUB.W #<data>.W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_907c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* SUB.L Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_9080_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* SUB.L An,Dn */
unsigned long REGPARAM2 CPUFUNC(op_9088_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* SUB.L (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_9090_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* SUB.L (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_9098_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* SUB.L -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_90a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* SUB.L (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_90a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* SUB.L (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_90b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* SUB.L (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_90b8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* SUB.L (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_90b9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* SUB.L (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_90ba_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* SUB.L (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_90bb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* SUB.L #<data>.L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_90bc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* SUBA.W Dn,An */
unsigned long REGPARAM2 CPUFUNC(op_90c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* SUBA.W An,An */
unsigned long REGPARAM2 CPUFUNC(op_90c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* SUBA.W (An),An */
unsigned long REGPARAM2 CPUFUNC(op_90d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* SUBA.W (An)+,An */
unsigned long REGPARAM2 CPUFUNC(op_90d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* SUBA.W -(An),An */
unsigned long REGPARAM2 CPUFUNC(op_90e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* SUBA.W (d16,An),An */
unsigned long REGPARAM2 CPUFUNC(op_90e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* SUBA.W (d8,An,Xn),An */
unsigned long REGPARAM2 CPUFUNC(op_90f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}return CYCLE_UNIT / 2 * 14;
}
/* SUBA.W (xxx).W,An */
unsigned long REGPARAM2 CPUFUNC(op_90f8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* SUBA.W (xxx).L,An */
unsigned long REGPARAM2 CPUFUNC(op_90f9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* SUBA.W (d16,PC),An */
unsigned long REGPARAM2 CPUFUNC(op_90fa_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* SUBA.W (d8,PC,Xn),An */
unsigned long REGPARAM2 CPUFUNC(op_90fb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}return CYCLE_UNIT / 2 * 14;
}
/* SUBA.W #<data>.W,An */
unsigned long REGPARAM2 CPUFUNC(op_90fc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* SUBX.B Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_9100_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = dst - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* SUBX.B -(An),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_9108_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uae_u32 newv = dst - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 16;
}
/* SUB.B Dn,(An) */
unsigned long REGPARAM2 CPUFUNC(op_9110_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* SUB.B Dn,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_9118_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* SUB.B Dn,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_9120_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* SUB.B Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_9128_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* SUB.B Dn,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_9130_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* SUB.B Dn,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_9138_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* SUB.B Dn,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_9139_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* SUBX.W Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_9140_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = dst - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s16)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* SUBX.W -(An),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_9148_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uae_u32 newv = dst - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s16)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 16;
}
/* SUB.W Dn,(An) */
unsigned long REGPARAM2 CPUFUNC(op_9150_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* SUB.W Dn,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_9158_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* SUB.W Dn,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_9160_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* SUB.W Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_9168_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* SUB.W Dn,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_9170_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* SUB.W Dn,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_9178_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* SUB.W Dn,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_9179_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* SUBX.L Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_9180_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = dst - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s32)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* SUBX.L -(An),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_9188_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uae_u32 newv = dst - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s32)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 28;
}
/* SUB.L Dn,(An) */
unsigned long REGPARAM2 CPUFUNC(op_9190_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 20;
}
/* SUB.L Dn,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_9198_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 20;
}
/* SUB.L Dn,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_91a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 22;
}
/* SUB.L Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_91a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 24;
}
/* SUB.L Dn,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_91b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}}return CYCLE_UNIT / 2 * 26;
}
/* SUB.L Dn,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_91b8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 24;
}
/* SUB.L Dn,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_91b9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 28;
}
/* SUBA.L Dn,An */
unsigned long REGPARAM2 CPUFUNC(op_91c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* SUBA.L An,An */
unsigned long REGPARAM2 CPUFUNC(op_91c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* SUBA.L (An),An */
unsigned long REGPARAM2 CPUFUNC(op_91d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* SUBA.L (An)+,An */
unsigned long REGPARAM2 CPUFUNC(op_91d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* SUBA.L -(An),An */
unsigned long REGPARAM2 CPUFUNC(op_91e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* SUBA.L (d16,An),An */
unsigned long REGPARAM2 CPUFUNC(op_91e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* SUBA.L (d8,An,Xn),An */
unsigned long REGPARAM2 CPUFUNC(op_91f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* SUBA.L (xxx).W,An */
unsigned long REGPARAM2 CPUFUNC(op_91f8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* SUBA.L (xxx).L,An */
unsigned long REGPARAM2 CPUFUNC(op_91f9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* SUBA.L (d16,PC),An */
unsigned long REGPARAM2 CPUFUNC(op_91fa_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* SUBA.L (d8,PC,Xn),An */
unsigned long REGPARAM2 CPUFUNC(op_91fb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* SUBA.L #<data>.L,An */
unsigned long REGPARAM2 CPUFUNC(op_91fc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* CMP.B Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_b000_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* CMP.B (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_b010_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* CMP.B (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_b018_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* CMP.B -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_b020_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* CMP.B (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_b028_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* CMP.B (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_b030_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}return CYCLE_UNIT / 2 * 14;
}
/* CMP.B (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_b038_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* CMP.B (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_b039_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* CMP.B (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_b03a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* CMP.B (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_b03b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}return CYCLE_UNIT / 2 * 14;
}
/* CMP.B #<data>.B,Dn */
unsigned long REGPARAM2 CPUFUNC(op_b03c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* CMP.W Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_b040_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
#endif

#ifdef PART_7
/* CMP.W An,Dn */
unsigned long REGPARAM2 CPUFUNC(op_b048_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* CMP.W (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_b050_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* CMP.W (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_b058_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* CMP.W -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_b060_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* CMP.W (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_b068_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* CMP.W (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_b070_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}return CYCLE_UNIT / 2 * 14;
}
/* CMP.W (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_b078_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* CMP.W (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_b079_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* CMP.W (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_b07a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* CMP.W (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_b07b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}return CYCLE_UNIT / 2 * 14;
}
/* CMP.W #<data>.W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_b07c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* CMP.L Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_b080_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* CMP.L An,Dn */
unsigned long REGPARAM2 CPUFUNC(op_b088_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* CMP.L (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_b090_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* CMP.L (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_b098_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* CMP.L -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_b0a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* CMP.L (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_b0a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* CMP.L (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_b0b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* CMP.L (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_b0b8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* CMP.L (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_b0b9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* CMP.L (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_b0ba_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* CMP.L (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_b0bb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* CMP.L #<data>.L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_b0bc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* CMPA.W Dn,An */
unsigned long REGPARAM2 CPUFUNC(op_b0c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* CMPA.W An,An */
unsigned long REGPARAM2 CPUFUNC(op_b0c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* CMPA.W (An),An */
unsigned long REGPARAM2 CPUFUNC(op_b0d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* CMPA.W (An)+,An */
unsigned long REGPARAM2 CPUFUNC(op_b0d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* CMPA.W -(An),An */
unsigned long REGPARAM2 CPUFUNC(op_b0e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* CMPA.W (d16,An),An */
unsigned long REGPARAM2 CPUFUNC(op_b0e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* CMPA.W (d8,An,Xn),An */
unsigned long REGPARAM2 CPUFUNC(op_b0f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}return CYCLE_UNIT / 2 * 14;
}
/* CMPA.W (xxx).W,An */
unsigned long REGPARAM2 CPUFUNC(op_b0f8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* CMPA.W (xxx).L,An */
unsigned long REGPARAM2 CPUFUNC(op_b0f9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* CMPA.W (d16,PC),An */
unsigned long REGPARAM2 CPUFUNC(op_b0fa_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* CMPA.W (d8,PC,Xn),An */
unsigned long REGPARAM2 CPUFUNC(op_b0fb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}return CYCLE_UNIT / 2 * 14;
}
/* CMPA.W #<data>.W,An */
unsigned long REGPARAM2 CPUFUNC(op_b0fc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* EOR.B Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_b100_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* CMPM.B (An)+,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_b108_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* EOR.B Dn,(An) */
unsigned long REGPARAM2 CPUFUNC(op_b110_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* EOR.B Dn,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_b118_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* EOR.B Dn,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_b120_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* EOR.B Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_b128_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* EOR.B Dn,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_b130_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* EOR.B Dn,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_b138_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* EOR.B Dn,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_b139_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* EOR.W Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_b140_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* CMPM.W (An)+,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_b148_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* EOR.W Dn,(An) */
unsigned long REGPARAM2 CPUFUNC(op_b150_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* EOR.W Dn,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_b158_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* EOR.W Dn,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_b160_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* EOR.W Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_b168_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 dst = get_word (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* EOR.W Dn,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_b170_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s16 dst = get_word (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* EOR.W Dn,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_b178_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 dst = get_word (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* EOR.W Dn,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_b179_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s16 dst = get_word (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* EOR.L Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_b180_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* CMPM.L (An)+,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_b188_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 20;
}
/* EOR.L Dn,(An) */
unsigned long REGPARAM2 CPUFUNC(op_b190_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 20;
}
/* EOR.L Dn,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_b198_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 20;
}
/* EOR.L Dn,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_b1a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 22;
}
/* EOR.L Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_b1a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 dst = get_long (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 24;
}
/* EOR.L Dn,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_b1b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s32 dst = get_long (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}}return CYCLE_UNIT / 2 * 26;
}
/* EOR.L Dn,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_b1b8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 dst = get_long (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 24;
}
/* EOR.L Dn,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_b1b9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s32 dst = get_long (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 28;
}
/* CMPA.L Dn,An */
unsigned long REGPARAM2 CPUFUNC(op_b1c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* CMPA.L An,An */
unsigned long REGPARAM2 CPUFUNC(op_b1c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* CMPA.L (An),An */
unsigned long REGPARAM2 CPUFUNC(op_b1d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* CMPA.L (An)+,An */
unsigned long REGPARAM2 CPUFUNC(op_b1d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* CMPA.L -(An),An */
unsigned long REGPARAM2 CPUFUNC(op_b1e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* CMPA.L (d16,An),An */
unsigned long REGPARAM2 CPUFUNC(op_b1e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* CMPA.L (d8,An,Xn),An */
unsigned long REGPARAM2 CPUFUNC(op_b1f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* CMPA.L (xxx).W,An */
unsigned long REGPARAM2 CPUFUNC(op_b1f8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* CMPA.L (xxx).L,An */
unsigned long REGPARAM2 CPUFUNC(op_b1f9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* CMPA.L (d16,PC),An */
unsigned long REGPARAM2 CPUFUNC(op_b1fa_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* CMPA.L (d8,PC,Xn),An */
unsigned long REGPARAM2 CPUFUNC(op_b1fb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* CMPA.L #<data>.L,An */
unsigned long REGPARAM2 CPUFUNC(op_b1fc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* AND.B Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c000_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* AND.B (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c010_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* AND.B (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c018_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* AND.B -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c020_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* AND.B (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c028_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* AND.B (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c030_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* AND.B (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c038_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* AND.B (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c039_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* AND.B (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c03a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* AND.B (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c03b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* AND.B #<data>.B,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c03c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* AND.W Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c040_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* AND.W (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c050_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* AND.W (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c058_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* AND.W -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c060_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* AND.W (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c068_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* AND.W (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c070_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* AND.W (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c078_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* AND.W (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c079_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* AND.W (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c07a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* AND.W (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c07b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}return CYCLE_UNIT / 2 * 14;
}
/* AND.W #<data>.W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c07c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* AND.L Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c080_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* AND.L (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c090_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* AND.L (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c098_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* AND.L -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c0a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* AND.L (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c0a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* AND.L (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c0b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* AND.L (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c0b8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* AND.L (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c0b9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* AND.L (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c0ba_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* AND.L (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c0bb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* AND.L #<data>.L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c0bc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* MULU.W Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c0c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpc (regs, 2);
}}}}return CYCLE_UNIT / 2 * 58;
}
/* MULU.W (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c0d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpc (regs, 2);
}}}}}return CYCLE_UNIT / 2 * 62;
}
/* MULU.W (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c0d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpc (regs, 2);
}}}}}return CYCLE_UNIT / 2 * 62;
}
/* MULU.W -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c0e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpc (regs, 2);
}}}}}return CYCLE_UNIT / 2 * 64;
}
/* MULU.W (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c0e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpc (regs, 4);
}}}}}return CYCLE_UNIT / 2 * 66;
}
/* MULU.W (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c0f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}return CYCLE_UNIT / 2 * 68;
}
/* MULU.W (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c0f8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpc (regs, 4);
}}}}}return CYCLE_UNIT / 2 * 66;
}
/* MULU.W (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c0f9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpc (regs, 6);
}}}}}return CYCLE_UNIT / 2 * 70;
}
/* MULU.W (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c0fa_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpc (regs, 4);
}}}}}return CYCLE_UNIT / 2 * 66;
}
/* MULU.W (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c0fb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}return CYCLE_UNIT / 2 * 68;
}
/* MULU.W #<data>.W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c0fc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpc (regs, 4);
}}}}return CYCLE_UNIT / 2 * 62;
}
/* ABCD.B Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c100_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{	uae_u16 newv_lo = (src & 0xF) + (dst & 0xF) + GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = (src & 0xF0) + (dst & 0xF0);
	uae_u16 newv, tmp_newv;
	int cflg;
	newv = tmp_newv = newv_hi + newv_lo;	if (newv_lo > 9) { newv += 6; }
	cflg = (newv & 0x3F0) > 0x90;
	if (cflg) newv += 0x60;
	SET_CFLG (&regs->ccrflags, cflg ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, ((tmp_newv & 0x80) == 0 && (newv & 0x80) != 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ABCD.B -(An),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_c108_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uae_u16 newv_lo = (src & 0xF) + (dst & 0xF) + GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = (src & 0xF0) + (dst & 0xF0);
	uae_u16 newv, tmp_newv;
	int cflg;
	newv = tmp_newv = newv_hi + newv_lo;	if (newv_lo > 9) { newv += 6; }
	cflg = (newv & 0x3F0) > 0x90;
	if (cflg) newv += 0x60;
	SET_CFLG (&regs->ccrflags, cflg ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, ((tmp_newv & 0x80) == 0 && (newv & 0x80) != 0) ? 1 : 0);
	put_byte (dsta,newv);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 16;
}
/* AND.B Dn,(An) */
unsigned long REGPARAM2 CPUFUNC(op_c110_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* AND.B Dn,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_c118_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* AND.B Dn,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_c120_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* AND.B Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_c128_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* AND.B Dn,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_c130_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* AND.B Dn,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_c138_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* AND.B Dn,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_c139_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s8 dst = get_byte (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	put_byte (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* EXG.L Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c140_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	m68k_dreg (regs, srcreg) = (dst);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* EXG.L An,An */
unsigned long REGPARAM2 CPUFUNC(op_c148_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	m68k_areg (regs, srcreg) = (dst);
	m68k_areg (regs, dstreg) = (src);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* AND.W Dn,(An) */
unsigned long REGPARAM2 CPUFUNC(op_c150_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* AND.W Dn,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_c158_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* AND.W Dn,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_c160_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* AND.W Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_c168_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 dst = get_word (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* AND.W Dn,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_c170_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s16 dst = get_word (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* AND.W Dn,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_c178_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 dst = get_word (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* AND.W Dn,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_c179_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s16 dst = get_word (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	put_word (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* EXG.L Dn,An */
unsigned long REGPARAM2 CPUFUNC(op_c188_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	m68k_dreg (regs, srcreg) = (dst);
	m68k_areg (regs, dstreg) = (src);
}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* AND.L Dn,(An) */
unsigned long REGPARAM2 CPUFUNC(op_c190_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 20;
}
/* AND.L Dn,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_c198_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 20;
}
/* AND.L Dn,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_c1a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 22;
}
/* AND.L Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_c1a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 dst = get_long (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 24;
}
/* AND.L Dn,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_c1b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s32 dst = get_long (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}}return CYCLE_UNIT / 2 * 26;
}
/* AND.L Dn,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_c1b8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 dst = get_long (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 24;
}
/* AND.L Dn,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_c1b9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s32 dst = get_long (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	put_long (dsta,src);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 28;
}
/* MULS.W Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c1c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 58;
}
/* MULS.W (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c1d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 62;
}
/* MULS.W (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c1d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 62;
}
/* MULS.W -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c1e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 64;
}
/* MULS.W (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c1e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 66;
}
/* MULS.W (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c1f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}return CYCLE_UNIT / 2 * 68;
}
/* MULS.W (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c1f8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 66;
}
/* MULS.W (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c1f9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 70;
}
/* MULS.W (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c1fa_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 66;
}
/* MULS.W (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_c1fb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}return CYCLE_UNIT / 2 * 68;
}
/* MULS.W #<data>.W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_c1fc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 62;
}
/* ADD.B Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_d000_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ADD.B (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_d010_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* ADD.B (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_d018_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* ADD.B -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_d020_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* ADD.B (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_d028_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* ADD.B (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_d030_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}}return CYCLE_UNIT / 2 * 14;
}
/* ADD.B (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_d038_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* ADD.B (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_d039_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* ADD.B (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_d03a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* ADD.B (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_d03b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s8 src = get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}}return CYCLE_UNIT / 2 * 14;
}
/* ADD.B #<data>.B,Dn */
unsigned long REGPARAM2 CPUFUNC(op_d03c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = get_ibyte (regs, 2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* ADD.W Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_d040_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ADD.W An,Dn */
unsigned long REGPARAM2 CPUFUNC(op_d048_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ADD.W (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_d050_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* ADD.W (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_d058_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* ADD.W -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_d060_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* ADD.W (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_d068_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* ADD.W (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_d070_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}return CYCLE_UNIT / 2 * 14;
}
/* ADD.W (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_d078_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* ADD.W (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_d079_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* ADD.W (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_d07a_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* ADD.W (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_d07b_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}return CYCLE_UNIT / 2 * 14;
}
/* ADD.W #<data>.W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_d07c_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* ADD.L Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_d080_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ADD.L An,Dn */
unsigned long REGPARAM2 CPUFUNC(op_d088_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ADD.L (An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_d090_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* ADD.L (An)+,Dn */
unsigned long REGPARAM2 CPUFUNC(op_d098_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* ADD.L -(An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_d0a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* ADD.L (d16,An),Dn */
unsigned long REGPARAM2 CPUFUNC(op_d0a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* ADD.L (d8,An,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_d0b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* ADD.L (xxx).W,Dn */
unsigned long REGPARAM2 CPUFUNC(op_d0b8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* ADD.L (xxx).L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_d0b9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* ADD.L (d16,PC),Dn */
unsigned long REGPARAM2 CPUFUNC(op_d0ba_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* ADD.L (d8,PC,Xn),Dn */
unsigned long REGPARAM2 CPUFUNC(op_d0bb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* ADD.L #<data>.L,Dn */
unsigned long REGPARAM2 CPUFUNC(op_d0bc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* ADDA.W Dn,An */
unsigned long REGPARAM2 CPUFUNC(op_d0c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ADDA.W An,An */
unsigned long REGPARAM2 CPUFUNC(op_d0c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ADDA.W (An),An */
unsigned long REGPARAM2 CPUFUNC(op_d0d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* ADDA.W (An)+,An */
unsigned long REGPARAM2 CPUFUNC(op_d0d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 8;
}
/* ADDA.W -(An),An */
unsigned long REGPARAM2 CPUFUNC(op_d0e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 10;
}
/* ADDA.W (d16,An),An */
unsigned long REGPARAM2 CPUFUNC(op_d0e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* ADDA.W (d8,An,Xn),An */
unsigned long REGPARAM2 CPUFUNC(op_d0f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}return CYCLE_UNIT / 2 * 14;
}
/* ADDA.W (xxx).W,An */
unsigned long REGPARAM2 CPUFUNC(op_d0f8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* ADDA.W (xxx).L,An */
unsigned long REGPARAM2 CPUFUNC(op_d0f9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 16;
}
/* ADDA.W (d16,PC),An */
unsigned long REGPARAM2 CPUFUNC(op_d0fa_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 12;
}
/* ADDA.W (d8,PC,Xn),An */
unsigned long REGPARAM2 CPUFUNC(op_d0fb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s16 src = get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}return CYCLE_UNIT / 2 * 14;
}
/* ADDA.W #<data>.W,An */
unsigned long REGPARAM2 CPUFUNC(op_d0fc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_iword (regs, 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 8;
}
/* ADDX.B Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_d100_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = dst + src + GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ADDX.B -(An),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_d108_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uae_u32 newv = dst + src + GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 16;
}
/* ADD.B Dn,(An) */
unsigned long REGPARAM2 CPUFUNC(op_d110_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* ADD.B Dn,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_d118_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* ADD.B Dn,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_d120_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* ADD.B Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_d128_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* ADD.B Dn,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_d130_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* ADD.B Dn,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_d138_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* ADD.B Dn,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_d139_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s8 dst = get_byte (dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* ADDX.W Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_d140_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = dst + src + GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s16)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ADDX.W -(An),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_d148_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uae_u32 newv = dst + src + GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s16)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 16;
}
/* ADD.W Dn,(An) */
unsigned long REGPARAM2 CPUFUNC(op_d150_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* ADD.W Dn,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_d158_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* ADD.W Dn,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_d160_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* ADD.W Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_d168_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* ADD.W Dn,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_d170_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* ADD.W Dn,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_d178_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* ADD.W Dn,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_d179_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s16 dst = get_word (dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* ADDX.L Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_d180_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
{	uae_u32 newv = dst + src + GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s32)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ADDX.L -(An),-(An) */
unsigned long REGPARAM2 CPUFUNC(op_d188_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uae_u32 newv = dst + src + GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s32)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 28;
}
/* ADD.L Dn,(An) */
unsigned long REGPARAM2 CPUFUNC(op_d190_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 20;
}
/* ADD.L Dn,(An)+ */
unsigned long REGPARAM2 CPUFUNC(op_d198_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 20;
}
/* ADD.L Dn,-(An) */
unsigned long REGPARAM2 CPUFUNC(op_d1a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 22;
}
/* ADD.L Dn,(d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_d1a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 24;
}
/* ADD.L Dn,(d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_d1b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpc (regs, 2);
{	dsta = get_disp_ea_020 (regs, m68k_areg (regs, dstreg), next_iword (regs));
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}}return CYCLE_UNIT / 2 * 26;
}
/* ADD.L Dn,(xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_d1b8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 24;
}
/* ADD.L Dn,(xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_d1b9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = get_ilong (regs, 2);
{	uae_s32 dst = get_long (dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_long (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 28;
}
/* ADDA.L Dn,An */
unsigned long REGPARAM2 CPUFUNC(op_d1c0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ADDA.L An,An */
unsigned long REGPARAM2 CPUFUNC(op_d1c8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ADDA.L (An),An */
unsigned long REGPARAM2 CPUFUNC(op_d1d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* ADDA.L (An)+,An */
unsigned long REGPARAM2 CPUFUNC(op_d1d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
#endif

#ifdef PART_8
/* ADDA.L -(An),An */
unsigned long REGPARAM2 CPUFUNC(op_d1e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* ADDA.L (d16,An),An */
unsigned long REGPARAM2 CPUFUNC(op_d1e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* ADDA.L (d8,An,Xn),An */
unsigned long REGPARAM2 CPUFUNC(op_d1f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpc (regs, 2);
{	srca = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* ADDA.L (xxx).W,An */
unsigned long REGPARAM2 CPUFUNC(op_d1f8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* ADDA.L (xxx).L,An */
unsigned long REGPARAM2 CPUFUNC(op_d1f9_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = get_ilong (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* ADDA.L (d16,PC),An */
unsigned long REGPARAM2 CPUFUNC(op_d1fa_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* ADDA.L (d8,PC,Xn),An */
unsigned long REGPARAM2 CPUFUNC(op_d1fb_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpc (regs, 2);
{	tmppc = m68k_getpc (regs);
	srca = get_disp_ea_020 (regs, tmppc, next_iword (regs));
{	uae_s32 src = get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}return CYCLE_UNIT / 2 * 18;
}
/* ADDA.L #<data>.L,An */
unsigned long REGPARAM2 CPUFUNC(op_d1fc_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = get_ilong (regs, 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 12;
}
/* ASR.B #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e000_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	uae_u32 sign = (0x80 & val) >> 7;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 8) {
		val = 0xff & (uae_u32)-sign;
		SET_CFLG (&regs->ccrflags, sign);
		COPY_CARRY (&regs->ccrflags);
	} else {
		val >>= cnt - 1;
		SET_CFLG (&regs->ccrflags, val & 1);
		COPY_CARRY (&regs->ccrflags);
		val >>= 1;
		val |= (0xff << (8 - cnt)) & (uae_u32)-sign;
		val &= 0xff;
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s8)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* LSR.B #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e008_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 8) {
		SET_CFLG (&regs->ccrflags, ((cnt == 8) ? 1 : 0) & (val >> 7));
		COPY_CARRY (&regs->ccrflags);
		val = 0;
	} else {
		val >>= cnt - 1;
		SET_CFLG (&regs->ccrflags, val & 1);
		COPY_CARRY (&regs->ccrflags);
		val >>= 1;
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s8)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ROXR.B #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e010_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
{	cnt--;
	{
	uae_u32 carry;
	uae_u32 hival = (val << 1) | GET_XFLG (&regs->ccrflags);
	hival <<= (7 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (&regs->ccrflags, carry);
	val &= 0xff;
	} }
	SET_CFLG (&regs->ccrflags, GET_XFLG (&regs->ccrflags));
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s8)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ROR.B #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e018_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
{	uae_u32 hival;
	cnt &= 7;
	hival = val << (8 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xff;
	SET_CFLG (&regs->ccrflags, (val & 0x80) >> 7);
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s8)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ASR.B Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e020_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 cnt = m68k_dreg (regs, srcreg);
{	uae_s8 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	uae_u32 sign = (0x80 & val) >> 7;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 8) {
		val = 0xff & (uae_u32)-sign;
		SET_CFLG (&regs->ccrflags, sign);
		COPY_CARRY (&regs->ccrflags);
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (&regs->ccrflags, val & 1);
		COPY_CARRY (&regs->ccrflags);
		val >>= 1;
		val |= (0xff << (8 - cnt)) & (uae_u32)-sign;
		val &= 0xff;
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s8)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* LSR.B Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e028_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 cnt = m68k_dreg (regs, srcreg);
{	uae_s8 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 8) {
		SET_CFLG (&regs->ccrflags, ((cnt == 8) ? 1 : 0) & (val >> 7));
		COPY_CARRY (&regs->ccrflags);
		val = 0;
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (&regs->ccrflags, val & 1);
		COPY_CARRY (&regs->ccrflags);
		val >>= 1;
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s8)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ROXR.B Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e030_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 cnt = m68k_dreg (regs, srcreg);
{	uae_s8 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 36) cnt -= 36;
	if (cnt >= 18) cnt -= 18;
	if (cnt >= 9) cnt -= 9;
	if (cnt > 0) {
	cnt--;
	{
	uae_u32 carry;
	uae_u32 hival = (val << 1) | GET_XFLG (&regs->ccrflags);
	hival <<= (7 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (&regs->ccrflags, carry);
	val &= 0xff;
	} }
	SET_CFLG (&regs->ccrflags, GET_XFLG (&regs->ccrflags));
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s8)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ROR.B Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e038_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 cnt = m68k_dreg (regs, srcreg);
{	uae_s8 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt > 0) {	uae_u32 hival;
	cnt &= 7;
	hival = val << (8 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xff;
	SET_CFLG (&regs->ccrflags, (val & 0x80) >> 7);
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s8)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ASR.W #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e040_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = (0x8000 & val) >> 15;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 16) {
		val = 0xffff & (uae_u32)-sign;
		SET_CFLG (&regs->ccrflags, sign);
		COPY_CARRY (&regs->ccrflags);
	} else {
		val >>= cnt - 1;
		SET_CFLG (&regs->ccrflags, val & 1);
		COPY_CARRY (&regs->ccrflags);
		val >>= 1;
		val |= (0xffff << (16 - cnt)) & (uae_u32)-sign;
		val &= 0xffff;
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s16)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* LSR.W #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e048_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 16) {
		SET_CFLG (&regs->ccrflags, ((cnt == 16) ? 1 : 0) & (val >> 15));
		COPY_CARRY (&regs->ccrflags);
		val = 0;
	} else {
		val >>= cnt - 1;
		SET_CFLG (&regs->ccrflags, val & 1);
		COPY_CARRY (&regs->ccrflags);
		val >>= 1;
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s16)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ROXR.W #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e050_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
{	cnt--;
	{
	uae_u32 carry;
	uae_u32 hival = (val << 1) | GET_XFLG (&regs->ccrflags);
	hival <<= (15 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (&regs->ccrflags, carry);
	val &= 0xffff;
	} }
	SET_CFLG (&regs->ccrflags, GET_XFLG (&regs->ccrflags));
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s16)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ROR.W #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e058_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
{	uae_u32 hival;
	cnt &= 15;
	hival = val << (16 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xffff;
	SET_CFLG (&regs->ccrflags, (val & 0x8000) >> 15);
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s16)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ASR.W Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e060_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 cnt = m68k_dreg (regs, srcreg);
{	uae_s16 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = (0x8000 & val) >> 15;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 16) {
		val = 0xffff & (uae_u32)-sign;
		SET_CFLG (&regs->ccrflags, sign);
		COPY_CARRY (&regs->ccrflags);
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (&regs->ccrflags, val & 1);
		COPY_CARRY (&regs->ccrflags);
		val >>= 1;
		val |= (0xffff << (16 - cnt)) & (uae_u32)-sign;
		val &= 0xffff;
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s16)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* LSR.W Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e068_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 cnt = m68k_dreg (regs, srcreg);
{	uae_s16 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 16) {
		SET_CFLG (&regs->ccrflags, ((cnt == 16) ? 1 : 0) & (val >> 15));
		COPY_CARRY (&regs->ccrflags);
		val = 0;
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (&regs->ccrflags, val & 1);
		COPY_CARRY (&regs->ccrflags);
		val >>= 1;
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s16)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ROXR.W Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e070_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 cnt = m68k_dreg (regs, srcreg);
{	uae_s16 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 34) cnt -= 34;
	if (cnt >= 17) cnt -= 17;
	if (cnt > 0) {
	cnt--;
	{
	uae_u32 carry;
	uae_u32 hival = (val << 1) | GET_XFLG (&regs->ccrflags);
	hival <<= (15 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (&regs->ccrflags, carry);
	val &= 0xffff;
	} }
	SET_CFLG (&regs->ccrflags, GET_XFLG (&regs->ccrflags));
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s16)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ROR.W Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e078_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 cnt = m68k_dreg (regs, srcreg);
{	uae_s16 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt > 0) {	uae_u32 hival;
	cnt &= 15;
	hival = val << (16 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xffff;
	SET_CFLG (&regs->ccrflags, (val & 0x8000) >> 15);
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s16)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ASR.L #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e080_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s32 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = data;
	uae_u32 sign = (0x80000000 & val) >> 31;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 32) {
		val = 0xffffffff & (uae_u32)-sign;
		SET_CFLG (&regs->ccrflags, sign);
		COPY_CARRY (&regs->ccrflags);
	} else {
		val >>= cnt - 1;
		SET_CFLG (&regs->ccrflags, val & 1);
		COPY_CARRY (&regs->ccrflags);
		val >>= 1;
		val |= (0xffffffff << (32 - cnt)) & (uae_u32)-sign;
		val &= 0xffffffff;
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s32)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* LSR.L #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e088_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s32 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 32) {
		SET_CFLG (&regs->ccrflags, ((cnt == 32) ? 1 : 0) & (val >> 31));
		COPY_CARRY (&regs->ccrflags);
		val = 0;
	} else {
		val >>= cnt - 1;
		SET_CFLG (&regs->ccrflags, val & 1);
		COPY_CARRY (&regs->ccrflags);
		val >>= 1;
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s32)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ROXR.L #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e090_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s32 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
{	cnt--;
	{
	uae_u32 carry;
	uae_u32 hival = (val << 1) | GET_XFLG (&regs->ccrflags);
	hival <<= (31 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (&regs->ccrflags, carry);
	val &= 0xffffffff;
	} }
	SET_CFLG (&regs->ccrflags, GET_XFLG (&regs->ccrflags));
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s32)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ROR.L #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e098_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s32 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
{	uae_u32 hival;
	cnt &= 31;
	hival = val << (32 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xffffffff;
	SET_CFLG (&regs->ccrflags, (val & 0x80000000) >> 31);
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s32)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ASR.L Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e0a0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 cnt = m68k_dreg (regs, srcreg);
{	uae_s32 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = data;
	uae_u32 sign = (0x80000000 & val) >> 31;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 32) {
		val = 0xffffffff & (uae_u32)-sign;
		SET_CFLG (&regs->ccrflags, sign);
		COPY_CARRY (&regs->ccrflags);
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (&regs->ccrflags, val & 1);
		COPY_CARRY (&regs->ccrflags);
		val >>= 1;
		val |= (0xffffffff << (32 - cnt)) & (uae_u32)-sign;
		val &= 0xffffffff;
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s32)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* LSR.L Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e0a8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 cnt = m68k_dreg (regs, srcreg);
{	uae_s32 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 32) {
		SET_CFLG (&regs->ccrflags, ((cnt == 32) ? 1 : 0) & (val >> 31));
		COPY_CARRY (&regs->ccrflags);
		val = 0;
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (&regs->ccrflags, val & 1);
		COPY_CARRY (&regs->ccrflags);
		val >>= 1;
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s32)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ROXR.L Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e0b0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 cnt = m68k_dreg (regs, srcreg);
{	uae_s32 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 33) cnt -= 33;
	if (cnt > 0) {
	cnt--;
	{
	uae_u32 carry;
	uae_u32 hival = (val << 1) | GET_XFLG (&regs->ccrflags);
	hival <<= (31 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (&regs->ccrflags, carry);
	val &= 0xffffffff;
	} }
	SET_CFLG (&regs->ccrflags, GET_XFLG (&regs->ccrflags));
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s32)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ROR.L Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e0b8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 cnt = m68k_dreg (regs, srcreg);
{	uae_s32 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt > 0) {	uae_u32 hival;
	cnt &= 31;
	hival = val << (32 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xffffffff;
	SET_CFLG (&regs->ccrflags, (val & 0x80000000) >> 31);
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s32)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ASRW.W (An) */
unsigned long REGPARAM2 CPUFUNC(op_e0d0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr dataa = m68k_areg (regs, srcreg);
{	uae_s16 data = get_word (dataa);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(val)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(val)) < 0) ? 1 : 0);
	SET_CFLG (&regs->ccrflags, cflg);
	COPY_CARRY (&regs->ccrflags);
	put_word (dataa,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* ASRW.W (An)+ */
unsigned long REGPARAM2 CPUFUNC(op_e0d8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr dataa = m68k_areg (regs, srcreg);
{	uae_s16 data = get_word (dataa);
	m68k_areg (regs, srcreg) += 2;
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(val)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(val)) < 0) ? 1 : 0);
	SET_CFLG (&regs->ccrflags, cflg);
	COPY_CARRY (&regs->ccrflags);
	put_word (dataa,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 12;
}
/* ASRW.W -(An) */
unsigned long REGPARAM2 CPUFUNC(op_e0e0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr dataa;
	dataa = m68k_areg (regs, srcreg) - 2;
{	uae_s16 data = get_word (dataa);
	m68k_areg (regs, srcreg) = dataa;
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(val)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(val)) < 0) ? 1 : 0);
	SET_CFLG (&regs->ccrflags, cflg);
	COPY_CARRY (&regs->ccrflags);
	put_word (dataa,val);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 14;
}
/* ASRW.W (d16,An) */
unsigned long REGPARAM2 CPUFUNC(op_e0e8_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr dataa = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 data = get_word (dataa);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(val)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(val)) < 0) ? 1 : 0);
	SET_CFLG (&regs->ccrflags, cflg);
	COPY_CARRY (&regs->ccrflags);
	put_word (dataa,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* ASRW.W (d8,An,Xn) */
unsigned long REGPARAM2 CPUFUNC(op_e0f0_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr dataa;
	m68k_incpc (regs, 2);
{	dataa = get_disp_ea_020 (regs, m68k_areg (regs, srcreg), next_iword (regs));
{	uae_s16 data = get_word (dataa);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(val)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(val)) < 0) ? 1 : 0);
	SET_CFLG (&regs->ccrflags, cflg);
	COPY_CARRY (&regs->ccrflags);
	put_word (dataa,val);
}}}}}return CYCLE_UNIT / 2 * 18;
}
/* ASRW.W (xxx).W */
unsigned long REGPARAM2 CPUFUNC(op_e0f8_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr dataa = (uae_s32)(uae_s16)get_iword (regs, 2);
{	uae_s16 data = get_word (dataa);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(val)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(val)) < 0) ? 1 : 0);
	SET_CFLG (&regs->ccrflags, cflg);
	COPY_CARRY (&regs->ccrflags);
	put_word (dataa,val);
}}}}	m68k_incpc (regs, 4);
return CYCLE_UNIT / 2 * 16;
}
/* ASRW.W (xxx).L */
unsigned long REGPARAM2 CPUFUNC(op_e0f9_0)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr dataa = get_ilong (regs, 2);
{	uae_s16 data = get_word (dataa);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(val)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(val)) < 0) ? 1 : 0);
	SET_CFLG (&regs->ccrflags, cflg);
	COPY_CARRY (&regs->ccrflags);
	put_word (dataa,val);
}}}}	m68k_incpc (regs, 6);
return CYCLE_UNIT / 2 * 20;
}
/* ASL.B #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e100_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 8) {
		SET_VFLG (&regs->ccrflags, (val != 0) ? 1 : 0);
		SET_CFLG (&regs->ccrflags, cnt == 8 ? val & 1 : 0);
		COPY_CARRY (&regs->ccrflags);
		val = 0;
	} else {
		uae_u32 mask = (0xff << (7 - cnt)) & 0xff;
		SET_VFLG (&regs->ccrflags, ((val & mask) != mask && (val & mask) != 0) ? 1 : 0);
		val <<= cnt - 1;
		SET_CFLG (&regs->ccrflags, (val & 0x80) >> 7);
		COPY_CARRY (&regs->ccrflags);
		val <<= 1;
		val &= 0xff;
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s8)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* LSL.B #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e108_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 8) {
		SET_CFLG (&regs->ccrflags, cnt == 8 ? val & 1 : 0);
		COPY_CARRY (&regs->ccrflags);
		val = 0;
	} else {
		val <<= (cnt - 1);
		SET_CFLG (&regs->ccrflags, (val & 0x80) >> 7);
		COPY_CARRY (&regs->ccrflags);
		val <<= 1;
	val &= 0xff;
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s8)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ROXL.B #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e110_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
{	cnt--;
	{
	uae_u32 carry;
	uae_u32 loval = val >> (7 - cnt);
	carry = loval & 1;
	val = (((val << 1) | GET_XFLG (&regs->ccrflags)) << cnt) | (loval >> 1);
	SET_XFLG (&regs->ccrflags, carry);
	val &= 0xff;
	} }
	SET_CFLG (&regs->ccrflags, GET_XFLG (&regs->ccrflags));
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s8)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ROL.B #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e118_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
{	uae_u32 loval;
	cnt &= 7;
	loval = val >> (8 - cnt);
	val <<= cnt;
	val |= loval;
	val &= 0xff;
	SET_CFLG (&regs->ccrflags, val & 1);
}
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s8)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ASL.B Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e120_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 cnt = m68k_dreg (regs, srcreg);
{	uae_s8 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 8) {
		SET_VFLG (&regs->ccrflags, (val != 0) ? 1 : 0);
		SET_CFLG (&regs->ccrflags, cnt == 8 ? val & 1 : 0);
		COPY_CARRY (&regs->ccrflags);
		val = 0;
	} else if (cnt > 0) {
		uae_u32 mask = (0xff << (7 - cnt)) & 0xff;
		SET_VFLG (&regs->ccrflags, ((val & mask) != mask && (val & mask) != 0) ? 1 : 0);
		val <<= cnt - 1;
		SET_CFLG (&regs->ccrflags, (val & 0x80) >> 7);
		COPY_CARRY (&regs->ccrflags);
		val <<= 1;
		val &= 0xff;
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s8)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* LSL.B Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e128_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 cnt = m68k_dreg (regs, srcreg);
{	uae_s8 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 8) {
		SET_CFLG (&regs->ccrflags, cnt == 8 ? val & 1 : 0);
		COPY_CARRY (&regs->ccrflags);
		val = 0;
	} else if (cnt > 0) {
		val <<= (cnt - 1);
		SET_CFLG (&regs->ccrflags, (val & 0x80) >> 7);
		COPY_CARRY (&regs->ccrflags);
		val <<= 1;
	val &= 0xff;
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s8)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ROXL.B Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e130_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 cnt = m68k_dreg (regs, srcreg);
{	uae_s8 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 36) cnt -= 36;
	if (cnt >= 18) cnt -= 18;
	if (cnt >= 9) cnt -= 9;
	if (cnt > 0) {
	cnt--;
	{
	uae_u32 carry;
	uae_u32 loval = val >> (7 - cnt);
	carry = loval & 1;
	val = (((val << 1) | GET_XFLG (&regs->ccrflags)) << cnt) | (loval >> 1);
	SET_XFLG (&regs->ccrflags, carry);
	val &= 0xff;
	} }
	SET_CFLG (&regs->ccrflags, GET_XFLG (&regs->ccrflags));
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s8)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ROL.B Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e138_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 cnt = m68k_dreg (regs, srcreg);
{	uae_s8 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt > 0) {
	uae_u32 loval;
	cnt &= 7;
	loval = val >> (8 - cnt);
	val <<= cnt;
	val |= loval;
	val &= 0xff;
	SET_CFLG (&regs->ccrflags, val & 1);
}
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s8)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ASL.W #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e140_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 16) {
		SET_VFLG (&regs->ccrflags, (val != 0) ? 1 : 0);
		SET_CFLG (&regs->ccrflags, cnt == 16 ? val & 1 : 0);
		COPY_CARRY (&regs->ccrflags);
		val = 0;
	} else {
		uae_u32 mask = (0xffff << (15 - cnt)) & 0xffff;
		SET_VFLG (&regs->ccrflags, ((val & mask) != mask && (val & mask) != 0) ? 1 : 0);
		val <<= cnt - 1;
		SET_CFLG (&regs->ccrflags, (val & 0x8000) >> 15);
		COPY_CARRY (&regs->ccrflags);
		val <<= 1;
		val &= 0xffff;
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s16)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* LSL.W #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e148_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 16) {
		SET_CFLG (&regs->ccrflags, cnt == 16 ? val & 1 : 0);
		COPY_CARRY (&regs->ccrflags);
		val = 0;
	} else {
		val <<= (cnt - 1);
		SET_CFLG (&regs->ccrflags, (val & 0x8000) >> 15);
		COPY_CARRY (&regs->ccrflags);
		val <<= 1;
	val &= 0xffff;
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s16)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ROXL.W #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e150_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
{	cnt--;
	{
	uae_u32 carry;
	uae_u32 loval = val >> (15 - cnt);
	carry = loval & 1;
	val = (((val << 1) | GET_XFLG (&regs->ccrflags)) << cnt) | (loval >> 1);
	SET_XFLG (&regs->ccrflags, carry);
	val &= 0xffff;
	} }
	SET_CFLG (&regs->ccrflags, GET_XFLG (&regs->ccrflags));
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s16)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ROL.W #<data>,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e158_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
{	uae_u32 loval;
	cnt &= 15;
	loval = val >> (16 - cnt);
	val <<= cnt;
	val |= loval;
	val &= 0xffff;
	SET_CFLG (&regs->ccrflags, val & 1);
}
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s16)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* ASL.W Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e160_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 cnt = m68k_dreg (regs, srcreg);
{	uae_s16 data = m68k_dreg (regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV (&regs->ccrflags);
	if (cnt >= 16) {
		SET_VFLG (&regs->ccrflags, (val != 0) ? 1 : 0);
		SET_CFLG (&regs->ccrflags, cnt == 16 ? val & 1 : 0);
		COPY_CARRY (&regs->ccrflags);
		val = 0;
	} else if (cnt > 0) {
		uae_u32 mask = (0xffff << (15 - cnt)) & 0xffff;
		SET_VFLG (&regs->ccrflags, ((val & mask) != mask && (val & mask) != 0) ? 1 : 0);
		val <<= cnt - 1;
		SET_CFLG (&regs->ccrflags, (val & 0x8000) >> 15);
		COPY_CARRY (&regs->ccrflags);
		val <<= 1;
		val &= 0xffff;
	}
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(val)) == 0) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, (((uae_s16)(val)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}	m68k_incpc (regs, 2);
return CYCLE_UNIT / 2 * 4;
}
/* LSL.W Dn,Dn */
unsigned long REGPARAM2 CPUFUNC(op_e168_0)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode 