from dwimd.engine import run_config_modules, run_functions, PlanningException, act
from dwimd.plugins import reload_plugins, get_plugin, init_plugins, get_pluginnames, \
        add_plugin, del_plugin


def setup_module():
    reload_plugins()
    init_plugins()

def test_respect_manual_override():
    class TestModuleAction(object):
        further_names = "a b".split()
        @staticmethod
        def act(values):
            assert "a" in values and "b" in values

    def func():
        vote(a, "c")
        vote(b, "d")
        vote(test, "e")
    add_plugin("actions", "test", TestModuleAction)

    try:
        plan = run_functions([func])
        act(plan)
    finally:
        del_plugin("actions", "test")


