import os
import sys
import logging
import time

import glib
from dbus.mainloop.glib import DBusGMainLoop
import gobject

from dwimd.plugins import reload_plugins, init_plugins
from dwimd.engine import run_config_modules, act


SAMPLING_DELAY = 30 # seconds
PIDFILE = "/var/run/dwimd"
env = None


def run(args):
    sys.path.append("/etc/dwimd/")
    if "-d" in args:
        logging.basicConfig(level=logging.DEBUG)
    if "-D" in args:
        daemonize()
    if "-h" in args:
        print """dwimd, see /etc/dwimd/README.txt for details

Command line options:
    -d      Show debugging info.
    -D      Daemonize.
    -h      This help.
"""
        return

    DBusGMainLoop(set_as_default=True)
    glib.idle_add(startup)
    loop = gobject.MainLoop()
    loop.run()

def startup():
    global env
    logging.debug("Loading plugins ...")
    reload_plugins()
    init_plugins()
    logging.debug("Done loading and initing plugins.")

    try:
        env = run_config_modules()
    except Exception:
        import traceback
        traceback.print_exc()
        raise SystemExit(-1)
    glib.timeout_add_seconds(SAMPLING_DELAY, sampling_func)
    return False


def sampling_func():
    run_config_modules(env)
    act(env)
    return True


def daemonize():
    """ Make the current process a daemon

    See http://www.erlenstar.demon.co.uk/unix/faq_toc.html#TOC16
    """
    if os.fork():   # launch child and...
        os._exit(0) # kill off parent
    os.setsid()
    if os.fork():   # launch child and...
        os._exit(0) # kill off parent again.
    os.umask(0077)
    null = os.open('/dev/null', os.O_RDWR)
    for i in range(3):
        try:
            os.dup2(null, i)
        except OSError, e:
            if e.errno != errno.EBADF:
                raise
    os.close(null)
    pid = str(os.getpid())
    open(PIDFILE, 'wb').write(pid)


if __name__ == "__main__":
    sys.exit(run(sys.argv[1:]))

