# based on code from gpodder
# Portions copyright (c) 2005-2010 Thomas Perl and the gPodder Team

import logging

import dbus
import osso

from dwimd.util import osso_context


orientation_updater = None


def init():
    global orientation_updater
    orientation_updater = OrientationUpdater()


class OrientationUpdater(object):
    _ENABLE_ACCEL = 'req_accelerometer_enable'
    _DISABLE_ACCEL = 'req_accelerometer_disable'

    # Defined in mce/dbus-names.h
    _MCE_SERVICE = 'com.nokia.mce'
    _MCE_REQUEST_PATH = '/com/nokia/mce/request'
    _MCE_REQUEST_IF = 'com.nokia.mce.request'

    def __init__(self):
        self.state = {"orientation": "unknown", "on_stand": False,
                      "face_up": True}
        system_bus = dbus.Bus.get_system()
        system_bus.add_signal_receiver(self._on_orientation_signal,
                signal_name='sig_device_orientation_ind',
                dbus_interface='com.nokia.mce.signal',
                path='/com/nokia/mce/signal')

        # Tell MCE that we need the accelerometer
        self._send_mce_request(self._ENABLE_ACCEL)

    def _send_mce_request(self, request):
        rpc = osso.Rpc(osso_context)
        rpc.rpc_run(self._MCE_SERVICE,
                    self._MCE_REQUEST_PATH,
                    self._MCE_REQUEST_IF,
                    request,
                    use_system_bus=True)

    def _on_orientation_signal(self, orientation, stand, face, x, y, z):
        logging.debug("Seeing state %r" % ((orientation, stand, face), ))
        self.state = {"orientation": orientation, "on_stand": stand == "on_stand",
                      "face_up": face == "face_up"}

def sample():
    return orientation_updater.state
exporting = "orientation on_stand face_up".split()
