import math
import logging
import os
from subprocess import PIPE, Popen


class State(object):
    control = device = None
    locations = {}
    location = None

    def on_changed(self, device, data):
        import location
        if device.fix and device.fix[1] & location.GPS_DEVICE_LATLONG_SET:
            State.location = device.fix[4:6]
            #horizontal accuracy (device.fix[6] / 100)


def sample():
    return {"location": Location()}
exporting = set(("location", ))

def init():
    try:
        import location
    except ImportError:
        pass
    else:
        State.control = location.GPSDControl.get_default()
        State.control.set_properties(preferred_method=location.METHOD_CWP|location.METHOD_ACWP)
        State.device = location.GPSDevice()
        #State.device.connect("changed", on_changed, State.control)
    State.locations.clear()


def define_location(name, **description):
    if not ("network_in_sight" in description or "coordinates" in description):
        raise Exception("Invalid location definition, please use network_in_sight or coordinates!")
    State.locations[name] = description

imported_globals = {"define_location": define_location}


class Location(object):
    def near(self, where, distance=500, default=False):
        where_location = State.locations[where]
        if "coordinates" in where_location:
            if State.location is None:
                logging.error("Please install python-location")
                return default
            lat1, long1, offset = where_location["coordinates"]
            State.on_changed(State.device, None)
            dist = coord_distance(lat1, long1, State.location[0], State.location[1])
            return distance + offset < dist
        elif "network_in_sight" in where_location:
            network = where_location["network_in_sight"]
            return bool(Popen(["iwlist wlan0 scan | grep ESSID:." + network],
                        stdout=PIPE, shell=True).communicate()[0].strip())
        else:
            assert False

    @property
    def unknown(self):
        return State.location is None


def coord_distance(lat1, lng1, lat2, lng2):
    pi80 = math.pi / 180
    lat1 *= pi80
    lng1 *= pi80
    lat2 *= pi80
    lng2 *= pi80
    r = 6372.797 # mean radius of Earth in km
    dlat = lat2 - lat1
    dlng = lng2 - lng1
    a = (math.sin(dlat / 2)**2 +
         math.cos(lat1) * math.cos(lat2) * math.sin(dlng / 2)**2)
    c = 2 * math.atan2(math.sqrt(a), math.sqrt(1 - a))
    km = r * c
    return km

