import logging
import ctypes


try:
    libprofile = ctypes.CDLL("/usr/lib/libprofile.so.0")
except OSError:
    raise ImportError("Cannot find libprofile!")

set_profile = libprofile.profile_set_profile
set_profile.argtypes = (ctypes.c_char_p, )
set_profile.restype = ctypes.c_int

get_profile = libprofile.profile_get_profile
get_profile.argtypes = ()
get_profile.restype = ctypes.c_char_p

get_profiles = libprofile.profile_get_profiles
get_profiles.argtypes = ()
get_profiles.restype = ctypes.POINTER(ctypes.c_char_p)


def act(value):
    logging.debug("Setting profile to " + value)
    res = set_profile(value)
    if res != 0:
        raise ValueError("Error while setting profile " + value)

def read():
    res = get_profile()
    if res is None:
        raise Exception("Internal error while getting profile")
    return res

