
import time

class Logger:

    def __init__(self, debug_mode):
        self.ui = None
        self.debug_mode = debug_mode
        self.span_end = "</style>"
        
    def set_ui(self, ui):
        self.ui = ui

    def span_start(self, color):
        return "<span style=\"color:" + color + ";\">"
    
    def generate_timestamp(self):
        localtime = time.localtime()
        hour = localtime.tm_hour
        if hour < 10:
            hour = "0" + str(hour)
        minute = localtime.tm_min
        if minute < 10:
            minute = "0" + str(minute)
        second = localtime.tm_sec
        if second < 10:
            second = "0" + str(second)
        timestamp = "%s:%s:%s" % (hour, minute, second)
        return timestamp
        
    def join_message(self, msg, param):
        msg_join = msg + " %s" % param
        return msg_join  
        
    def warning(self, message, param = None):
        if param != None:
            message = self.join_message(message, param)
        timestamp = self.generate_timestamp()
        category = "[WARNING]:"
        self.log_stdout(timestamp, category, message)
        html_message = timestamp + " " + self.span_start("#cdbc2a") + category + " " + message + self.span_end
        self.log(html_message)
        
    def error(self, message, param = None):
        if param != None:
            message = self.join_message(message, param)
        timestamp = self.generate_timestamp()
        category = "[ERROR]  :"
        self.log_stdout(timestamp, category, message)
        html_message = timestamp + " " + self.span_start("red") + category + " " + message + self.span_end
        self.log(html_message)
            
    def info(self, message, param = None):
        if param != None:
            message = self.join_message(message, param)
        timestamp = self.generate_timestamp()
        category = "-- [INFO]:"
        self.log_stdout(timestamp, category, message)
        html_message = timestamp + " " + self.span_start("black") + category + " " + message + self.span_end
        self.log(html_message)
        
    def auth(self, message, param = None):
        if param != None:
            message = self.join_message(message, param)
        timestamp = self.generate_timestamp()
        category = "-- [AUTH]:"
        self.log_stdout(timestamp, category, message)
        html_message = timestamp + " " + self.span_start("green") + category + " " + message + self.span_end
        self.log(html_message)
        
    def network(self, message, param = None):
        if param != None:
            message = self.join_message(message, param)
        timestamp = self.generate_timestamp()
        category = "[NETWORK]:"
        self.log_stdout(timestamp, category, message)
        html_message = timestamp + " " + self.span_start("blue") + category + " " + message + self.span_end
        self.log(html_message)
        
    def network_error(self, message, param = None):
        if param != None:
            message = self.join_message(message, param)
        timestamp = self.generate_timestamp()
        category = "[NETWORK ERROR]:"
        self.log_stdout(timestamp, category, message)
        html_message = timestamp + " " + self.span_start("red") + category + " " + message + self.span_end
        self.log(html_message)
         
    def log(self, html_message):
        if self.ui != None:
            self.ui.console_ui.text_area.appendHtml(html_message)
        
    def log_stdout(self, timestamp, category, message):
        if self.debug_mode:
            print "%s DEBUG %s %s" % (timestamp, category, message)

