#include "settings.h"
#include "ui_settings.h"

settings::settings(QWidget *parent, settingsStruct mSett) :
    QDialog(parent),
    ui(new Ui::settings)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif

    sett = mSett;

    ui->comAge->clear();
    for(int i=0; i<150; i++) {
        ui->comAge->addItem(QString::number(i));
    }
    ui->comAge->setCurrentIndex(sett.bodyAge);

    ui->comGender->clear();
    ui->comGender->addItem("male");
    ui->comGender->addItem("female");
    if(sett.bodyGenderIsFemale)
        ui->comGender->setCurrentIndex(1);//female
    else
        ui->comGender->setCurrentIndex(0);//male

    ui->comHeight->clear();
    for(int i=0; i<300; i++) {
        ui->comHeight->addItem(QString::number(i));
    }
    ui->comHeight->setCurrentIndex(sett.bodyHeight);

    ui->comPermille->clear();
    for(float i=0; i<0.20; i+=0.01) {
        ui->comPermille->addItem(QString::number(i));
    }
    ui->comPermille->setCurrentIndex((int)(sett.permillePerHour*100));

    ui->comWeight->clear();
    for(int i=0; i<300; i++) {
        ui->comWeight->addItem(QString::number(i));
    }
    ui->comWeight->setCurrentIndex(sett.bodyWeight);

    ui->comDriveLimit->clear();
    for(float i=0; i<=2; i+=0.1) {
        ui->comDriveLimit->addItem(QString::number(i));
    }
    ui->comDriveLimit->setCurrentIndex(sett.driveLimit*10);

    connect(ui->buttonBox, SIGNAL(accepted()), this, SLOT(accept_clicked()));


}

settings::~settings()
{
    delete ui;
}

void settings::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}


void settings::accept_clicked() {
    sett.bodyAge = ui->comAge->currentIndex();
    sett.bodyGenderIsFemale = ui->comGender->currentIndex();
    sett.bodyHeight = ui->comHeight->currentIndex();
    sett.bodyWeight = ui->comWeight->currentIndex();
    sett.permillePerHour = (float)ui->comPermille->currentIndex()/100;
    sett.driveLimit = (float)ui->comDriveLimit->currentIndex()/10;
}
