#ifndef BILL_H
#define BILL_H

#include <QDialog>
#include <QListWidgetItem>
#include <QTimer>
#include "alcohol.h"

namespace Ui {
    class Bill;
}

struct drinkCountStruct {
    QListWidgetItem *item;
    QPixmap *pix;
    int type;
    int count;
    float *price;
};


class Bill : public QDialog
{
    Q_OBJECT

public:
    Bill(QWidget *parent = 0, QVector<drink> *drinks=0, QVector<drinkDefinition> *drinkDefs=0);
    ~Bill();
    float getSum();
    bool isAccepted();

private:
    Ui::Bill *ui;
    QVector<drinkCountStruct> drinkCountList;
    void showSum();
    void clearList();
    bool accepted;
    bool plus;
    QTimer *btnTimer;

private slots:
    void on_btnMinus_released();
    void on_btnMinus_pressed();
    void on_btnPlus_released();
    void on_btnPlus_pressed();
    void on_buttonBox_accepted();
    void on_txtPrice_textChanged(QString );
    void on_btnMinus_clicked();
    void on_btnPlus_clicked();
    void on_lstDrinks_itemClicked(QListWidgetItem* item);
    void btnTimer_timeout();
};

#endif // BILL_H
