#include "bill.h"
#include "ui_bill.h"

const int btnTimerInterval=200;

Bill::Bill(QWidget *parent, QVector<drink> *drinks, QVector<drinkDefinition> *drinkDefs) :
    QDialog(parent),
    ui(new Ui::Bill)
{
    accepted=false;
    ui->setupUi(this);

    btnTimer = new QTimer(this);
    connect(btnTimer, SIGNAL(timeout()), this, SLOT(btnTimer_timeout()));

    if(drinks==0 || drinkDefs==0)
        return;


    for(int i=0; i<drinks->count(); i++) {
        bool isIncluded=false;

        if(drinks->at(i).type==-1)
            //drinks->at(i).additivePermill=
            drinkCountList.clear();
        else {
            if(drinks->at(i).haveToPay) {
                for(int j=0; j<drinkCountList.count(); j++) {
                    if(drinkCountList.at(j).type == (*drinks).at(i).type ) {
                        drinkCountList[j].count++;
                        isIncluded=true;
                    }
                }
                if(!isIncluded) {
                    drinkCountStruct tmp;
                    tmp.count=1;
                    tmp.type=(*drinks).at(i).type;
                    drinkCountList.append(tmp);
                }
            }
        }
    }

    for(int i=0; i<drinkCountList.count(); i++) {
        drinkCountList[i].item = new QListWidgetItem();
        drinkCountList[i].pix = new QPixmap((*drinkDefs).at( drinkCountList.at(i).type ).filename);
        drinkCountList[i].item->setText( QString::number(drinkCountList.at(i).count) + "x " + (*drinkDefs).at( drinkCountList.at(i).type ).text );
        drinkCountList[i].item->setIcon(*(drinkCountList[i].pix));
        drinkCountList[i].price = &(*drinkDefs)[drinkCountList.at(i).type].price;

        ui->lstDrinks->addItem(drinkCountList[i].item);
    }
    if(drinkCountList.count() > 0) {
        ui->lstDrinks->setCurrentRow(0);
        float tmp = *(drinkCountList.at(ui->lstDrinks->currentRow()).price);
        ui->txtPrice->setText( QString::number( tmp ) );
    }

    showSum();

}

Bill::~Bill()
{
    btnTimer->stop();
    delete btnTimer;
    clearList();
    delete ui;
}


void Bill::clearList() {
    for(int i=0; i<drinkCountList.count(); i++) {
        if(drinkCountList[i].pix!=0)
            delete drinkCountList[i].pix;
        if(drinkCountList[i].item!=0)
            delete drinkCountList[i].item;
    }
    drinkCountList.clear();
}

void Bill::showSum() {
    ui->lblSum->setText("Total Price: " + QString::number(getSum()));
}

float Bill::getSum() {
    float sum=0;
    for(int i=0; i<drinkCountList.count(); i++) {
        sum+= *(drinkCountList.at(i).price) * (float)(drinkCountList.at(i).count);
    }
    return sum;
}

void Bill::on_lstDrinks_itemClicked(QListWidgetItem* item)
{
    float tmp = *(drinkCountList.at(ui->lstDrinks->currentRow()).price);
    ui->txtPrice->setText( QString::number( tmp ) );
}

void Bill::on_btnPlus_clicked()
{
    float tmp = ui->txtPrice->text().toFloat();
    tmp+=0.1;
    ui->txtPrice->setText( QString::number( tmp ) );
}

void Bill::on_btnMinus_clicked()
{
    float tmp = ui->txtPrice->text().toFloat();
    if(tmp>0) {
        tmp-=0.1;
        ui->txtPrice->setText( QString::number( tmp ) );
    }

    if(tmp<0.1)
        ui->txtPrice->setText("0");
}

void Bill::on_txtPrice_textChanged(QString )
{
    *(drinkCountList.at(ui->lstDrinks->currentRow()).price) = ui->txtPrice->text().toFloat();
    showSum();
}

void Bill::on_buttonBox_accepted()
{
    accepted=true;
}

bool Bill::isAccepted() {
    return accepted;
}

void Bill::btnTimer_timeout() {
    if(plus)
        on_btnPlus_clicked();
    else
        on_btnMinus_clicked();
}

void Bill::on_btnPlus_pressed()
{
    plus=true;
    btnTimer->start(btnTimerInterval);
}

void Bill::on_btnPlus_released()
{
    btnTimer->stop();
}

void Bill::on_btnMinus_pressed()
{
    plus=false;
    btnTimer->start(btnTimerInterval);
}

void Bill::on_btnMinus_released()
{
    btnTimer->stop();
}
