#ifndef ALCOHOL_H
#define ALCOHOL_H

#include <QPixmap>
#include <QPushButton>
#include <QTime>


struct drinkDefinition {
    int amountMl;
    int percentage;
    QString text;
    QString filename;
};

struct drink {
    int type;
    QTime time;
    time_t unixTime;
    QPushButton *btn;
    float additivePermill;
    bool haveToPay;
    bool addsPermill;
};

struct settingsStruct {
    int bodyWeight, bodyHeight, bodyAge;
    float permillePerHour;
    float driveLimit;
    bool bodyGenderIsFemale;
};



class Alcohol
{
public:
    Alcohol(QVector<drink> *drinks, QVector<drinkDefinition> *drinkDefs, QVector<float> *timeLine, settingsStruct *sett);

    float calcAlc(int drinkType);
    void calcTimeLine();
    QPixmap *drawDiagram(int width, int height);
    int getTimeLineCount();
    int getTimeToDrive();

private:
    QVector<drink> *m_drinks;
    QVector<drinkDefinition> *m_drinkDefs;
    QVector<float> *m_timeLine;
    settingsStruct *m_sett;
};

#endif // ALCOHOL_H
