import QtQuick 1.1
import QtMobility.sensors 1.1
import "qml"
import "script.js" as Sd
//480*(854-36)
Item {
    id:mainPage
    property int tim:0;
    Rectangle {
        x:0;y:0;z:10;
        width:parent.width;height:parent.height;
        Image{id: bg;anchors.fill:parent;fillMode:Image.Tile;source:"img/bg.png";}
        Rectangle{id:welcome;
            z:11;
            anchors.fill:parent;
            color: "#00ffffff";
            Image{id:logo;x:43;y:60;source: "img/doodlejump.png";}
            Image {id:author;x:157;y:175;source: "img/author.png";}
            //昆虫背景
            Image {x: 354;y:302;source: "img/bg01.png";}
            Image {x: 125;y:582;source: "img/bg02.png";}
            Image {x: 45;y:433;source: "img/bg03.png";}
            Image {x: 113;y:203;source: "img/bg04.png";}
            Image {x: 222;y:69;source: "img/bg05.png";}

            Image{id:play;x:27;y:307;source:"img/play.png";
                MouseArea{
                    anchors.fill:parent;
                    onClicked:{
                        Sd.playGame();
                    }
                }
            }
            Image{id:rank;x:250;y:440;source:"img/rank.png";
                MouseArea{
                    anchors.fill:parent;
                    onClicked:{Sd.showRank();}
                }}
            Image{id:opinion;x:250;y:570;source:"img/opinion.png";}
            Image{id:about;x:250;y:700;source:"img/about.png";
                MouseArea{
                    anchors.fill:parent;
                    onClicked:{myDia.show(""+
                                        "\tDoodle Jump for N900\n\n"+
                                        "    此版本是仿制安卓版的涂鸦跳跃\n"+
                                        "所制作,在此感谢原作者的创意.\n"+
                                        "    本软件为Qt开发,下载请认准本人\n"+
                                        "百度网盘(ID:蝉曦)下载,由其他地址\n"+
                                        "下载而得的造成扣费,本人不负任何\n"+
                                        "责任.\n"+
                                        "\n\tAuthor:蝉曦\n"+
                                        "\tFeedback:百度蝉曦吧\n")
                    }
                }
            }

            Image{id:ren0;x:60;y: 655;source: "img/right1.png"}
            Image{x:62;y:750;source:"img/01.png";}
        }
        Rectangle {id:rankDiv
            x:0;y:0;
            width:parent.width;height:parent.height;
            color: "#00ffffff";
            visible: false;
            Text {id: rankTxt1
                x: 50;y: 80;
                width: 200;height: 400;text: "";
                styleColor: "#888833";horizontalAlignment: Text.AlignRight;font.pixelSize:40;
            }
            Text {id: rankTxt2
                x: 250;y: 80;
                width: 200;height: 400;text: "";
                styleColor: "#888833";horizontalAlignment: Text.AlignLeft;font.pixelSize:40;
            }

            Image {id: back
                x: 128;y: 695
                source: "img/menu.png"
                MouseArea{
                    anchors.fill:parent;
                    onClicked:{Sd.backMenu();}
                }
            }
        }
        Rectangle{id:gameDiv;
            z:11;
            anchors.fill:parent;
            color: "#00ffffff";
            visible: false;
            Rectangle{id:sorcebg;
                x:0;y:0;z:15;
                width: parent.width;
                height: 40;
                Image{id:bg2;x:0;y:-10;source: "img/bg2.png";}
                Text{id:scoreTxt;x:80;y:0;font.pixelSize:30;text: "Score:0";}
                Label{id:ratioLb;x:360;y:0;width:60;height:40;font.pixelSize:30;text: "0-0"}
                Image{id:pause;x:420;y:0;source:"img/pause.png";
                    MouseArea{
                        anchors.fill:parent;
                        onClicked:{
                            Sd.pauseGame()
                        }
                    }
                }
            }
            Image{id:ren;x:200;y:700;z:20;source: "img/right2.png";}
            Rectangle {id:pauseDiv
                x:0;y:0;z:20;
                width:parent.width;height:parent.height;
                color: "#bb000000";
                visible:false;
                Image{id:resume;x:200;y:582;source:"img/resume.png";
                    MouseArea{
                        anchors.fill:parent;
                        onClicked:{Sd.resumeGame();}
                    }
                }
                //昆虫背景
                Image {x: 354;y:302;source: "img/bg01.png";}
                Image {x: 125;y:582;source: "img/bg02.png";}
                Image {x: 45;y:433;source: "img/bg03.png";}
                Image {x: 113;y:203;source: "img/bg04.png";}
                Image {x: 222;y:69;source: "img/bg05.png";}
            }
            Rectangle {id:gameoverDiv
                x:0;y:1400;
                width:parent.width;height:parent.height;
                color: "#00ffffff";
                Image{id:gameover;x:parent.width/2-gameover.width/2;y:60;source: "img/gameover.png";}
                Image{id:gameover2;
                    x:parent.width/2-gameover2.width/2;y:182;source: "img/gameover2.png";
                    Label {id:scoreLb;x:278;y:7;width:200;height:20;text: "0";}
                    Label {id:scoreHightLb;x:278;y:67;width:200;height:20;text: "0";}
                    Label {id:playerName;x:169;y:123;width:150;height:35;text: "Doodle";}

                }
                Image{id:rePlay;x:parent.width/2+20;y:582;source:"img/replay.png";
                    MouseArea{
                        anchors.fill:parent;
                        onClicked:{Sd.rePlayGame();Sd.playGame();}
                    }
                }
                Image{id:menu;x:parent.width/2-menu.width-20;y:582;source:"img/menu.png";
                    MouseArea{
                        anchors.fill:parent;
                        onClicked:{Sd.showMenu();}
                    }
                }
            }
        }

        Text{id:rsTxt;
            x:10;y:0;z:16;
            font.pixelSize:30;
           // text: "y:";
        }
        RotationSensor{
             id: rs
             active: true
             onReadingChanged: {
                 //rsTxt.text="x:"+reading.x+",y:"+reading.y+",z:"+reading.z;
                // rsTxt.text="y:"+ -reading.x;
             }
        }
    }
    //“关于”弹窗
    Dialog{
        id:myDia
        anchors.centerIn: parent
        z: 22;
    }
    //定时器
    Timer{
        id:mTimer
        interval: 25;
        running: true;
        repeat: true
        onTriggered: {
            Sd.scile();
        }
    }

    Timer{
        id: blankingTimer
        interval: 50000;
        running: true;
        repeat: true
        onTriggered: {
            viewer.unPauseDisplay()
        }
    }

    Connections {
        target: viewer
        onShowSignal: {
            if(pauseDiv.visible != true)
                 mTimer.running = true
        }
        onHideSignal: {
            Sd.pauseGame()
            mTimer.running = false  //
            blankingTimer.stop()
        }
    }
}
