// -------------------------------------------------------------------
// gAjax RSS Ticker- By Dynamic Drive, available at: http://www.dynamicdrive.com
// Created: Aug 2nd, 2007 Updated: n/a
// REQUIRES: gfeedfetcher.js class, available at http://dynamicdrive.com/dynamicindex18/gajaxrssdisplayer.htm
// -------------------------------------------------------------------

var gfeedfetcher_loading_image="indicator.gif" //Specify full URL to "loading" image. Overwrites same var from gfeedfetcher.js


function gfeedrssticker(divid, divClass, delay, linktarget){
	this.tickerid=divid //ID of ticker div
	this.delay=parseInt(delay) //Default delay between msg change, in miliseconds.
	this.mouseoverBol=0 //Boolean to indicate whether mouse is currently over ticker (and pause it if it is)
	this.itemsperpage=1 //Entries to show per page
	this.messagepointer=0
	gfeedfetcher.call(this, divid, divClass, linktarget) //inherit properties from "gfeedfetcher" class and also use DIV generated by "gfeedfetcher"
	this.itemcontainer="<div>" //default element wrapping around each RSS entry
	this.tickerdiv=document.getElementById(divid)
}

gfeedrssticker.prototype=new gfeedfetcher //inherit methods from gfeedfetcher class
gfeedrssticker.prototype.constructor=gfeedrssticker
gfeedrssticker.prototype._displayresult=null //Remove inherited method "_displayresult()"


// -------------------------------------------------------------------
// entries_per_page()- Sets the number of RSS entries to display per page (at once)
// -------------------------------------------------------------------

gfeedrssticker.prototype.entries_per_page=function(num){
	this.itemsperpage=num
}

// -------------------------------------------------------------------
// _signaldownloadcomplete()- Signals to the rest of the script when the fetching of all RSS feeds is complete
// -------------------------------------------------------------------

gfeedrssticker.prototype._signaldownloadcomplete=function(){ //overwrite inherited method "_signaldownloadcomplete()"
	this.feedsfetched+=1
	if (this.feedsfetched==this.feedurls.length) //if all feeds fetched
		this._initscroller(this.feeds) //Populate the two DIVs within scroller with the fetched data
}

// -------------------------------------------------------------------
// _initscroller()- Initialize the ticker by populating it with the first batch of RSS feeds, and prepare to rotate it
// -------------------------------------------------------------------

gfeedrssticker.prototype._initscroller=function(feeds){
	var scrollerinstance=this
	gfeedfetcher._sortarray(feeds, this.sortstring)
	this.itemsperpage=(this.itemsperpage>=feeds.length)? 1 : this.itemsperpage //Adjust "itemsperpage" if needed (based on total # of avail entries)
	var feedslice=feeds.slice(this.messagepointer, this.itemsperpage) //Get subsection of feed array based on how many entries to show at once
	this.tickerdiv.innerHTML=formatrssmessage(feedslice, this.showoptions, this.itemcontainer, this.linktarget)
	this.tickerdiv.onmouseover=function(){scrollerinstance.mouseoverBol=1}
	this.tickerdiv.onmouseout=function(){scrollerinstance.mouseoverBol=0}
	this.messagepointer=this.itemsperpage //increment message pointer
	if (window.attachEvent) //Clean up loose references in IE
		window.attachEvent("onunload", function(){scrollerinstance.tickerdiv.onmouseover=scrollerinstance.tickerdiv.onmouseout=null})
	setTimeout(function(){scrollerinstance._rotatemessage()}, this.delay)
}


// -------------------------------------------------------------------
// formatrssmessage()- Global function that formats a RSS entry(s) to the desired components (title, date, description etc)
// -------------------------------------------------------------------

function formatrssmessage(feedslice, showoptions, itemcontainer, linktarget){
	var rssoutput=(itemcontainer=="<li>")? "<ul>\n" : "" //if "itemcontainer" is set to "<li>", define a "<ul>" tag to wrap around the result
	for (var i=0; i<feedslice.length; i++){ //Loop through the entered slice of a RSS feed (1 or more entries)
		var itemtitle="<a href=\"" + feedslice[i].link + "\" target=\"" + linktarget + "\" class=\"titlefield\">" + feedslice[i].title + "</a>"
		var itemlabel=/label/i.test(showoptions)? '<span class="labelfield">['+feedslice[i].ddlabel+']</span>' : " "
		var itemdate=gfeedfetcher._formatdate(feedslice[i].publishedDate, showoptions)
		var itemdescription=/description/i.test(showoptions)? "<br />"+feedslice[i].content : /snippet/i.test(showoptions)? "<br />"+feedslice[i].contentSnippet  : ""
		rssoutput+=itemcontainer + itemtitle + " " + itemlabel + " " + itemdate + "\n" + itemdescription + itemcontainer.replace("<", "</") + "\n\n"
	}
	rssoutput+=(itemcontainer=="<li>")? "</ul>\n" : ""
	return rssoutput
}


// -------------------------------------------------------------------
// _rotatemessage()- Rotates the ticker with the next batch of RSS entries, plus update message pointer
// -------------------------------------------------------------------

gfeedrssticker.prototype._rotatemessage=function(){
	var scrollerinstance=this
	if (this.mouseoverBol==1) //if mouse is currently over scoller, do nothing (pause it)
		setTimeout(function(){scrollerinstance._rotatemessage()}, 100)
	else{
		var feedslice=this.feeds.slice(this.messagepointer, this.messagepointer+this.itemsperpage)
		this.tickerdiv.innerHTML=formatrssmessage(feedslice, this.showoptions, this.itemcontainer, this.linktarget)
		this.messagepointer=(this.messagepointer+this.itemsperpage > this.feeds.length-1)? 0 : this.messagepointer+this.itemsperpage
		setTimeout(function(){scrollerinstance._rotatemessage()}, this.delay)
	}
}