/*
    Copyright 2010 Marcello V. Mansueto <marcello.m@yahoo.com>

    This file is part of dlh.

    dlh is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    dlh is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with dlh.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <QtSql>

#include "start.h"
#include "ui_start.h"

Start::Start(QWidget *parent) :
    QWidget(parent),
    m_ui(new Ui::Start)
{
    qDebug() << "Start widget constructor";
    start = QDateTime::currentDateTime();
    isCustomTimeEnabled = false;

    m_ui->setupUi(this);

    m_ui->startTimeEdit->setDateTime(QDateTime::currentDateTime());
    m_ui->endTimeEdit->setDateTime(QDateTime::currentDateTime());
    m_ui->weightBeforeEdit->setInputMask("009.000");
    m_ui->weightAfterEdit->setInputMask("009.000");
    m_ui->mlBeforeEdit->setInputMask("009.000");
    m_ui->mlAfterEdit->setInputMask("009.000");
    connect(m_ui->startFinish, SIGNAL(clicked()), this, SLOT(finish()));
    connect(m_ui->checkBox, SIGNAL(toggled(bool)), this, SLOT(enableCustomTime(bool)));
}

Start::~Start()
{
    qDebug() << "Start widget destructor";
    delete m_ui;
}

void Start::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void Start::finish() {
    QSqlQuery query;
    QDateTime end;
    if (isCustomTimeEnabled) {
        start = m_ui->startTimeEdit->dateTime();
        end = m_ui->endTimeEdit->dateTime();
    } else {
        end = QDateTime::currentDateTime();
    }
    QString command =
            QString("insert into dlh values ('%1', '%2', %3, %4, %5, %6, %7, %8)")
                .arg(start.toString())
                .arg(end.toString())
                .arg(m_ui->weightBeforeEdit->text())
                .arg(m_ui->weightAfterEdit->text())
                .arg(m_ui->weightAfterEdit->text().toFloat()-m_ui->weightBeforeEdit->text().toFloat())
                .arg(m_ui->mlBeforeEdit->text())
                .arg(m_ui->mlAfterEdit->text())
                .arg(m_ui->mlBeforeEdit->text().toFloat()-m_ui->mlAfterEdit->text().toFloat());
    query.exec(command);
    close();
}

void Start::enableCustomTime(bool state) {
    m_ui->startTimeEdit->setEnabled(state);
    m_ui->endTimeEdit->setEnabled(state);
    isCustomTimeEnabled = state;
}

void Start::closeEvent(QCloseEvent *event)
 {
    qDebug() << "Closing start widget";
    emit widgetClosed();
    event->accept();
 }
