#include "dclocksettings.h"
#include <QSettings>
#include <QVariant>
#include <QPoint>
#include <QFileInfo>

/*It's better to use QCoreApplication::setOrganizationName(), QCoreApplication::setOrganizationDomain(),
and QCoreApplication::setApplicationName(). And then only use QSettings() in any place.
But this solution is based on incapsulation strategy, and therefore if this code become a part of lib
and will be used in app without setted appropriate values for application and organization names, then it would probably
 cause some problems */

static const QString organizationName = QString("Avis");
static const QString applicationName = QString("DigiClock");


//get widget size;
QSize dclocksettings::getSize(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    //return widget size
    int wdth = sett.value("WidgetWidth",300).toInt();
    int hgth = sett.value("WidgetHeight",80).toInt();
    sett.endGroup();
    return QSize(wdth, hgth);
}

//set widget size;
void dclocksettings::setSize(const QString &aAplletId,const QSize &aSize) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("WidgetWidth",aSize.width());
    sett.setValue("WidgetHeight",aSize.height());
    sett.endGroup();
}

//get color of digits
QColor dclocksettings::getColor(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    //return widget size
    sett.beginGroup(aAplletId);
    int r = sett.value("DigitsColorR",255).toInt();
    int g = sett.value("DigitsColorG",255).toInt();
    int b = sett.value("DigitsColorB",255).toInt();
    int a = sett.value("DigitsColorA",255).toInt();
    sett.endGroup();
    return QColor(r,g,b,a);
}

//set color of digits
void dclocksettings::setColor(const QString &aAplletId, const QColor &aColor) const
{
    QSettings sett(organizationName,applicationName);
    int r = aColor.red();
    int g = aColor.green();
    int b = aColor.blue();
    int a = aColor.alpha();
    sett.beginGroup(aAplletId);
    sett.setValue("DigitsColorR",r);
    sett.setValue("DigitsColorG",g);
    sett.setValue("DigitsColorB",b);
    sett.setValue("DigitsColorA",a);
    sett.endGroup();
}

//get show seconds flag
bool dclocksettings::isShowSeconds(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    //return widget size
    sett.beginGroup(aAplletId);
    return sett.value("ShowSeconds",true).toBool();
}

//set show seconds flag
void dclocksettings::setShowSeconds(const QString &aAplletId, const bool &aShow) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("ShowSeconds",aShow);
    sett.endGroup();
}

//get time format
int dclocksettings::getTimeFormat(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    //return widget size
    sett.beginGroup(aAplletId);
    return sett.value("TimeFormat",0).toInt();
}

//set time format
void dclocksettings::setTimeFormat(const QString &aAplletId,const int &aFormatIdx) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("TimeFormat",aFormatIdx);
    sett.endGroup();
}

//get LCD
bool dclocksettings::isLcd(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    //return widget size
    sett.beginGroup(aAplletId);
    return sett.value("LcdFormat",true).toBool();
}

//set LCD
void dclocksettings::setLcd(const QString &aAplletId,const bool &aLcd) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("LcdFormat",aLcd);
    sett.endGroup();
}

//get font
QFont dclocksettings::getFont(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    //return widget size
    QFont fnt;
    sett.beginGroup(aAplletId);
    fnt.setFamily(sett.value("FontFamily",QString("Helvetica")).toString());
    fnt.setBold(sett.value("FontBold",false).toBool());
    fnt.setItalic(sett.value("FontItalic",false).toBool());
    sett.endGroup();
    return fnt;
}

//set font
void dclocksettings::setFont(const QString &aAplletId,const QFont &aFont) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("FontFamily",aFont.family());
    sett.setValue("FontBold",aFont.bold());
    sett.setValue("FontItalic",aFont.italic());
    sett.endGroup();
}

//get blinking
bool dclocksettings::isBlinking(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    return sett.value("DelimBlinking",true).toBool();
}

//set blinking
void dclocksettings::setBlinking(const QString &aAplletId,const bool &aBlink) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("DelimBlinking",aBlink);
    sett.endGroup();
}

//get time zone
int dclocksettings::getTZoffset(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
//    return sett.value("TimeZoneOffset",-50000).toInt();
    return sett.value("TimeZoneOffset",-1).toInt();    // city index
}

//set time zone
void dclocksettings::setTZoffset(const QString &aAplletId,const int &aOffset) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("TimeZoneOffset",aOffset);
    sett.endGroup();
}

//get transparency
int dclocksettings::getTransparency(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    return sett.value("Transparency",255).toInt();
}

//set transparency
void dclocksettings::setTransparency(const QString &aAplletId, const int &aTrans) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("Transparency",aTrans);
    sett.endGroup();
}

//get rotatable
//TODO new rotate feature
int dclocksettings::getRotatePolicy(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    return sett.value("Rotatable",1).toInt();
}

//set rotatable
void dclocksettings::setRotatePolicy(const QString &aAplletId, const int &aRotate) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("Rotatable",aRotate);
    sett.endGroup();
}

//get open clock
bool dclocksettings::isOpenClockEnabled(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    return sett.value("OpenClock",true).toBool();
}

//set open clock
void dclocksettings::setOpenClockEnabled(const QString &aAplletId, const bool &aOpenClock) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("OpenClock",aOpenClock);
    sett.endGroup();
}

//get time zone index
int dclocksettings::getTZindex(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    return sett.value("TimeZoneIndex",-1).toInt();
}

//set time zone index
void dclocksettings::setTZindex(const QString &aAplletId, const int &aIndex) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("TimeZoneIndex",aIndex);
    sett.endGroup();
}

//get time zone city
QString dclocksettings::getTZcity(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    return sett.value("TimeZoneCity","unknown").toString();
}

//set time zone city
void dclocksettings::setTZcity(const QString &aAplletId, const QString &aCity) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("TimeZoneCity",aCity);
    sett.endGroup();
}

//get show city
bool dclocksettings::isShowCityEnabled(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    return sett.value("ShowCityName",false).toBool();
}

//set show city
void dclocksettings::setShowCityEnabled(const QString &aAplletId, const bool &aShow) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("ShowCityName",aShow);
    sett.endGroup();
}

//get city size
int dclocksettings::getCitySize(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    return sett.value("CitySize",20).toInt();
}

//set city size
void dclocksettings::setCitySize(const QString &aAplletId, const int &aSize) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("CitySize",aSize);
    sett.endGroup();
}

//get Corner Number
int dclocksettings::getCornerNumber(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    return sett.value("CornerNumber",1).toInt();
}

//set Corner Number
void dclocksettings::setCornerNumber(const QString &aAplletId, const int &aNumber) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("CornerNumber",aNumber);
    sett.endGroup();
}


//get show date
bool dclocksettings::isShowDateEnabled(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    return sett.value("ShowDate",false).toBool();
}

//set show date
void dclocksettings::setShowDateEnabled(const QString &aAplletId, const bool &aShow) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("ShowDate",aShow);
    sett.endGroup();
}

//get full date format
bool dclocksettings::isFullDateFormat(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    return sett.value("FullDate",false).toBool();
}

//set full date format
void dclocksettings::setFullDateFormat(const QString &aAplletId, const bool &aFull) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("FullDate",aFull);
    sett.endGroup();
}

//get date size
int dclocksettings::getDateSize(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    return sett.value("DateSize",20).toInt();
}

//set date size
void dclocksettings::setDateSize(const QString &aAplletId, const int &aSize) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("DateSize",aSize);
    sett.endGroup();
}

//get widget's position
// to remember widget's position when it's removed from today
/*QPoint dclocksettings::getPosition(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    int x = sett.value("PositionX",0).toInt();
    int y = sett.value("PositionY",0).toInt();
    sett.endGroup();
    return QPoint(x,y);
}

//set widget's position
void dclocksettings::setPosition(const QString &aAplletId, const QPoint &aPos) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("PositionX",aPos.x());
    sett.setValue("PositionY",aPos.y());
    sett.endGroup();
}
*/

//TODO new functions
//get image
QString dclocksettings::getImageFile(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    QString defFile(":/back.png");
    QString locFile = sett.value("ImageFile",defFile).toString();
    QFileInfo fi (locFile);
    if (fi.exists())
        return locFile;
    else
        return defFile;
}

//set image
void dclocksettings::setImageFile(const QString &aAplletId, const QString &aFile) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("ImageFile",aFile);
    sett.endGroup();
}
