#include <QtGui>
#include <QLocale>
#include <QtDBus/QtDBus>

#include "digitalclockwdg.h"
#include "settingsdialog.h"
#include "dclocksettings.h"
#include "lcdclock.h"
#include "fontclock.h"

DigitalClockWdg::DigitalClockWdg(QWidget *parent)
    : QWidget(parent)
{

    setWindowTitle(tr("Digital Clock"));
    resize(150, 60);
//    setWindowOpacity();
    setAttribute(Qt::WA_TranslucentBackground);
    clk1 = new QWidget(this);
    m_timer = new QTimer(this);
    connect(m_timer, SIGNAL(timeout()), this, SLOT(showTime()));
    loadSettings();
    initClock();
}

void DigitalClockWdg::initClock()
{
    delete clk1;
    QTime tm = calcTime();
    QString tStr = tm.toString(m_timeFormat);
    if (m_lcd)
    {
//        clk1 = new LcdClock(m_digitColor, m_timeFormat, m_blinking1, m_blinking2, this);
        clk1 = new LcdClock(m_digitColor, tStr, this);
        connect(this,SIGNAL(updateClock(QString)),clk1,SLOT(showTime(QString)));
        clk1->show();
//        m_lcd = false;
    }
    else
    {
//        clk1 = new FontClock(m_digitColor, m_timeFormat, m_font, m_blinking1, m_blinking2, this);
        clk1 = new FontClock(m_digitColor, m_font, tStr, this);
        connect(this,SIGNAL(updateClock(QString)),clk1,SLOT(showTime(QString)));
        clk1->show();
//        lcd = true;
    }
}

QTime DigitalClockWdg::calcTime()
{
    if (m_tzOffset == -50000)
        return QTime::currentTime();
    else
    {
        QDateTime dt = QDateTime::currentDateTime();
        QDateTime udt = dt.toUTC();
        dt = udt.addSecs(m_tzOffset);
        return dt.time();
    }
}

void DigitalClockWdg::showTime()
{
    //TODO update clock
    QTime tt = calcTime();

//    QTime time = QTime::currentTime();
    QString text = tt.toString(m_timeFormat);
    if (m_blinking1)
    {
        int lngt = text.length();
        if ((tt.second() % 2) == 0)
        {
            text[lngt-m_blinking1] = ' ';
            if (m_blinking2)
                text[lngt-m_blinking2] = ' ';
        }
    }
    emit updateClock(text);
}

void DigitalClockWdg::showSettingsDialog()
    {
    SettingsDialog dialog(0);
    if (dialog.exec() == QDialog::Accepted) {

        dialog.dumpSettings();
        loadSettings();
    }
}

void DigitalClockWdg::loadSettings()
{
    m_digitColor = dclocksettings::getInstance().getColor();
    bool showSeconds = dclocksettings::getInstance().getShowSeconds();
    int timeFormatIdx = dclocksettings::getInstance().getTimeFormat();
    m_size = dclocksettings::getInstance().getSize();
    bool blinking = dclocksettings::getInstance().getBlinking();
    m_blinking1 = 0;
    m_blinking2 = 0;

//    QString timeFormat;
    if (showSeconds)
        switch (timeFormatIdx)
        {
            case 1:     // 12 H (AM/PM)
                m_timeFormat = QString(" h:mm:ss ap");
                if (blinking)
                {
                    m_blinking1 = 6;
                    m_blinking2 = 9;
                }
                break;
            case 2:     // mmilitary
                m_timeFormat = QString("HHmmss");
                break;
            default:    // 24 H
                m_timeFormat = QString("HH:mm:ss");
                if (blinking)
                {
                    m_blinking1 = 3;
                    m_blinking2 = 6;
                }
            }
    else
        switch (timeFormatIdx)
        {
            case 1:     // 12 H (AM/PM)
                m_timeFormat = QString(" h:mm ap");
                if (blinking)
                {
                    m_blinking1 = 6;
                }
                break;
            case 2:     // mmilitary
                m_timeFormat = QString("HHmm");
                break;
            default:    // 24 H
                m_timeFormat = QString("HH:mm");
                if (blinking)
                {
                    m_blinking1 = 3;
                }

        }

    m_lcd = dclocksettings::getInstance().getLcd();
    m_font = dclocksettings::getInstance().getFont();
    m_tzOffset = dclocksettings::getInstance().getTZoffset();

    m_timer->stop();
    m_timer->start(1000);
    int x = geometry().x();
    int y = geometry().y();
    setGeometry(x,y,m_size.width(),m_size.height());
    initClock();
}

void DigitalClockWdg::homeScreenChanged(bool isOnCurrentHomescreen)
{
    if (isOnCurrentHomescreen)
    {
        if (!m_timer->isActive())
//            m_timer->start(m_timer_tick);
            m_timer->start(1000);
        showTime();
    }
    else
        m_timer->stop();
}


void DigitalClockWdg::mouseReleaseEvent ( QMouseEvent * e )
{
    Q_UNUSED(e);
    //test Dialogs
    if ((m_mouseClick) && (e->pos() == m_lastPoint) )
    {
        showClock();
    }
}

void DigitalClockWdg::mousePressEvent ( QMouseEvent * e )
{
//    Q_UNUSED(e);
    m_lastPoint = e->pos();
    m_mouseClick = true;
}
/*
void DigitalClockWdg::mouseMoveEvent ( QMouseEvent * e )
{
    Q_UNUSED(e);
    m_mouseClick = false;
}
*/
void DigitalClockWdg::showClock()
{
    QDBusConnection bus = QDBusConnection::sessionBus();
    QDBusInterface dbus_iface("com.nokia.HildonDesktop.AppMgr", "/com/nokia/HildonDesktop/AppMgr",
                          "com.nokia.HildonDesktop.AppMgr", bus);
    dbus_iface.call("LaunchApplication","worldclock");
}
