import gobject
import glib
import gtk
import hildondesktop
import hildon
import dbus
import gnome.gconf as gconf
import diggapi
import pango
import cairo

PATH = "/apps/digghomewidget"
KEY = "/apps/digghomewidget/selected_category"

class DiggItemWidget(hildon.Button):
    def __init__(self, item):
#        print inspect.getsourcelines(hildon.Button)
        hildon.Button.__init__(self, gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
#        self.set_app_paintable(True)
        self.item = item
        self.retval = self.connect("expose_event", self.expose)
        self.connect("clicked", self.click)

    def expose(self, widget, event):
        self.context = widget.window.cairo_create()
        self.context.rectangle(event.area.x, event.area.y,
                            event.area.width, event.area.height)

#        widget.draw_rectangle(self.context, True, 0, 0, 10, 10)
        self.context.clip()
        self.draw(self.context)
        return self.retval

    def draw(self, context):
#        print self.get_children()
        rect = self.get_allocation()
        context.rectangle(rect.x, rect.y, rect.width, rect.height)
#        print rect.height
#        if self.state == 1:
#            context.set_source_rgb(0.7, 0.4, 0.3)
#        else: 
        context.set_source_rgb(1,1,1)
        context.fill()
        offset = 5
        if self.item.thumbnail != None:
            loader = gtk.gdk.PixbufLoader()
            loader.write(self.item.thumbnail)
            loader.close()
            offset = 70
            img = loader.get_pixbuf()
            img = img.scale_simple(54,54, gtk.gdk.INTERP_NEAREST)
            context.set_source_pixbuf(img, rect.x+8, rect.y+8)
            context.paint()
            context.rectangle(rect.x+5, rect.y+5, 60, 60)
            context.set_source_rgb(0.3, 0.3, 0.8)
            context.stroke()
        layout = context.create_layout()
        layout.set_text(self.item.title)
        layout.set_font_description(pango.FontDescription("Arial 13"))
        layout.set_wrap(pango.WRAP_WORD_CHAR)
        context.set_source_rgb(0.1, 0.3, 0.6)
        context.move_to(rect.x+offset, rect.y)
        layout.set_width(pango.SCALE*(300-offset))
#        print layout.get_pixel_size()
        if layout.get_line_count() > 2:
            layout.set_font_description(pango.FontDescription("Arial 11"))
        context.show_layout(layout)
        subtitle = context.create_layout()
        subtitle.set_text(self.item.diggs + " diggs, " + self.item.topic)
        subtitle.set_font_description(pango.FontDescription("Arial 10"))
        subtitle.set_wrap(pango.WRAP_WORD_CHAR)
        context.set_source_rgb(0.6, 0.6, 0.6)
        context.move_to(rect.x+offset, rect.y+rect.height-20)
        subtitle.set_width(pango.SCALE*(300-offset))
        context.show_layout(subtitle)


    def click(self, widget):
        bus = dbus.SystemBus()
        proxy = bus.get_object("com.nokia.osso_browser", 
                               "/com/nokia/osso_browser/request")
        int = dbus.Interface(proxy, dbus_interface="com.nokia.osso_browser")
        int.load_url(self.item.href)
        self.show_all()
                
class CustomButton(hildon.Button):
    def __init__(self, icon):
#        print inspect.getsourcelines(hildon.Button)
        hildon.Button.__init__(self, gtk.HILDON_SIZE_AUTO_WIDTH, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.icon = icon
        self.set_size_request(150, 30)
        self.retval = self.connect("expose_event", self.expose)
        
    def expose(self, widget, event):
        self.context = widget.window.cairo_create()
        self.context.rectangle(event.area.x, event.area.y,
                            event.area.width, event.area.height)

        self.context.clip()
        rect = self.get_allocation()
        self.context.rectangle(rect.x, rect.y, rect.width, rect.height)
        self.context.set_source_rgb(0.1, 0.34, 0.564)
        if self.state == gtk.STATE_ACTIVE:
            self.context.set_source_rgb(0.2, 0.4, 0.7)
        self.context.fill()
        img = gtk.Image()
        img.set_from_file(self.icon)
        imgrect = img.get_allocation()
        self.context.set_source_pixbuf(img.get_pixbuf(), rect.x+60, rect.y+1)
        self.context.paint()
        return self.retval

class CustomPickerButton(hildon.PickerButton):
    def __init__(self, icon):
#        print inspect.getsourcelines(hildon.Button)
        hildon.PickerButton.__init__(self, gtk.HILDON_SIZE_AUTO_WIDTH, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.icon = icon
        self.set_size_request(150, 30)
        self.retval = self.connect("expose_event", self.expose)
        
    def expose(self, widget, event):
        self.context = widget.window.cairo_create()
        self.context.rectangle(event.area.x, event.area.y,
                            event.area.width, event.area.height)

        self.context.clip()
        rect = self.get_allocation()
        self.context.rectangle(rect.x, rect.y, rect.width, rect.height)
        self.context.set_source_rgb(0.1, 0.34, 0.564)
        if self.state == gtk.STATE_ACTIVE:
            self.context.set_source_rgb(0.2, 0.4, 0.7)
        self.context.fill()
        img = gtk.Image()
        img.set_from_file(self.icon)
        imgrect = img.get_allocation()
        self.context.set_source_pixbuf(img.get_pixbuf(), rect.x+60, rect.y+1)
        self.context.paint()
        return self.retval

class CustomAlignment(gtk.Alignment):
    def __init__(self, title):
        gtk.Alignment.__init__(self, 0.0, 0.0, 1.0, 1.0)
        self.title = title
        self.set_size_request(300, 16)
        self.retval = self.connect("expose_event", self.expose)

    def expose(self, widget, event):
        self.context = widget.window.cairo_create()
        self.context.rectangle(event.area.x, event.area.y,
                            event.area.width, event.area.height)

        self.context.clip()
        rect = self.get_allocation()
        self.context.rectangle(rect.x, rect.y, rect.width, rect.height)
        self.context.set_source_rgb(0.69, 0.82, 0.5)
        self.context.fill()
        layout = self.context.create_layout()
        layout.set_text(self.title)
        layout.set_font_description(pango.FontDescription("Arial 9"))
        self.context.set_source_rgb(1, 1, 1)
        self.context.move_to(rect.x+5, rect.y)
        self.context.show_layout(layout)
        return self.retval

    def update(self):
        pass
        

class DiggHomePlugin(hildondesktop.HomePluginItem):
    def __init__(self):
        hildondesktop.HomePluginItem.__init__(self)
        self.client = gconf.client_get_default()
        temp = self.client.get_string(KEY)
        if temp != None:
            self.category = temp 
        else:
            self.category = "All"
        self.count = 4
        self.hotness = "Top"
        container = gtk.Alignment(0.0,0.0,1.0,1.0)
        container.set_padding(2,1,0,0)
        self.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse("#1B5790"))
#        container.set_app_paintable(True)        
        logo = gtk.Image()
        logo.set_from_file("/opt/digghomewidget/digg.png")
        list = diggapi.get_toplist(container=self.category,count=self.count)
        mainVBox = gtk.VBox(spacing=1)
        mainVBox.add(logo)
        titletext = self.category
        if titletext == "":
            titletext = "All"
        #titletext = titletext +" > " + self.hotness# + " Updated 21.10.2009"
        self.row = CustomAlignment(titletext)
        mainVBox.add(self.row)
        self.vbox = gtk.VBox(spacing=1)
        self.vbox.set_size_request(-1, self.count*(70+1)-1)
        if list != None:
            for item in list:
                button = DiggItemWidget(item)
                self.vbox.add(button)
        hbox = gtk.HBox(spacing=0)
        update = CustomButton("/opt/digghomewidget/update.png")
        update.connect("clicked", self.update)
        hbox.add(update)
        settings = CustomPickerButton("/opt/digghomewidget/settings.png")
        settings.set_title("Pick a category")
        self.selector = self.show_selector()
        settings.set_selector(self.selector)
        settings.connect("value-changed", self.category_changed)
        hbox.add(settings)
        mainVBox.add(self.vbox)
        mainVBox.add(hbox)
        container.add(mainVBox)
        container.show_all()
        self.add(container)
        self.set_size_request(300, -1)
#        gtk.Settings.gtk-enable-animations = False

    def update(self, widget=None, num=None):
        list = diggapi.get_toplist(container=self.category,count=self.count)
        children = self.vbox.get_children()
        for child in children:
            self.vbox.remove(child)
        if list != None:
            for item in list:
                button = DiggItemWidget(item)
                self.vbox.add(button)
        self.show_all()
        self.client.set_string(KEY, self.category)
        self.row.title = self.category 
        self.row.queue_draw()
        return False


    def category_changed(self, button, user_data=None):
        value = button.get_value()
        value = value.replace("&", "_")
        if value == "All":
            value = ""
        self.category = value
        self.row.title = "Updating..."
        self.row.queue_draw()
        glib.timeout_add(50, self.update)
#        self.update()

        

    def show_selector(self):
        selector = hildon.TouchSelector(text = True) 
        selector.connect("changed", self.selection_changed)
        selector.append_text("All")
        selector.append_text("Technology")
        selector.append_text("World&Business")
        selector.append_text("Entertainment")
        selector.append_text("Gaming")
        selector.append_text("Science")
        selector.append_text("Sports")
        selector.append_text("Lifestyle")
        selector.append_text("Offbeat")
        selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
        return selector
       # pass
#        widget.set_state(gtk.STATE_NORMAL)
#        widget.queue_draw()
    def selection_changed(self, selector, user_data):
        current_selection = selector.get_current_text()
        print current_selection

hd_plugin_type = DiggHomePlugin


if __name__ == "__main__":
    import gobject
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
    obj.show_all()
    gtk.main()

