#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QDebug>
#include <QMainWindow>
#include <QMessageBox>
#include <QSettings>
#include <QAccelerometerReading>
#include "dice.h"
#include "accelerometerpoller.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

    void initSensor();

private:
    QSettings *settings;
    AccelerometerPoller * accelerometerPoller;
    bool landscape;

    qreal previousX;
    qreal previousY;
    qreal previousZ;

    Ui::MainWindow *ui;
    Dice dice;

    void startAccelerometer();
    void stopAccelerometer();

public slots:
    void slotDieAdded(Die const* die);
    void slotDiceCleared();
    void slotSensorReading(QAccelerometerReading * reading);

private slots:
    void on_actionShake_triggered();
    void on_actionRotate_triggered();
    void on_throwDicePushButton_clicked();
    void on_clearDicePushButton_clicked();
    void on_addDiePushButton_clicked();
    void on_actionAbout_triggered();
};

#endif // MAINWINDOW_H
