#include "die.h"

int Die::instances = 0;

/**
 * Constructor.
 * Accepts the number of eyes for this die.
 * A random token is generated here.
 *
 * @fn int eyes - the number of eyes for this die.
 * @fn QWidget *parent - the parent.
 */
Die::Die(int eyes, QObject *parent) :
        QObject(parent)
{
    ++instances;
    qDebug() << "Die instances:" << instances;
    this->eyes = eyes;
    QTime midnight(0, 0, 0, 0);
    int time = midnight.msecsTo(QTime::currentTime());
    qsrand(time);
    randomToken = qrand()%RAND_MAX;
}

/**
 * Destructor.
 *
 * @fn ~Die
 */
Die::~Die()
{
    --instances;
    qDebug() << "Die instances left:" << instances;
}

/**
 * Change the number of eyes for this die.
 *
 * @fn setEyes
 * @param int eyes - The number of eyes for this die.
 */
void Die::setEyes(int eyes)
{
    this->eyes = eyes;
    emit signalEyesChanged(eyes);
}

/**
 * Return the number of eyes for this die.
 *
 * @fn getEyes
 * @return int The number of eyes for this die.
 */
int Die::getEyes() const
{
    return eyes;
}

/**
 * Return number between 1 and the number of eyes + 1.
 *
 * @fn getOutcome
 * @param int random number between 1 and the number of eyes + 1.
 */
int Die::getOutcome() const
{
    QTime midnight(0, 0, 0, 0);
    int time = midnight.msecsTo(QTime::currentTime());
    qsrand((time*qrand())%time);
    int outcome = 0;

    int lowest = 1;
    int highest = getEyes();
    int range=(highest-lowest)+1;
    outcome = (qrand()%highest)+1;
    qDebug() << "Lowest:" << lowest << ", Highest:" << highest << ", Range:" << range << ", Outcome:" << outcome;
    return outcome;
}
