#include "accelerometerpoller.h"

int AccelerometerPoller::instances = 0;

/**
 * Constructor. Sets the dataRate which will be used to calculate the frequency in (Hz) with
 * which this thread will poll the sensors. The sensors are initialised here.
 */
AccelerometerPoller::AccelerometerPoller(int dataRate, QObject *parent) :
    QThread(parent)
{
    ++instances;
    qDebug() << "AccelerometerPoller instances:" << instances;
    setDataRate(dataRate);
    // Lets initialise the sensors.
    initSensor();
    this->poll = true;
}

/**
 * Destructor.
 */
AccelerometerPoller::~AccelerometerPoller()
{
    --instances;
    qDebug() << "AccelerometerPoller instances left:" << instances;
    stop();
}

/**
 * Sets the data rate in Hz.
 */
void AccelerometerPoller::setDataRate(int dataRate)
{
    this->dataRate = dataRate;
    this->hz = 1000/this->dataRate;
}

/**
 * Initialises the QSensor and starts it.
 */
void AccelerometerPoller::initSensor()
{
    // D-BUS for accelerometer readings
//    QDBusConnection connection(QDBusConnection::systemBus());
//    QDBusInterface interface("com.nokia.mce", "/com/nokia/icd", QString(), connection);
//    QDBusPendingReply<QString, QString, QString, int, int, int> reply;
//    reply = interface.asyncCall("get_device_orientation");
//    reply.waitForFinished();
//    x = static_cast<qreal>(reply.argumentAt<3>()) / 1000;
//    y = static_cast<qreal>(reply.argumentAt<4>()) / 1000;
//    z = static_cast<qreal>(reply.argumentAt<5>()) / 1000;
    // start the sensor
    this->sensor.setParent(this);
//    connect(&sensor, SIGNAL(readingChanged()), this, SLOT(slotSensorReadingChanged()));
    this->sensor.start();
}

void AccelerometerPoller::stop()
{
    this->poll = false;
    this->sensor.stop();
}

/**
 * Emits the signal signalSensorReading(QAccelerometerReading).
 */
void AccelerometerPoller::read()
{
    QAccelerometerReading *reading = this->sensor.reading();
    emit signalSensorReading(reading);
}

/**
 * The run method. This handles the frequency of the sensor reading.
 */
void AccelerometerPoller::run()
{
    qDebug() << "Thread frequency" << qreal(this->hz/1000);
    while(poll)
    {
        read();
        msleep(hz);
    }
    qDebug() << "AccelerometerPoller thread stopped";
}
