#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QDebug>
#include <QMainWindow>
#include <QMessageBox>
#include <QSettings>
#include "dice.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    QSettings *settings;
    bool landscape;

    Ui::MainWindow *ui;
    Dice dice;

public slots:
    void slotDieAdded(Die const* die);
    void slotDiceCleared();

private slots:
    void on_actionRotate_triggered();
    void on_throwDicePushButton_clicked();
    void on_clearDicePushButton_clicked();
    void on_addDiePushButton_clicked();
    void on_actionAbout_triggered();
};

#endif // MAINWINDOW_H
