#ifndef TEKSTITVYLE_H
#define TEKSTITVYLE_H

#include "abstracttekstitv.h"
#include <QObject>

class TekstiTvYle : AbstractTekstiTv
{
    Q_OBJECT
public:
    TekstiTvYle();

public slots:

 void getPrediction() = 0;
 void getSubPrediction() = 0;

private slots:

 void predictionReceived(QNetworkReply *reply) = 0;
 void subPredictionReceived(QNetworkReply *reply) = 0;
 void tekstiTvReceived(QNetworkReply *reply) = 0;

signals:

 void receivedTekstiTv(QPixmap *image);
 void receivedPrediction(int page, int subPage);

private:

 void getTekstiTv() = 0;

private:

QString predictionStr;
QString nextPrediction;
QString previousPrediction;
QString nextSubPrediction;
QString previousSubPrediction;

int page;
int subPage;

QPixmap *imageData;

};

#endif // TEKSTITVYLE_H
