#ifndef COMMONTEKSTITV_H
#define COMMONTEKSTITV_H

#include "abstracttekstitv.h"
#include <QObject>

class CommonTekstiTv : public AbstractTekstiTv
{
    Q_OBJECT
public:
    CommonTekstiTv(QString imageUrl, QString subImageUrl, QString predictionUrl, QString subPredictionUrl,
                   QString prevPrediction, QString nextPrediction,
                   QString prevSubPrediction, QString nextSubPrediction, int startPage);

    QString imageUrl();
    QString subImageUrl();
    QString predictionUrl();
    QString subPredictionUrl();
    QString nextPrediction();
    QString previousPrediction();
    QString nextSubPrediction();
    QString previousSubPrediction();
    int startPage();

public slots:

 void getPrediction(int increment);
 void getSubPrediction(int increment);
 void getTekstiTv(int page, int subPage);
 void getTekstiTv(QString url);

private slots:

 void predictionReceived(QNetworkReply *reply);
 void subPredictionReceived(QNetworkReply *reply);
 void tekstiTvReceived(QNetworkReply *reply);

signals:
 void receivedTekstiTv(QPixmap *image);
 void receivedPrediction(int page, int subPage);
 void tekstiTvRequest(bool isBusy);

private:

 QString transformToRealUrl(QString url);

private:

QString m_imageUrl;
QString m_subImageUrl;
QString m_predictionUrl;
QString m_subPredictionUrl;

QString m_predictionStr;
QString m_nextPrediction;
QString m_previousPrediction;
QString m_nextSubPrediction;
QString m_previousSubPrediction;

int m_startPage;
int m_page;
int m_subPage;

QPixmap *m_imageData;

};

#endif // COMMONTEKSTITV_H
