#include "tekstitvyle.h"
#include <QtNetwork>
#include <QPixmap>
#include <QObject>

TekstiTvYle::TekstiTvYle() : AbstractTekstiTv()
{
    previousPrediction = QString("<A HREF=\"http://www.yle.fi/tekstitv/txt/P(\\d+)_01.html\">\\[Edellinen sivu\\]</A>");
    nextPrediction = QString("<A HREF=\"http://www.yle.fi/tekstitv/txt/P(\\d+)_01.html\">\\[Seuraava sivu\\]</A>");
    previousSubPrediction = QString("<A HREF=\"http://www.yle.fi/tekstitv/txt/P(\\d+)_(\\d+).html\">\\[Edellinen alasivu\\]</A>");
    nextSubPrediction = QString("<A HREF=\"http://www.yle.fi/tekstitv/txt/P(\\d+)_(\\d+).html\">\\[Seuraava alasivu\\]</A>");
    page = 100;
    subPage = 1;
}

void TekstiTvYle::getPrediction() {
    QNetworkAccessManager *manager = new QNetworkAccessManager();
    connect(manager, SIGNAL(finished(QNetworkReply*)), this, SLOT(predictionReceived(QNetworkReply*)));
    QString url = "http://www.yle.fi/tekstitv/txt/P" + QString::number(page) + "_01.html";
    manager->get(QNetworkRequest(QUrl(url)));
}

void TekstiTvYle::getSubPrediction() {
    QNetworkAccessManager *manager = new QNetworkAccessManager();
    connect(manager, SIGNAL(finished(QNetworkReply*)),
            this, SLOT(subPredictionReceived(QNetworkReply*)));
    QString subPageStr = (subPage > 9) ? QString::number(subPage) : "0" + QString::number(subPage);
    QString url = "http://www.yle.fi/tekstitv/txt/P" + QString::number(page) + "_" + subPageStr + ".html";
    manager->get(QNetworkRequest(QUrl(url)));
}

void TekstiTvYle::predictionReceived(QNetworkReply *reply) {
    QByteArray data;
    data = reply->readAll();
    QString *dataStr = new QString(data);
    QRegExp regExp(predictionStr);
    int pos = regExp.indexIn(*dataStr);
    if (pos > 1) {
        QString predictedPage = regExp.cap(1);
        page = predictedPage.toInt();
        emit receivedPrediction(page, subPage);
        getTekstiTv();
    }
    delete dataStr;
}

void TekstiTvYle::subPredictionReceived(QNetworkReply *reply) {
    QByteArray data;
    data = reply->readAll();
    QString *dataStr = new QString(data);
    QRegExp regExp(predictionStr);
    int pos = regExp.indexIn(*dataStr);
    if (pos > 1) {
        QString predictedPage = regExp.cap(2);
        subPage = predictedPage.toInt();
        if (subPage < 1) { subPage = 1; }
        emit receivedPrediction(page, subPage);
        getTekstiTv();
    }
}

void TekstiTvYle::getTekstiTv() {
    QNetworkAccessManager *manager = new QNetworkAccessManager();
    connect(manager, SIGNAL(finished(QNetworkReply*)),
            this, SLOT(tekstiTvReceived(QNetworkReply*)));
    QString subPageStr = (subPage > 9) ? QString::number(subPage) : "0" + QString::number(subPage);
    QString url = "http://www.yle.fi/tekstitv/images/P" + QString::number(page) + "_" + subPageStr + ".gif";
    manager->get(QNetworkRequest(QUrl(url)));
}

void TekstiTvYle::tekstiTvReceived(QNetworkReply *reply) {
    QByteArray imgTextTv = reply->readAll();
    imageData = new QPixmap();
    bool success = imageData->loadFromData(imgTextTv);
    if (!imageData->isNull() && success) {
        //QPixmap scaledMap = imageData->scaled(imageWidth, imageHeight, Qt::KeepAspectRatio, Qt::SmoothTransformation);
        // connect to ui
        emit receivedTekstiTv(imageData);
    }
}


