#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "tekstitv.h"
#include <QMainWindow>

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    MainWindow();
    void setMainWidget(TekstiTv *main);
    void setupMenuBar();
    QStandardItemModel* createModel(QList<QString> options);
    void populateListModel(QStandardItemModel *model);

public slots:
    void orientationChanged(const QString &newOrientation);
    void actionSwitchSite();
protected:
    bool event(QEvent *ev);

private:
    void createFingerKeys();
    void addRotationAwareness();
    void setLandscape();
    void setPortrait();

private:
    TekstiTv *main;
    QMenuBar *menuBar;


signals:
    void siteSelected(QString siteName);
};

#endif // MAINWINDOW_H
