#!/bin/sh

fnCheckName()
{
if [ ! -d "$1" ]
 then
  run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Directory deleted$extra"
 else
  run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Warning: Failed to delete directory$extra"
 fi
}

#--------------------------------------------------------- Main Code

zenity --title="Confirm deletion of directory" --text="$1" --warning  || exit

case $1 in
 /home/user*)
    rm -r $1
    ;;
 /media/*)
    rm -r $1
    ;;
 /*)
    rm -r $1
    if [ -f "$1" ]
        then
        zenity --title="Deletion failed" --text="Want to delete it as ROOT?" --question || exit
	sudo rm -r $1
	extra="\n as ROOT"
        fi
    ;;
 esac
fnCheckName $1
