#!/bin/sh

fnCheckName()
{
missing="no"
for i in $1\*
do
 [ ! -f "$2\$i" ] && [ ! -d $2\$1 ] && missing="yes"
done

if [ $missing="no" ]
 then
  run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Contents copied sucessfully$extra"
 else
  run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Warning: Failed to copy files"
 fi
}

#--------------------------------------------------------- Main Code

name=$( zenity --title="Copy contents of: $1" --text="$1" --file-selection --directory ) || exit

case $name in
 /home/user*)
    cp $1/* $name
    ;;
 /media/*)
    cp $1/* $name
    ;;
 /*)
    cp $1/* $name
    if [ $? != 0 ]
        then
         zenity --title="An error occured" --text="Want to copy it as ROOT?" --question || exit
	 sudo cp $1/* $name
	 extra=" as ROOT"
        fi
    ;;
esac

fnCheckName $1 $name
