#!/bin/sh

fnCheckName()
{
if [ -f "$1" ]
 then
  run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"File Copied$extra"
 else
  run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Warning: Copy Failed!"
fi
}

#--------------------------------------------------------- Main Code

name=$( zenity --title="Copy file" --text="$1" --file-selection --directory ) || exit

name=$name/$(basename $1)

case $name in
 /home/user*)
    cp $1 $name
    ;;
 /media/*)
    cp $1 $name
    ;;
 /*)
    cp $1 $name
    if [ ! -f "$name" ]
        then
        zenity --title="Copy failed" --text="Want to copy it as ROOT?" --question || exit
	sudo cp $1 $name
	extra=" as ROOT"
        fi
    ;;
 esac
fnCheckName $name
